/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.EligibilityRequest;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.RemittanceOutcomeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="EligibilityResponse", profile="http://hl7.org/fhir/profiles/EligibilityResponse", id="eligibilityresponse")
public class EligibilityResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="EligibilityResponse.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="request", order=1, min=0, max=1, summary=false, modifier=false, type={EligibilityRequest.class})
    @Description(shortDefinition="", formalDefinition="Original request resource reference")
    private ResourceReferenceDt myRequest;
    @Child(name="outcome", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Transaction status: error, complete")
    private BoundCodeDt<RemittanceOutcomeEnum> myOutcome;
    @Child(name="disposition", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the status of the adjudication.")
    private StringDt myDisposition;
    @Child(name="ruleset", type={CodingDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when the enclosed suite of services were performed or completed")
    private DateTimeDt myCreated;
    @Child(name="organization", order=7, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The Insurer who produced this adjudicated response.")
    private ResourceReferenceDt myOrganization;
    @Child(name="requestProvider", order=8, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestProvider;
    @Child(name="requestOrganization", order=9, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestOrganization;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRequest, this.myOutcome, this.myDisposition, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myOrganization, this.myRequestProvider, this.myRequestOrganization});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRequest, this.myOutcome, this.myDisposition, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myOrganization, this.myRequestProvider, this.myRequestOrganization});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public EligibilityResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public EligibilityResponse addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public EligibilityResponse setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public BoundCodeDt<RemittanceOutcomeEnum> getOutcomeElement() {
        if (this.myOutcome == null) {
            this.myOutcome = new BoundCodeDt(RemittanceOutcomeEnum.VALUESET_BINDER);
        }
        return this.myOutcome;
    }

    public String getOutcome() {
        return (String)this.getOutcomeElement().getValue();
    }

    public EligibilityResponse setOutcome(BoundCodeDt<RemittanceOutcomeEnum> theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public EligibilityResponse setOutcome(RemittanceOutcomeEnum theValue) {
        this.getOutcomeElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getDispositionElement() {
        if (this.myDisposition == null) {
            this.myDisposition = new StringDt();
        }
        return this.myDisposition;
    }

    public String getDisposition() {
        return (String)this.getDispositionElement().getValue();
    }

    public EligibilityResponse setDisposition(StringDt theValue) {
        this.myDisposition = theValue;
        return this;
    }

    public EligibilityResponse setDisposition(String theString) {
        this.myDisposition = new StringDt(theString);
        return this;
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public EligibilityResponse setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public EligibilityResponse setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public EligibilityResponse setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public EligibilityResponse setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public EligibilityResponse setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public EligibilityResponse setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestProvider() {
        if (this.myRequestProvider == null) {
            this.myRequestProvider = new ResourceReferenceDt();
        }
        return this.myRequestProvider;
    }

    public EligibilityResponse setRequestProvider(ResourceReferenceDt theValue) {
        this.myRequestProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestOrganization() {
        if (this.myRequestOrganization == null) {
            this.myRequestOrganization = new ResourceReferenceDt();
        }
        return this.myRequestOrganization;
    }

    public EligibilityResponse setRequestOrganization(ResourceReferenceDt theValue) {
        this.myRequestOrganization = theValue;
        return this;
    }

    public String getResourceName() {
        return "EligibilityResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

