/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.QuantityDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.dstu2.valueset.GroupTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Group", profile="http://hl7.org/fhir/profiles/Group", id="group")
public class Group
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Group.type", description="The type of resources the group contains", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="code", path="Group.code", description="The kind of resources contained", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="actual", path="Group.actual", description="", type="token")
    public static final String SP_ACTUAL = "actual";
    public static final TokenClientParam ACTUAL = new TokenClientParam("actual");
    @SearchParamDefinition(name="identifier", path="Group.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="member", path="Group.member.entity", description="", type="reference")
    public static final String SP_MEMBER = "member";
    public static final ReferenceClientParam MEMBER = new ReferenceClientParam("member");
    @SearchParamDefinition(name="characteristic", path="Group.characteristic.code", description="", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    @SearchParamDefinition(name="value", path="Group.characteristic.value[x]", description="", type="token")
    public static final String SP_VALUE = "value";
    public static final TokenClientParam VALUE = new TokenClientParam("value");
    @SearchParamDefinition(name="exclude", path="Group.characteristic.exclude", description="", type="token")
    public static final String SP_EXCLUDE = "exclude";
    public static final TokenClientParam EXCLUDE = new TokenClientParam("exclude");
    @SearchParamDefinition(name="characteristic-value", path="characteristic & value", description="A composite of both characteristic and value", type="composite", compositeOf={"characteristic", "value"})
    public static final String SP_CHARACTERISTIC_VALUE = "characteristic-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CHARACTERISTIC_VALUE = new CompositeClientParam("characteristic-value");
    public static final Include INCLUDE_MEMBER = new Include("Group:member");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="A unique business identifier for this group")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Identifies the broad classification of the kind of resources the group includes")
    private BoundCodeDt<GroupTypeEnum> myType;
    @Child(name="actual", type={BooleanDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If true, indicates that the resource refers to a specific group of real individuals.  If false, the group defines a set of intended individuals")
    private BooleanDt myActual;
    @Child(name="code", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Provides a specific type of resource the group includes; e.g. \"cow\", \"syringe\", etc.")
    private CodeableConceptDt myCode;
    @Child(name="name", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A label assigned to the group for human identification and communication")
    private StringDt myName;
    @Child(name="quantity", type={UnsignedIntDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A count of the number of resource instances that are part of the group")
    private UnsignedIntDt myQuantity;
    @Child(name="characteristic", order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the traits shared by members of the group")
    private List<Characteristic> myCharacteristic;
    @Child(name="member", order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the resource instances that are members of the group.")
    private List<Member> myMember;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myActual, this.myCode, this.myName, this.myQuantity, this.myCharacteristic, this.myMember});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myActual, this.myCode, this.myName, this.myQuantity, this.myCharacteristic, this.myMember});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Group setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Group addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<GroupTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(GroupTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public String getType() {
        return (String)this.getTypeElement().getValue();
    }

    public Group setType(BoundCodeDt<GroupTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Group setType(GroupTypeEnum theValue) {
        this.getTypeElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getActualElement() {
        if (this.myActual == null) {
            this.myActual = new BooleanDt();
        }
        return this.myActual;
    }

    public Boolean getActual() {
        return (Boolean)this.getActualElement().getValue();
    }

    public Group setActual(BooleanDt theValue) {
        this.myActual = theValue;
        return this;
    }

    public Group setActual(boolean theBoolean) {
        this.myActual = new BooleanDt(theBoolean);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Group setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public Group setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Group setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public UnsignedIntDt getQuantityElement() {
        if (this.myQuantity == null) {
            this.myQuantity = new UnsignedIntDt();
        }
        return this.myQuantity;
    }

    public Integer getQuantity() {
        return (Integer)this.getQuantityElement().getValue();
    }

    public Group setQuantity(UnsignedIntDt theValue) {
        this.myQuantity = theValue;
        return this;
    }

    public Group setQuantity(int theInteger) {
        this.myQuantity = new UnsignedIntDt(theInteger);
        return this;
    }

    public List<Characteristic> getCharacteristic() {
        if (this.myCharacteristic == null) {
            this.myCharacteristic = new ArrayList<Characteristic>();
        }
        return this.myCharacteristic;
    }

    public Group setCharacteristic(List<Characteristic> theValue) {
        this.myCharacteristic = theValue;
        return this;
    }

    public Characteristic addCharacteristic() {
        Characteristic newType = new Characteristic();
        this.getCharacteristic().add(newType);
        return newType;
    }

    public Group addCharacteristic(Characteristic theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCharacteristic().add(theValue);
        return this;
    }

    public Characteristic getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            return this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<Member> getMember() {
        if (this.myMember == null) {
            this.myMember = new ArrayList<Member>();
        }
        return this.myMember;
    }

    public Group setMember(List<Member> theValue) {
        this.myMember = theValue;
        return this;
    }

    public Member addMember() {
        Member newType = new Member();
        this.getMember().add(newType);
        return newType;
    }

    public Group addMember(Member theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMember().add(theValue);
        return this;
    }

    public Member getMemberFirstRep() {
        if (this.getMember().isEmpty()) {
            return this.addMember();
        }
        return this.getMember().get(0);
    }

    public String getResourceName() {
        return "Group";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Member
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="entity", order=0, min=1, max=1, summary=false, modifier=false, type={Patient.class, Practitioner.class, Device.class, Medication.class, Substance.class})
        @Description(shortDefinition="", formalDefinition="A reference to the entity that is a member of the group. Must be consistent with Group.type")
        private ResourceReferenceDt myEntity;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period that the member was in the group, if known")
        private PeriodDt myPeriod;
        @Child(name="inactive", type={BooleanDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A flag to indicate that the member is no longer in the group, but previously may have been a member")
        private BooleanDt myInactive;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myEntity, this.myPeriod, this.myInactive});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEntity, this.myPeriod, this.myInactive});
        }

        public ResourceReferenceDt getEntity() {
            if (this.myEntity == null) {
                this.myEntity = new ResourceReferenceDt();
            }
            return this.myEntity;
        }

        public Member setEntity(ResourceReferenceDt theValue) {
            this.myEntity = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Member setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public BooleanDt getInactiveElement() {
            if (this.myInactive == null) {
                this.myInactive = new BooleanDt();
            }
            return this.myInactive;
        }

        public Boolean getInactive() {
            return (Boolean)this.getInactiveElement().getValue();
        }

        public Member setInactive(BooleanDt theValue) {
            this.myInactive = theValue;
            return this;
        }

        public Member setInactive(boolean theBoolean) {
            this.myInactive = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class Characteristic
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code that identifies the kind of trait being asserted")
        private CodeableConceptDt myCode;
        @Child(name="value", order=1, min=1, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BooleanDt.class, QuantityDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="The value of the trait that holds (or does not hold - see 'exclude') for members of the group")
        private IDatatype myValue;
        @Child(name="exclude", type={BooleanDt.class}, order=2, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="If true, indicates the characteristic is one that is NOT held by members of the group")
        private BooleanDt myExclude;
        @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period over which the characteristic is tested; e.g. the patient had an operation during the month of June")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myValue, this.myExclude, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myValue, this.myExclude, this.myPeriod});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Characteristic setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public Characteristic setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }

        public BooleanDt getExcludeElement() {
            if (this.myExclude == null) {
                this.myExclude = new BooleanDt();
            }
            return this.myExclude;
        }

        public Boolean getExclude() {
            return (Boolean)this.getExcludeElement().getValue();
        }

        public Characteristic setExclude(BooleanDt theValue) {
            this.myExclude = theValue;
            return this;
        }

        public Characteristic setExclude(boolean theBoolean) {
            this.myExclude = new BooleanDt(theBoolean);
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Characteristic setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }
}

