/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Procedure;
import ca.uhn.fhir.model.dstu2.valueset.InstanceAvailabilityEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.OidDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ImagingStudy", profile="http://hl7.org/fhir/profiles/ImagingStudy", id="imagingstudy")
public class ImagingStudy
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="ImagingStudy.patient", description="Who the study is about", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="started", path="ImagingStudy.started", description="When the study was started", type="date")
    public static final String SP_STARTED = "started";
    public static final DateClientParam STARTED = new DateClientParam("started");
    @SearchParamDefinition(name="accession", path="ImagingStudy.accession", description="The accession identifier for the study", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="study", path="ImagingStudy.uid", description="The study identifier for the image", type="uri")
    public static final String SP_STUDY = "study";
    public static final UriClientParam STUDY = new UriClientParam("study");
    @SearchParamDefinition(name="series", path="ImagingStudy.series.uid", description="The identifier of the series of images", type="uri")
    public static final String SP_SERIES = "series";
    public static final UriClientParam SERIES = new UriClientParam("series");
    @SearchParamDefinition(name="modality", path="ImagingStudy.series.modality", description="The modality of the series", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="bodysite", path="ImagingStudy.series.bodySite", description="The body site studied", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="uid", path="ImagingStudy.series.instance.uid", description="The instance unique identifier", type="uri")
    public static final String SP_UID = "uid";
    public static final UriClientParam UID = new UriClientParam("uid");
    @SearchParamDefinition(name="dicom-class", path="ImagingStudy.series.instance.sopClass", description="The type of the instance", type="uri")
    public static final String SP_DICOM_CLASS = "dicom-class";
    public static final UriClientParam DICOM_CLASS = new UriClientParam("dicom-class");
    @SearchParamDefinition(name="order", path="ImagingStudy.order", description="The order for the image", type="reference")
    public static final String SP_ORDER = "order";
    public static final ReferenceClientParam ORDER = new ReferenceClientParam("order");
    public static final Include INCLUDE_ORDER = new Include("ImagingStudy:order");
    public static final Include INCLUDE_PATIENT = new Include("ImagingStudy:patient");
    @Child(name="started", type={DateTimeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="Date and Time the study started")
    private DateTimeDt myStarted;
    @Child(name="patient", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient imaged in the study.")
    private ResourceReferenceDt myPatient;
    @Child(name="uid", type={OidDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Formal identifier for the study")
    private OidDt myUid;
    @Child(name="accession", type={IdentifierDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Accession Number is an identifier related to some aspect of imaging workflow and data management. Usage may vary across different institutions.  See for instance [IHE Radiology Technical Framework Volume 1 Appendix A](http://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Rev13.0_Vol1_FT_2014-07-30.pdf)")
    private IdentifierDt myAccession;
    @Child(name="identifier", type={IdentifierDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Other identifiers for the study")
    private List<IdentifierDt> myIdentifier;
    @Child(name="order", order=5, min=0, max=-1, summary=false, modifier=false, type={DiagnosticOrder.class})
    @Description(shortDefinition="", formalDefinition="A list of the diagnostic orders that resulted in this imaging study being performed")
    private List<ResourceReferenceDt> myOrder;
    @Child(name="modalityList", type={CodingDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19)")
    private List<CodingDt> myModalityList;
    @Child(name="referrer", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.cause", formalDefinition="The requesting/referring physician")
    private ResourceReferenceDt myReferrer;
    @Child(name="availability", type={CodeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="status", formalDefinition="Availability of study (online, offline or nearline)")
    private BoundCodeDt<InstanceAvailabilityEnum> myAvailability;
    @Child(name="url", type={UriDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="WADO-RS resource where Study is available.")
    private UriDt myUrl;
    @Child(name="numberOfSeries", type={UnsignedIntDt.class}, order=10, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Number of Series in Study")
    private UnsignedIntDt myNumberOfSeries;
    @Child(name="numberOfInstances", type={UnsignedIntDt.class}, order=11, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Number of SOP Instances in Study")
    private UnsignedIntDt myNumberOfInstances;
    @Child(name="procedure", order=12, min=0, max=-1, summary=false, modifier=false, type={Procedure.class})
    @Description(shortDefinition="", formalDefinition="Type of procedure performed")
    private List<ResourceReferenceDt> myProcedure;
    @Child(name="interpreter", order=13, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.witness", formalDefinition="Who read the study and interpreted the images or other content")
    private ResourceReferenceDt myInterpreter;
    @Child(name="description", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Institution-generated description or classification of the Study performed")
    private StringDt myDescription;
    @Child(name="series", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Each study has one or more series of images or other content")
    private List<Series> mySeries;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myStarted, this.myPatient, this.myUid, this.myAccession, this.myIdentifier, this.myOrder, this.myModalityList, this.myReferrer, this.myAvailability, this.myUrl, this.myNumberOfSeries, this.myNumberOfInstances, this.myProcedure, this.myInterpreter, this.myDescription, this.mySeries});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStarted, this.myPatient, this.myUid, this.myAccession, this.myIdentifier, this.myOrder, this.myModalityList, this.myReferrer, this.myAvailability, this.myUrl, this.myNumberOfSeries, this.myNumberOfInstances, this.myProcedure, this.myInterpreter, this.myDescription, this.mySeries});
    }

    public DateTimeDt getStartedElement() {
        if (this.myStarted == null) {
            this.myStarted = new DateTimeDt();
        }
        return this.myStarted;
    }

    public Date getStarted() {
        return (Date)this.getStartedElement().getValue();
    }

    public ImagingStudy setStarted(DateTimeDt theValue) {
        this.myStarted = theValue;
        return this;
    }

    public ImagingStudy setStarted(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStarted = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ImagingStudy setStartedWithSecondsPrecision(Date theDate) {
        this.myStarted = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ImagingStudy setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public OidDt getUidElement() {
        if (this.myUid == null) {
            this.myUid = new OidDt();
        }
        return this.myUid;
    }

    public String getUid() {
        return (String)this.getUidElement().getValue();
    }

    public ImagingStudy setUid(OidDt theValue) {
        this.myUid = theValue;
        return this;
    }

    public IdentifierDt getAccession() {
        if (this.myAccession == null) {
            this.myAccession = new IdentifierDt();
        }
        return this.myAccession;
    }

    public ImagingStudy setAccession(IdentifierDt theValue) {
        this.myAccession = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ImagingStudy setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ImagingStudy addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<ResourceReferenceDt> getOrder() {
        if (this.myOrder == null) {
            this.myOrder = new ArrayList<ResourceReferenceDt>();
        }
        return this.myOrder;
    }

    public ImagingStudy setOrder(List<ResourceReferenceDt> theValue) {
        this.myOrder = theValue;
        return this;
    }

    public ResourceReferenceDt addOrder() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getOrder().add(newType);
        return newType;
    }

    public List<CodingDt> getModalityList() {
        if (this.myModalityList == null) {
            this.myModalityList = new ArrayList<CodingDt>();
        }
        return this.myModalityList;
    }

    public ImagingStudy setModalityList(List<CodingDt> theValue) {
        this.myModalityList = theValue;
        return this;
    }

    public CodingDt addModalityList() {
        CodingDt newType = new CodingDt();
        this.getModalityList().add(newType);
        return newType;
    }

    public ImagingStudy addModalityList(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getModalityList().add(theValue);
        return this;
    }

    public CodingDt getModalityListFirstRep() {
        if (this.getModalityList().isEmpty()) {
            return this.addModalityList();
        }
        return this.getModalityList().get(0);
    }

    public ResourceReferenceDt getReferrer() {
        if (this.myReferrer == null) {
            this.myReferrer = new ResourceReferenceDt();
        }
        return this.myReferrer;
    }

    public ImagingStudy setReferrer(ResourceReferenceDt theValue) {
        this.myReferrer = theValue;
        return this;
    }

    public BoundCodeDt<InstanceAvailabilityEnum> getAvailabilityElement() {
        if (this.myAvailability == null) {
            this.myAvailability = new BoundCodeDt(InstanceAvailabilityEnum.VALUESET_BINDER);
        }
        return this.myAvailability;
    }

    public String getAvailability() {
        return (String)this.getAvailabilityElement().getValue();
    }

    public ImagingStudy setAvailability(BoundCodeDt<InstanceAvailabilityEnum> theValue) {
        this.myAvailability = theValue;
        return this;
    }

    public ImagingStudy setAvailability(InstanceAvailabilityEnum theValue) {
        this.getAvailabilityElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public ImagingStudy setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public ImagingStudy setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public UnsignedIntDt getNumberOfSeriesElement() {
        if (this.myNumberOfSeries == null) {
            this.myNumberOfSeries = new UnsignedIntDt();
        }
        return this.myNumberOfSeries;
    }

    public Integer getNumberOfSeries() {
        return (Integer)this.getNumberOfSeriesElement().getValue();
    }

    public ImagingStudy setNumberOfSeries(UnsignedIntDt theValue) {
        this.myNumberOfSeries = theValue;
        return this;
    }

    public ImagingStudy setNumberOfSeries(int theInteger) {
        this.myNumberOfSeries = new UnsignedIntDt(theInteger);
        return this;
    }

    public UnsignedIntDt getNumberOfInstancesElement() {
        if (this.myNumberOfInstances == null) {
            this.myNumberOfInstances = new UnsignedIntDt();
        }
        return this.myNumberOfInstances;
    }

    public Integer getNumberOfInstances() {
        return (Integer)this.getNumberOfInstancesElement().getValue();
    }

    public ImagingStudy setNumberOfInstances(UnsignedIntDt theValue) {
        this.myNumberOfInstances = theValue;
        return this;
    }

    public ImagingStudy setNumberOfInstances(int theInteger) {
        this.myNumberOfInstances = new UnsignedIntDt(theInteger);
        return this;
    }

    public List<ResourceReferenceDt> getProcedure() {
        if (this.myProcedure == null) {
            this.myProcedure = new ArrayList<ResourceReferenceDt>();
        }
        return this.myProcedure;
    }

    public ImagingStudy setProcedure(List<ResourceReferenceDt> theValue) {
        this.myProcedure = theValue;
        return this;
    }

    public ResourceReferenceDt addProcedure() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getProcedure().add(newType);
        return newType;
    }

    public ResourceReferenceDt getInterpreter() {
        if (this.myInterpreter == null) {
            this.myInterpreter = new ResourceReferenceDt();
        }
        return this.myInterpreter;
    }

    public ImagingStudy setInterpreter(ResourceReferenceDt theValue) {
        this.myInterpreter = theValue;
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ImagingStudy setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ImagingStudy setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<Series> getSeries() {
        if (this.mySeries == null) {
            this.mySeries = new ArrayList<Series>();
        }
        return this.mySeries;
    }

    public ImagingStudy setSeries(List<Series> theValue) {
        this.mySeries = theValue;
        return this;
    }

    public Series addSeries() {
        Series newType = new Series();
        this.getSeries().add(newType);
        return newType;
    }

    public ImagingStudy addSeries(Series theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSeries().add(theValue);
        return this;
    }

    public Series getSeriesFirstRep() {
        if (this.getSeries().isEmpty()) {
            return this.addSeries();
        }
        return this.getSeries().get(0);
    }

    public String getResourceName() {
        return "ImagingStudy";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class SeriesInstance
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="number", type={UnsignedIntDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The number of instance in the series")
        private UnsignedIntDt myNumber;
        @Child(name="uid", type={OidDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Formal identifier for this image or other content")
        private OidDt myUid;
        @Child(name="sopClass", type={OidDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="DICOM instance  type")
        private OidDt mySopClass;
        @Child(name="type", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A human-friendly SOP Class name")
        private StringDt myType;
        @Child(name="title", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The description of the instance")
        private StringDt myTitle;
        @Child(name="content", type={AttachmentDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Content of the instance or a rendering thereof (e.g. a JPEG of an image, or an XML of a structured report). May be represented for example by inline encoding; by a URL reference to a WADO-RS service that makes the instance available; or to a FHIR Resource (e.g. Media, Document, etc.). Multiple content attachments may be used for alternate representations of the instance.")
        private List<AttachmentDt> myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myNumber, this.myUid, this.mySopClass, this.myType, this.myTitle, this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumber, this.myUid, this.mySopClass, this.myType, this.myTitle, this.myContent});
        }

        public UnsignedIntDt getNumberElement() {
            if (this.myNumber == null) {
                this.myNumber = new UnsignedIntDt();
            }
            return this.myNumber;
        }

        public Integer getNumber() {
            return (Integer)this.getNumberElement().getValue();
        }

        public SeriesInstance setNumber(UnsignedIntDt theValue) {
            this.myNumber = theValue;
            return this;
        }

        public SeriesInstance setNumber(int theInteger) {
            this.myNumber = new UnsignedIntDt(theInteger);
            return this;
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public String getUid() {
            return (String)this.getUidElement().getValue();
        }

        public SeriesInstance setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public OidDt getSopClassElement() {
            if (this.mySopClass == null) {
                this.mySopClass = new OidDt();
            }
            return this.mySopClass;
        }

        public String getSopClass() {
            return (String)this.getSopClassElement().getValue();
        }

        public SeriesInstance setSopClass(OidDt theValue) {
            this.mySopClass = theValue;
            return this;
        }

        public StringDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public SeriesInstance setType(StringDt theValue) {
            this.myType = theValue;
            return this;
        }

        public SeriesInstance setType(String theString) {
            this.myType = new StringDt(theString);
            return this;
        }

        public StringDt getTitleElement() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public String getTitle() {
            return (String)this.getTitleElement().getValue();
        }

        public SeriesInstance setTitle(StringDt theValue) {
            this.myTitle = theValue;
            return this;
        }

        public SeriesInstance setTitle(String theString) {
            this.myTitle = new StringDt(theString);
            return this;
        }

        public List<AttachmentDt> getContent() {
            if (this.myContent == null) {
                this.myContent = new ArrayList<AttachmentDt>();
            }
            return this.myContent;
        }

        public SeriesInstance setContent(List<AttachmentDt> theValue) {
            this.myContent = theValue;
            return this;
        }

        public AttachmentDt addContent() {
            AttachmentDt newType = new AttachmentDt();
            this.getContent().add(newType);
            return newType;
        }

        public SeriesInstance addContent(AttachmentDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getContent().add(theValue);
            return this;
        }

        public AttachmentDt getContentFirstRep() {
            if (this.getContent().isEmpty()) {
                return this.addContent();
            }
            return this.getContent().get(0);
        }
    }

    @Block
    public static class Series
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="number", type={UnsignedIntDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The Numeric identifier of this series in the study.")
        private UnsignedIntDt myNumber;
        @Child(name="modality", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The modality of this series sequence")
        private CodingDt myModality;
        @Child(name="uid", type={OidDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Formal identifier for this series")
        private OidDt myUid;
        @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A description of the series")
        private StringDt myDescription;
        @Child(name="numberOfInstances", type={UnsignedIntDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Number of SOP Instances in Series.")
        private UnsignedIntDt myNumberOfInstances;
        @Child(name="availability", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Availability of series (online, offline or nearline)")
        private BoundCodeDt<InstanceAvailabilityEnum> myAvailability;
        @Child(name="url", type={UriDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="URI/URL specifying the location of the referenced series using WADO-RS")
        private UriDt myUrl;
        @Child(name="bodySite", type={CodingDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Body part examined. See  DICOM Part 16 Annex L for the mapping from DICOM to Snomed CT")
        private CodingDt myBodySite;
        @Child(name="laterality", type={CodingDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Laterality if body site is paired anatomic structure and laterality is not pre-coordinated in body site code.")
        private CodingDt myLaterality;
        @Child(name="started", type={DateTimeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date and time the series was started.")
        private DateTimeDt myStarted;
        @Child(name="instance", order=10, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A single SOP Instance within the series, e.g. an image, or presentation state.")
        private List<SeriesInstance> myInstance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myNumber, this.myModality, this.myUid, this.myDescription, this.myNumberOfInstances, this.myAvailability, this.myUrl, this.myBodySite, this.myLaterality, this.myStarted, this.myInstance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumber, this.myModality, this.myUid, this.myDescription, this.myNumberOfInstances, this.myAvailability, this.myUrl, this.myBodySite, this.myLaterality, this.myStarted, this.myInstance});
        }

        public UnsignedIntDt getNumberElement() {
            if (this.myNumber == null) {
                this.myNumber = new UnsignedIntDt();
            }
            return this.myNumber;
        }

        public Integer getNumber() {
            return (Integer)this.getNumberElement().getValue();
        }

        public Series setNumber(UnsignedIntDt theValue) {
            this.myNumber = theValue;
            return this;
        }

        public Series setNumber(int theInteger) {
            this.myNumber = new UnsignedIntDt(theInteger);
            return this;
        }

        public CodingDt getModality() {
            if (this.myModality == null) {
                this.myModality = new CodingDt();
            }
            return this.myModality;
        }

        public Series setModality(CodingDt theValue) {
            this.myModality = theValue;
            return this;
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public String getUid() {
            return (String)this.getUidElement().getValue();
        }

        public Series setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Series setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Series setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public UnsignedIntDt getNumberOfInstancesElement() {
            if (this.myNumberOfInstances == null) {
                this.myNumberOfInstances = new UnsignedIntDt();
            }
            return this.myNumberOfInstances;
        }

        public Integer getNumberOfInstances() {
            return (Integer)this.getNumberOfInstancesElement().getValue();
        }

        public Series setNumberOfInstances(UnsignedIntDt theValue) {
            this.myNumberOfInstances = theValue;
            return this;
        }

        public Series setNumberOfInstances(int theInteger) {
            this.myNumberOfInstances = new UnsignedIntDt(theInteger);
            return this;
        }

        public BoundCodeDt<InstanceAvailabilityEnum> getAvailabilityElement() {
            if (this.myAvailability == null) {
                this.myAvailability = new BoundCodeDt(InstanceAvailabilityEnum.VALUESET_BINDER);
            }
            return this.myAvailability;
        }

        public String getAvailability() {
            return (String)this.getAvailabilityElement().getValue();
        }

        public Series setAvailability(BoundCodeDt<InstanceAvailabilityEnum> theValue) {
            this.myAvailability = theValue;
            return this;
        }

        public Series setAvailability(InstanceAvailabilityEnum theValue) {
            this.getAvailabilityElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public Series setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public Series setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public CodingDt getBodySite() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodingDt();
            }
            return this.myBodySite;
        }

        public Series setBodySite(CodingDt theValue) {
            this.myBodySite = theValue;
            return this;
        }

        public CodingDt getLaterality() {
            if (this.myLaterality == null) {
                this.myLaterality = new CodingDt();
            }
            return this.myLaterality;
        }

        public Series setLaterality(CodingDt theValue) {
            this.myLaterality = theValue;
            return this;
        }

        public DateTimeDt getStartedElement() {
            if (this.myStarted == null) {
                this.myStarted = new DateTimeDt();
            }
            return this.myStarted;
        }

        public Date getStarted() {
            return (Date)this.getStartedElement().getValue();
        }

        public Series setStarted(DateTimeDt theValue) {
            this.myStarted = theValue;
            return this;
        }

        public Series setStarted(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myStarted = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Series setStartedWithSecondsPrecision(Date theDate) {
            this.myStarted = new DateTimeDt(theDate);
            return this;
        }

        public List<SeriesInstance> getInstance() {
            if (this.myInstance == null) {
                this.myInstance = new ArrayList<SeriesInstance>();
            }
            return this.myInstance;
        }

        public Series setInstance(List<SeriesInstance> theValue) {
            this.myInstance = theValue;
            return this;
        }

        public SeriesInstance addInstance() {
            SeriesInstance newType = new SeriesInstance();
            this.getInstance().add(newType);
            return newType;
        }

        public Series addInstance(SeriesInstance theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getInstance().add(theValue);
            return this;
        }

        public SeriesInstance getInstanceFirstRep() {
            if (this.getInstance().isEmpty()) {
                return this.addInstance();
            }
            return this.getInstance().get(0);
        }
    }
}

