/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.StructureDefinition;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.GuideDependencyTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.GuidePageKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.GuideResourcePurposeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ImplementationGuide", profile="http://hl7.org/fhir/profiles/ImplementationGuide", id="implementationguide")
public class ImplementationGuide
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="ImplementationGuide.url", description="", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ImplementationGuide.version", description="The version identifier of the implementation guide", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="ImplementationGuide.name", description="Name of the implementation guide", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ImplementationGuide.publisher", description="Name of the publisher of the implementation guide", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="ImplementationGuide.description", description="Text search in the description of the implementation guide", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="ImplementationGuide.status", description="The current status of the implementation guide", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="ImplementationGuide.date", description="The implementation guide publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="context", path="ImplementationGuide.useContext", description="A use context assigned to the structure", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="experimental", path="ImplementationGuide.experimental", description="", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="dependency", path="ImplementationGuide.dependency.uri", description="", type="uri")
    public static final String SP_DEPENDENCY = "dependency";
    public static final UriClientParam DEPENDENCY = new UriClientParam("dependency");
    @Child(name="url", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An absolute URL that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this implementation guide is (or will be) published")
    private UriDt myUrl;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id.version", formalDefinition="The identifier that is used to identify this version of the Implementation Guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Implementation Guide author manually")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name identifying the Implementation Guide")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="status", formalDefinition="The status of the Implementation Guide")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="This Implementation Guide was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the individual or organization that published the implementation guide")
    private StringDt myPublisher;
    @Child(name="contact", order=6, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date this version of the implementation guide was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the Implementation Guide and its use")
    private StringDt myDescription;
    @Child(name="useContext", type={CodeableConceptDt.class}, order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of implementation guides. The most common use of this element is to represent the country / jurisdiction for which this implementation guide was defined")
    private List<CodeableConceptDt> myUseContext;
    @Child(name="copyright", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings")
    private StringDt myCopyright;
    @Child(name="fhirVersion", type={IdDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is $version$ for this version")
    private IdDt myFhirVersion;
    @Child(name="dependency", order=12, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides")
    private List<Dependency> myDependency;
    @Child(name="package", order=13, min=1, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A logical group of resources. Logical groups can be used when building pages")
    private List<Package> myPackage;
    @Child(name="global", order=14, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A set of profiles that all resources covered by this implementation guide must conform to")
    private List<Global> myGlobal;
    @Child(name="binary", type={UriDt.class}, order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A binary file that is included in the  implementation guide when it is published")
    private List<UriDt> myBinary;
    @Child(name="page", order=16, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A page / section in the implementation guide. The root page is the implementation guide home page")
    private Page myPage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myCopyright, this.myFhirVersion, this.myDependency, this.myPackage, this.myGlobal, this.myBinary, this.myPage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myUseContext, this.myCopyright, this.myFhirVersion, this.myDependency, this.myPackage, this.myGlobal, this.myBinary, this.myPage});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public ImplementationGuide setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public ImplementationGuide setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public ImplementationGuide setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public ImplementationGuide setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public ImplementationGuide setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public ImplementationGuide setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ImplementationGuide setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ImplementationGuide setStatus(ConformanceResourceStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public ImplementationGuide setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public ImplementationGuide setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public ImplementationGuide setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public ImplementationGuide setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public ImplementationGuide setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public ImplementationGuide addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public ImplementationGuide setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ImplementationGuide setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ImplementationGuide setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ImplementationGuide setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ImplementationGuide setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getUseContext() {
        if (this.myUseContext == null) {
            this.myUseContext = new ArrayList<CodeableConceptDt>();
        }
        return this.myUseContext;
    }

    public ImplementationGuide setUseContext(List<CodeableConceptDt> theValue) {
        this.myUseContext = theValue;
        return this;
    }

    public CodeableConceptDt addUseContext() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getUseContext().add(newType);
        return newType;
    }

    public ImplementationGuide addUseContext(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getUseContext().add(theValue);
        return this;
    }

    public CodeableConceptDt getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            return this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public String getCopyright() {
        return (String)this.getCopyrightElement().getValue();
    }

    public ImplementationGuide setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public ImplementationGuide setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public IdDt getFhirVersionElement() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public String getFhirVersion() {
        return this.getFhirVersionElement().getValue();
    }

    public ImplementationGuide setFhirVersion(IdDt theValue) {
        this.myFhirVersion = theValue;
        return this;
    }

    public ImplementationGuide setFhirVersion(String theId) {
        this.myFhirVersion = new IdDt(theId);
        return this;
    }

    public List<Dependency> getDependency() {
        if (this.myDependency == null) {
            this.myDependency = new ArrayList<Dependency>();
        }
        return this.myDependency;
    }

    public ImplementationGuide setDependency(List<Dependency> theValue) {
        this.myDependency = theValue;
        return this;
    }

    public Dependency addDependency() {
        Dependency newType = new Dependency();
        this.getDependency().add(newType);
        return newType;
    }

    public ImplementationGuide addDependency(Dependency theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDependency().add(theValue);
        return this;
    }

    public Dependency getDependencyFirstRep() {
        if (this.getDependency().isEmpty()) {
            return this.addDependency();
        }
        return this.getDependency().get(0);
    }

    public List<Package> getPackage() {
        if (this.myPackage == null) {
            this.myPackage = new ArrayList<Package>();
        }
        return this.myPackage;
    }

    public ImplementationGuide setPackage(List<Package> theValue) {
        this.myPackage = theValue;
        return this;
    }

    public Package addPackage() {
        Package newType = new Package();
        this.getPackage().add(newType);
        return newType;
    }

    public ImplementationGuide addPackage(Package theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPackage().add(theValue);
        return this;
    }

    public Package getPackageFirstRep() {
        if (this.getPackage().isEmpty()) {
            return this.addPackage();
        }
        return this.getPackage().get(0);
    }

    public List<Global> getGlobal() {
        if (this.myGlobal == null) {
            this.myGlobal = new ArrayList<Global>();
        }
        return this.myGlobal;
    }

    public ImplementationGuide setGlobal(List<Global> theValue) {
        this.myGlobal = theValue;
        return this;
    }

    public Global addGlobal() {
        Global newType = new Global();
        this.getGlobal().add(newType);
        return newType;
    }

    public ImplementationGuide addGlobal(Global theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getGlobal().add(theValue);
        return this;
    }

    public Global getGlobalFirstRep() {
        if (this.getGlobal().isEmpty()) {
            return this.addGlobal();
        }
        return this.getGlobal().get(0);
    }

    public List<UriDt> getBinary() {
        if (this.myBinary == null) {
            this.myBinary = new ArrayList<UriDt>();
        }
        return this.myBinary;
    }

    public ImplementationGuide setBinary(List<UriDt> theValue) {
        this.myBinary = theValue;
        return this;
    }

    public UriDt addBinary() {
        UriDt newType = new UriDt();
        this.getBinary().add(newType);
        return newType;
    }

    public ImplementationGuide addBinary(UriDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getBinary().add(theValue);
        return this;
    }

    public UriDt getBinaryFirstRep() {
        if (this.getBinary().isEmpty()) {
            return this.addBinary();
        }
        return this.getBinary().get(0);
    }

    public ImplementationGuide addBinary(String theUri) {
        if (this.myBinary == null) {
            this.myBinary = new ArrayList<UriDt>();
        }
        this.myBinary.add(new UriDt(theUri));
        return this;
    }

    public Page getPage() {
        if (this.myPage == null) {
            this.myPage = new Page();
        }
        return this.myPage;
    }

    public ImplementationGuide setPage(Page theValue) {
        this.myPage = theValue;
        return this;
    }

    public String getResourceName() {
        return "ImplementationGuide";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Page
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="source", type={UriDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The source address for the page")
        private UriDt mySource;
        @Child(name="name", type={StringDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A short name used to represent this page in navigational structures such as table of contents, bread crumbs, etc.")
        private StringDt myName;
        @Child(name="kind", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of page that this is. Some pages are autogenerated (list, example), and other kinds are of interest so that tools can navigate the user to the page of interest")
        private BoundCodeDt<GuidePageKindEnum> myKind;
        @Child(name="type", type={CodeDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="For constructed pages, what kind of resources to include in the list")
        private List<BoundCodeDt<ResourceTypeEnum>> myType;
        @Child(name="package", type={StringDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="For constructed pages, a list of packages to include in the page (or else empty for everything)")
        private List<StringDt> myPackage;
        @Child(name="format", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The format of the page")
        private CodeDt myFormat;
        @Child(name="page", type={Page.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Nested Pages/Sections under this page")
        private List<Page> myPage;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySource, this.myName, this.myKind, this.myType, this.myPackage, this.myFormat, this.myPage});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySource, this.myName, this.myKind, this.myType, this.myPackage, this.myFormat, this.myPage});
        }

        public UriDt getSourceElement() {
            if (this.mySource == null) {
                this.mySource = new UriDt();
            }
            return this.mySource;
        }

        public String getSource() {
            return (String)this.getSourceElement().getValue();
        }

        public Page setSource(UriDt theValue) {
            this.mySource = theValue;
            return this;
        }

        public Page setSource(String theUri) {
            this.mySource = new UriDt(theUri);
            return this;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Page setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Page setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<GuidePageKindEnum> getKindElement() {
            if (this.myKind == null) {
                this.myKind = new BoundCodeDt(GuidePageKindEnum.VALUESET_BINDER);
            }
            return this.myKind;
        }

        public String getKind() {
            return (String)this.getKindElement().getValue();
        }

        public Page setKind(BoundCodeDt<GuidePageKindEnum> theValue) {
            this.myKind = theValue;
            return this;
        }

        public Page setKind(GuidePageKindEnum theValue) {
            this.getKindElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<BoundCodeDt<ResourceTypeEnum>> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
            }
            return this.myType;
        }

        public Page setType(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
            this.myType = theValue;
            return this;
        }

        public BoundCodeDt<ResourceTypeEnum> addType(ResourceTypeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getType().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<ResourceTypeEnum> getTypeFirstRep() {
            if (this.getType().size() == 0) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public BoundCodeDt<ResourceTypeEnum> addType() {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            this.getType().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public Page setType(ResourceTypeEnum theValue) {
            this.getType().clear();
            this.addType(theValue);
            return this;
        }

        public List<StringDt> getPackage() {
            if (this.myPackage == null) {
                this.myPackage = new ArrayList<StringDt>();
            }
            return this.myPackage;
        }

        public Page setPackage(List<StringDt> theValue) {
            this.myPackage = theValue;
            return this;
        }

        public StringDt addPackage() {
            StringDt newType = new StringDt();
            this.getPackage().add(newType);
            return newType;
        }

        public Page addPackage(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPackage().add(theValue);
            return this;
        }

        public StringDt getPackageFirstRep() {
            if (this.getPackage().isEmpty()) {
                return this.addPackage();
            }
            return this.getPackage().get(0);
        }

        public Page addPackage(String theString) {
            if (this.myPackage == null) {
                this.myPackage = new ArrayList<StringDt>();
            }
            this.myPackage.add(new StringDt(theString));
            return this;
        }

        public CodeDt getFormatElement() {
            if (this.myFormat == null) {
                this.myFormat = new CodeDt();
            }
            return this.myFormat;
        }

        public String getFormat() {
            return (String)this.getFormatElement().getValue();
        }

        public Page setFormat(CodeDt theValue) {
            this.myFormat = theValue;
            return this;
        }

        public Page setFormat(String theCode) {
            this.myFormat = new CodeDt(theCode);
            return this;
        }

        public List<Page> getPage() {
            if (this.myPage == null) {
                this.myPage = new ArrayList<Page>();
            }
            return this.myPage;
        }

        public Page setPage(List<Page> theValue) {
            this.myPage = theValue;
            return this;
        }

        public Page addPage() {
            Page newType = new Page();
            this.getPage().add(newType);
            return newType;
        }

        public Page addPage(Page theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPage().add(theValue);
            return this;
        }

        public Page getPageFirstRep() {
            if (this.getPage().isEmpty()) {
                return this.addPage();
            }
            return this.getPage().get(0);
        }
    }

    @Block
    public static class Global
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of resource that all instances must conform to")
        private BoundCodeDt<ResourceTypeEnum> myType;
        @Child(name="profile", order=1, min=1, max=1, summary=true, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="A reference to the profile that all instances must conform to")
        private ResourceReferenceDt myProfile;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myProfile});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myProfile});
        }

        public BoundCodeDt<ResourceTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Global setType(BoundCodeDt<ResourceTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Global setType(ResourceTypeEnum theValue) {
            this.getTypeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public Global setProfile(ResourceReferenceDt theValue) {
            this.myProfile = theValue;
            return this;
        }
    }

    @Block
    public static class PackageResource
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="purpose", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Why the resource is included in the guide")
        private BoundCodeDt<GuideResourcePurposeEnum> myPurpose;
        @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name)")
        private StringDt myName;
        @Child(name="description", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A description of the reason that a resource has been included in the implementation guide")
        private StringDt myDescription;
        @Child(name="acronym", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A short code that may be used to identify the resource throughout the implementation guide")
        private StringDt myAcronym;
        @Child(name="source", order=4, min=1, max=1, summary=true, modifier=false, type={UriDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="Where this resource is found")
        private IDatatype mySource;
        @Child(name="exampleFor", order=5, min=0, max=1, summary=false, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="Another resource that this resource is an example for. This is mostly used for resources that are included as examples of StructureDefinitions")
        private ResourceReferenceDt myExampleFor;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myPurpose, this.myName, this.myDescription, this.myAcronym, this.mySource, this.myExampleFor});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPurpose, this.myName, this.myDescription, this.myAcronym, this.mySource, this.myExampleFor});
        }

        public BoundCodeDt<GuideResourcePurposeEnum> getPurposeElement() {
            if (this.myPurpose == null) {
                this.myPurpose = new BoundCodeDt(GuideResourcePurposeEnum.VALUESET_BINDER);
            }
            return this.myPurpose;
        }

        public String getPurpose() {
            return (String)this.getPurposeElement().getValue();
        }

        public PackageResource setPurpose(BoundCodeDt<GuideResourcePurposeEnum> theValue) {
            this.myPurpose = theValue;
            return this;
        }

        public PackageResource setPurpose(GuideResourcePurposeEnum theValue) {
            this.getPurposeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public PackageResource setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public PackageResource setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public PackageResource setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public PackageResource setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public StringDt getAcronymElement() {
            if (this.myAcronym == null) {
                this.myAcronym = new StringDt();
            }
            return this.myAcronym;
        }

        public String getAcronym() {
            return (String)this.getAcronymElement().getValue();
        }

        public PackageResource setAcronym(StringDt theValue) {
            this.myAcronym = theValue;
            return this;
        }

        public PackageResource setAcronym(String theString) {
            this.myAcronym = new StringDt(theString);
            return this;
        }

        public IDatatype getSource() {
            return this.mySource;
        }

        public PackageResource setSource(IDatatype theValue) {
            this.mySource = theValue;
            return this;
        }

        public ResourceReferenceDt getExampleFor() {
            if (this.myExampleFor == null) {
                this.myExampleFor = new ResourceReferenceDt();
            }
            return this.myExampleFor;
        }

        public PackageResource setExampleFor(ResourceReferenceDt theValue) {
            this.myExampleFor = theValue;
            return this;
        }
    }

    @Block
    public static class Package
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name for the group, as used in page.package")
        private StringDt myName;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private StringDt myDescription;
        @Child(name="resource", order=2, min=1, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, conformance statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource")
        private List<PackageResource> myResource;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myDescription, this.myResource});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDescription, this.myResource});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Package setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Package setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public Package setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Package setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public List<PackageResource> getResource() {
            if (this.myResource == null) {
                this.myResource = new ArrayList<PackageResource>();
            }
            return this.myResource;
        }

        public Package setResource(List<PackageResource> theValue) {
            this.myResource = theValue;
            return this;
        }

        public PackageResource addResource() {
            PackageResource newType = new PackageResource();
            this.getResource().add(newType);
            return newType;
        }

        public Package addResource(PackageResource theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getResource().add(theValue);
            return this;
        }

        public PackageResource getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                return this.addResource();
            }
            return this.getResource().get(0);
        }
    }

    @Block
    public static class Dependency
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="How the dependency is represented when the guide is published")
        private BoundCodeDt<GuideDependencyTypeEnum> myType;
        @Child(name="uri", type={UriDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Where the dependency is located")
        private UriDt myUri;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myUri});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myUri});
        }

        public BoundCodeDt<GuideDependencyTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(GuideDependencyTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Dependency setType(BoundCodeDt<GuideDependencyTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Dependency setType(GuideDependencyTypeEnum theValue) {
            this.getTypeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public UriDt getUriElement() {
            if (this.myUri == null) {
                this.myUri = new UriDt();
            }
            return this.myUri;
        }

        public String getUri() {
            return (String)this.getUriElement().getValue();
        }

        public Dependency setUri(UriDt theValue) {
            this.myUri = theValue;
            return this;
        }

        public Dependency setUri(String theUri) {
            this.myUri = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the implementation guide")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }
}

