/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.BodySite;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.MedicationStatementStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MedicationStatement", profile="http://hl7.org/fhir/profiles/MedicationStatement", id="medicationstatement")
public class MedicationStatement
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="MedicationStatement.identifier", description="Return statements with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationStatement.medicationReference", description="Return administrations of this medication reference", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    @SearchParamDefinition(name="code", path="MedicationStatement.medicationCodeableConcept", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="patient", path="MedicationStatement.patient", description="The identity of a patient to list statements  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="effectivedate", path="MedicationStatement.effective[x]", description="Date when patient was taking (or not taking) the medication", type="date")
    public static final String SP_EFFECTIVEDATE = "effectivedate";
    public static final DateClientParam EFFECTIVEDATE = new DateClientParam("effectivedate");
    @SearchParamDefinition(name="status", path="MedicationStatement.status", description="Return statements that match the given status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="source", path="MedicationStatement.informationSource", description="Who the information in the statement came from", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationStatement:medication");
    public static final Include INCLUDE_PATIENT = new Include("MedicationStatement:patient");
    public static final Include INCLUDE_SOURCE = new Include("MedicationStatement:source");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The person or animal who is/was taking the medication.")
    private ResourceReferenceDt myPatient;
    @Child(name="informationSource", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="who.source", formalDefinition="The person who provided the information about the taking of this medication.")
    private ResourceReferenceDt myInformationSource;
    @Child(name="dateAsserted", type={DateTimeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when the medication statement was asserted by the information source.")
    private DateTimeDt myDateAsserted;
    @Child(name="status", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="A code representing the patient or other source's judgment about the state of the medication used that this statement is about.  Generally this will be active or completed.")
    private BoundCodeDt<MedicationStatementStatusEnum> myStatus;
    @Child(name="wasNotTaken", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Set this to true if the record is saying that the medication was NOT taken.")
    private BooleanDt myWasNotTaken;
    @Child(name="reasonNotTaken", type={CodeableConceptDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code indicating why the medication was not taken.")
    private List<CodeableConceptDt> myReasonNotTaken;
    @Child(name="reasonForUse", order=7, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Condition.class})
    @Description(shortDefinition="", formalDefinition="A reason for why the medication is being/was taken.")
    private IDatatype myReasonForUse;
    @Child(name="effective", order=8, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="when.done", formalDefinition="The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).")
    private IDatatype myEffective;
    @Child(name="note", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Provides extra information about the medication statement that is not conveyed by the other attributes.")
    private StringDt myNote;
    @Child(name="supportingInformation", order=10, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Allows linking the MedicationStatement to the underlying MedicationOrder, or to other information that supports the MedicationStatement.")
    private List<ResourceReferenceDt> mySupportingInformation;
    @Child(name="medication", order=11, min=1, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Medication.class})
    @Description(shortDefinition="what", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    private IDatatype myMedication;
    @Child(name="dosage", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates how the medication is/was used by the patient")
    private List<Dosage> myDosage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myInformationSource, this.myDateAsserted, this.myStatus, this.myWasNotTaken, this.myReasonNotTaken, this.myReasonForUse, this.myEffective, this.myNote, this.mySupportingInformation, this.myMedication, this.myDosage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myInformationSource, this.myDateAsserted, this.myStatus, this.myWasNotTaken, this.myReasonNotTaken, this.myReasonForUse, this.myEffective, this.myNote, this.mySupportingInformation, this.myMedication, this.myDosage});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public MedicationStatement setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public MedicationStatement addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationStatement setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getInformationSource() {
        if (this.myInformationSource == null) {
            this.myInformationSource = new ResourceReferenceDt();
        }
        return this.myInformationSource;
    }

    public MedicationStatement setInformationSource(ResourceReferenceDt theValue) {
        this.myInformationSource = theValue;
        return this;
    }

    public DateTimeDt getDateAssertedElement() {
        if (this.myDateAsserted == null) {
            this.myDateAsserted = new DateTimeDt();
        }
        return this.myDateAsserted;
    }

    public Date getDateAsserted() {
        return (Date)this.getDateAssertedElement().getValue();
    }

    public MedicationStatement setDateAsserted(DateTimeDt theValue) {
        this.myDateAsserted = theValue;
        return this;
    }

    public MedicationStatement setDateAsserted(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateAsserted = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public MedicationStatement setDateAssertedWithSecondsPrecision(Date theDate) {
        this.myDateAsserted = new DateTimeDt(theDate);
        return this;
    }

    public BoundCodeDt<MedicationStatementStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationStatementStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public MedicationStatement setStatus(BoundCodeDt<MedicationStatementStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationStatement setStatus(MedicationStatementStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getWasNotTakenElement() {
        if (this.myWasNotTaken == null) {
            this.myWasNotTaken = new BooleanDt();
        }
        return this.myWasNotTaken;
    }

    public Boolean getWasNotTaken() {
        return (Boolean)this.getWasNotTakenElement().getValue();
    }

    public MedicationStatement setWasNotTaken(BooleanDt theValue) {
        this.myWasNotTaken = theValue;
        return this;
    }

    public MedicationStatement setWasNotTaken(boolean theBoolean) {
        this.myWasNotTaken = new BooleanDt(theBoolean);
        return this;
    }

    public List<CodeableConceptDt> getReasonNotTaken() {
        if (this.myReasonNotTaken == null) {
            this.myReasonNotTaken = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotTaken;
    }

    public MedicationStatement setReasonNotTaken(List<CodeableConceptDt> theValue) {
        this.myReasonNotTaken = theValue;
        return this;
    }

    public CodeableConceptDt addReasonNotTaken() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReasonNotTaken().add(newType);
        return newType;
    }

    public MedicationStatement addReasonNotTaken(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReasonNotTaken().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonNotTakenFirstRep() {
        if (this.getReasonNotTaken().isEmpty()) {
            return this.addReasonNotTaken();
        }
        return this.getReasonNotTaken().get(0);
    }

    public IDatatype getReasonForUse() {
        return this.myReasonForUse;
    }

    public MedicationStatement setReasonForUse(IDatatype theValue) {
        this.myReasonForUse = theValue;
        return this;
    }

    public IDatatype getEffective() {
        return this.myEffective;
    }

    public MedicationStatement setEffective(IDatatype theValue) {
        this.myEffective = theValue;
        return this;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public String getNote() {
        return (String)this.getNoteElement().getValue();
    }

    public MedicationStatement setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public MedicationStatement setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getSupportingInformation() {
        if (this.mySupportingInformation == null) {
            this.mySupportingInformation = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySupportingInformation;
    }

    public MedicationStatement setSupportingInformation(List<ResourceReferenceDt> theValue) {
        this.mySupportingInformation = theValue;
        return this;
    }

    public ResourceReferenceDt addSupportingInformation() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSupportingInformation().add(newType);
        return newType;
    }

    public IDatatype getMedication() {
        return this.myMedication;
    }

    public MedicationStatement setMedication(IDatatype theValue) {
        this.myMedication = theValue;
        return this;
    }

    public List<Dosage> getDosage() {
        if (this.myDosage == null) {
            this.myDosage = new ArrayList<Dosage>();
        }
        return this.myDosage;
    }

    public MedicationStatement setDosage(List<Dosage> theValue) {
        this.myDosage = theValue;
        return this;
    }

    public Dosage addDosage() {
        Dosage newType = new Dosage();
        this.getDosage().add(newType);
        return newType;
    }

    public MedicationStatement addDosage(Dosage theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDosage().add(theValue);
        return this;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            return this.addDosage();
        }
        return this.getDosage().get(0);
    }

    public String getResourceName() {
        return "MedicationStatement";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Dosage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="text", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text dosage information as reported about a patient's medication use. When coded dosage information is present, the free text may still be present for display to humans.")
        private StringDt myText;
        @Child(name="timing", type={TimingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\"")
        private TimingDt myTiming;
        @Child(name="asNeeded", order=2, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).  Specifically if 'boolean' datatype is selected, then the following logic applies:  If set to True, this indicates that the medication is only taken when needed, within the specified schedule.")
        private IDatatype myAsNeeded;
        @Child(name="site", order=3, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BodySite.class})
        @Description(shortDefinition="", formalDefinition="A coded specification of or a reference to the anatomic site where the medication first enters the body")
        private IDatatype mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        private CodeableConceptDt myMethod;
        @Child(name="quantity", order=6, min=0, max=1, summary=false, modifier=false, type={SimpleQuantityDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        private IDatatype myQuantity;
        @Child(name="rate", order=7, min=0, max=1, summary=false, modifier=false, type={RatioDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours")
        private IDatatype myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time.  For example, 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myText, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myText, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Dosage setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Dosage setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public TimingDt getTiming() {
            if (this.myTiming == null) {
                this.myTiming = new TimingDt();
            }
            return this.myTiming;
        }

        public Dosage setTiming(TimingDt theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public Dosage setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public IDatatype getSite() {
            return this.mySite;
        }

        public Dosage setSite(IDatatype theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public Dosage setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public Dosage setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public IDatatype getQuantity() {
            return this.myQuantity;
        }

        public Dosage setQuantity(IDatatype theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public IDatatype getRate() {
            return this.myRate;
        }

        public Dosage setRate(IDatatype theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public Dosage setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }
}

