/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Order", profile="http://hl7.org/fhir/profiles/Order", id="order")
public class Order
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="Order.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="Order.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="source", path="Order.source", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    @SearchParamDefinition(name="target", path="Order.target", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    @SearchParamDefinition(name="when_code", path="Order.when.code", description="", type="token")
    public static final String SP_WHEN_CODE = "when_code";
    public static final TokenClientParam WHEN_CODE = new TokenClientParam("when_code");
    @SearchParamDefinition(name="when", path="Order.when.schedule", description="", type="date")
    public static final String SP_WHEN = "when";
    public static final DateClientParam WHEN = new DateClientParam("when");
    @SearchParamDefinition(name="detail", path="Order.detail", description="", type="reference")
    public static final String SP_DETAIL = "detail";
    public static final ReferenceClientParam DETAIL = new ReferenceClientParam("detail");
    @SearchParamDefinition(name="patient", path="Order.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="identifier", path="Order.identifier", description="Instance id from source, target, and/or  others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_DETAIL = new Include("Order:detail");
    public static final Include INCLUDE_PATIENT = new Include("Order:patient");
    public static final Include INCLUDE_SOURCE = new Include("Order:source");
    public static final Include INCLUDE_SUBJECT = new Include("Order:subject");
    public static final Include INCLUDE_TARGET = new Include("Order:target");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="")
    private DateTimeDt myDate;
    @Child(name="subject", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class, Group.class, Device.class, Substance.class})
    @Description(shortDefinition="who.focus", formalDefinition="")
    private ResourceReferenceDt mySubject;
    @Child(name="source", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="who.cause", formalDefinition="")
    private ResourceReferenceDt mySource;
    @Child(name="target", order=4, min=0, max=1, summary=false, modifier=false, type={Organization.class, Device.class, Practitioner.class})
    @Description(shortDefinition="who.actor", formalDefinition="")
    private ResourceReferenceDt myTarget;
    @Child(name="reason", order=5, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, IResource.class})
    @Description(shortDefinition="why", formalDefinition="")
    private IDatatype myReason;
    @Child(name="when", order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private When myWhen;
    @Child(name="detail", order=7, min=1, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="")
    private List<ResourceReferenceDt> myDetail;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDate, this.mySubject, this.mySource, this.myTarget, this.myReason, this.myWhen, this.myDetail});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDate, this.mySubject, this.mySource, this.myTarget, this.myReason, this.myWhen, this.myDetail});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Order setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Order addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public Order setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Order setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Order setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Order setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public Order setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public Order setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public Order setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public When getWhen() {
        if (this.myWhen == null) {
            this.myWhen = new When();
        }
        return this.myWhen;
    }

    public Order setWhen(When theValue) {
        this.myWhen = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getDetail() {
        if (this.myDetail == null) {
            this.myDetail = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDetail;
    }

    public Order setDetail(List<ResourceReferenceDt> theValue) {
        this.myDetail = theValue;
        return this;
    }

    public ResourceReferenceDt addDetail() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getDetail().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "Order";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class When
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private CodeableConceptDt myCode;
        @Child(name="schedule", type={TimingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="when.planned", formalDefinition="")
        private TimingDt mySchedule;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.mySchedule});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.mySchedule});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public When setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public TimingDt getSchedule() {
            if (this.mySchedule == null) {
                this.mySchedule = new TimingDt();
            }
            return this.mySchedule;
        }

        public When setSchedule(TimingDt theValue) {
            this.mySchedule = theValue;
            return this;
        }
    }
}

