/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AddressDt;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.HealthcareService;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.valueset.AdministrativeGenderEnum;
import ca.uhn.fhir.model.dstu2.valueset.PractitionerRoleEnum;
import ca.uhn.fhir.model.dstu2.valueset.PractitionerSpecialtyEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Practitioner", profile="http://hl7.org/fhir/profiles/Practitioner", id="practitioner")
public class Practitioner
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Practitioner.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Practitioner.name", description="A portion of either family or given name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="family", path="Practitioner.name.family", description="A portion of the family name", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="given", path="Practitioner.name.given", description="A portion of the given name", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="phonetic", path="Practitioner.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Practitioner.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="phone", path="Practitioner.telecom(system=phone)", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="email", path="Practitioner.telecom(system=email)", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="address", path="Practitioner.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-city", path="Practitioner.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="Practitioner.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-postalcode", path="Practitioner.address.postalCode", description="A postalCode specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Practitioner.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-use", path="Practitioner.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="gender", path="Practitioner.gender", description="Gender of the practitioner", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="organization", path="Practitioner.practitionerRole.managingOrganization", description="The identity of the organization the practitioner represents / acts on behalf of", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="communication", path="Practitioner.communication", description="One of the languages that the practitioner can communicate with", type="token")
    public static final String SP_COMMUNICATION = "communication";
    public static final TokenClientParam COMMUNICATION = new TokenClientParam("communication");
    @SearchParamDefinition(name="location", path="Practitioner.practitionerRole.location", description="One of the locations at which this practitioner provides care", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="specialty", path="Practitioner.practitionerRole.specialty", description="The practitioner has this specialty at an organization", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="role", path="Practitioner.practitionerRole.role", description="The practitioner can perform this role at for the organization", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    public static final Include INCLUDE_LOCATION = new Include("Practitioner:location");
    public static final Include INCLUDE_ORGANIZATION = new Include("Practitioner:organization");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An identifier that applies to this person in this role")
    private List<IdentifierDt> myIdentifier;
    @Child(name="active", type={BooleanDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="status", formalDefinition="Whether this practitioner's record is in active use")
    private BooleanDt myActive;
    @Child(name="name", type={HumanNameDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A name associated with the person")
    private HumanNameDt myName;
    @Child(name="telecom", type={ContactPointDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A contact detail for the practitioner, e.g. a telephone number or an email address.")
    private List<ContactPointDt> myTelecom;
    @Child(name="address", type={AddressDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The postal address where the practitioner can be found or visited or to which mail can be delivered")
    private List<AddressDt> myAddress;
    @Child(name="gender", type={CodeDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    private BoundCodeDt<AdministrativeGenderEnum> myGender;
    @Child(name="birthDate", type={DateDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date of birth for the practitioner")
    private DateDt myBirthDate;
    @Child(name="photo", type={AttachmentDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Image of the person")
    private List<AttachmentDt> myPhoto;
    @Child(name="practitionerRole", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The list of roles/organizations that the practitioner is associated with")
    private List<PractitionerRole> myPractitionerRole;
    @Child(name="qualification", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Qualification> myQualification;
    @Child(name="communication", type={CodeableConceptDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A language the practitioner is able to use in patient communication")
    private List<CodeableConceptDt> myCommunication;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myActive, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myBirthDate, this.myPhoto, this.myPractitionerRole, this.myQualification, this.myCommunication});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myActive, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myBirthDate, this.myPhoto, this.myPractitionerRole, this.myQualification, this.myCommunication});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Practitioner setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Practitioner addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanDt getActiveElement() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public Boolean getActive() {
        return (Boolean)this.getActiveElement().getValue();
    }

    public Practitioner setActive(BooleanDt theValue) {
        this.myActive = theValue;
        return this;
    }

    public Practitioner setActive(boolean theBoolean) {
        this.myActive = new BooleanDt(theBoolean);
        return this;
    }

    public HumanNameDt getName() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public Practitioner setName(HumanNameDt theValue) {
        this.myName = theValue;
        return this;
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public Practitioner setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public Practitioner addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public Practitioner setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public Practitioner addAddress(AddressDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAddress().add(theValue);
        return this;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public BoundCodeDt<AdministrativeGenderEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public String getGender() {
        return (String)this.getGenderElement().getValue();
    }

    public Practitioner setGender(BoundCodeDt<AdministrativeGenderEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public Practitioner setGender(AdministrativeGenderEnum theValue) {
        this.getGenderElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public DateDt getBirthDateElement() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateDt();
        }
        return this.myBirthDate;
    }

    public Date getBirthDate() {
        return (Date)this.getBirthDateElement().getValue();
    }

    public Practitioner setBirthDate(DateDt theValue) {
        this.myBirthDate = theValue;
        return this;
    }

    public Practitioner setBirthDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myBirthDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Practitioner setBirthDateWithDayPrecision(Date theDate) {
        this.myBirthDate = new DateDt(theDate);
        return this;
    }

    public List<AttachmentDt> getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public Practitioner setPhoto(List<AttachmentDt> theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public AttachmentDt addPhoto() {
        AttachmentDt newType = new AttachmentDt();
        this.getPhoto().add(newType);
        return newType;
    }

    public Practitioner addPhoto(AttachmentDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPhoto().add(theValue);
        return this;
    }

    public AttachmentDt getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            return this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public List<PractitionerRole> getPractitionerRole() {
        if (this.myPractitionerRole == null) {
            this.myPractitionerRole = new ArrayList<PractitionerRole>();
        }
        return this.myPractitionerRole;
    }

    public Practitioner setPractitionerRole(List<PractitionerRole> theValue) {
        this.myPractitionerRole = theValue;
        return this;
    }

    public PractitionerRole addPractitionerRole() {
        PractitionerRole newType = new PractitionerRole();
        this.getPractitionerRole().add(newType);
        return newType;
    }

    public Practitioner addPractitionerRole(PractitionerRole theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPractitionerRole().add(theValue);
        return this;
    }

    public PractitionerRole getPractitionerRoleFirstRep() {
        if (this.getPractitionerRole().isEmpty()) {
            return this.addPractitionerRole();
        }
        return this.getPractitionerRole().get(0);
    }

    public List<Qualification> getQualification() {
        if (this.myQualification == null) {
            this.myQualification = new ArrayList<Qualification>();
        }
        return this.myQualification;
    }

    public Practitioner setQualification(List<Qualification> theValue) {
        this.myQualification = theValue;
        return this;
    }

    public Qualification addQualification() {
        Qualification newType = new Qualification();
        this.getQualification().add(newType);
        return newType;
    }

    public Practitioner addQualification(Qualification theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getQualification().add(theValue);
        return this;
    }

    public Qualification getQualificationFirstRep() {
        if (this.getQualification().isEmpty()) {
            return this.addQualification();
        }
        return this.getQualification().get(0);
    }

    public List<CodeableConceptDt> getCommunication() {
        if (this.myCommunication == null) {
            this.myCommunication = new ArrayList<CodeableConceptDt>();
        }
        return this.myCommunication;
    }

    public Practitioner setCommunication(List<CodeableConceptDt> theValue) {
        this.myCommunication = theValue;
        return this;
    }

    public CodeableConceptDt addCommunication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCommunication().add(newType);
        return newType;
    }

    public Practitioner addCommunication(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCommunication().add(theValue);
        return this;
    }

    public CodeableConceptDt getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            return this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    public String getResourceName() {
        return "Practitioner";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Qualification
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier that applies to this person's qualification in this role")
        private List<IdentifierDt> myIdentifier;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private CodeableConceptDt myCode;
        @Child(name="period", type={PeriodDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Period during which the qualification is valid")
        private PeriodDt myPeriod;
        @Child(name="issuer", order=3, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="Organization that regulates and issues the qualification")
        private ResourceReferenceDt myIssuer;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCode, this.myPeriod, this.myIssuer});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCode, this.myPeriod, this.myIssuer});
        }

        public List<IdentifierDt> getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new ArrayList<IdentifierDt>();
            }
            return this.myIdentifier;
        }

        public Qualification setIdentifier(List<IdentifierDt> theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public IdentifierDt addIdentifier() {
            IdentifierDt newType = new IdentifierDt();
            this.getIdentifier().add(newType);
            return newType;
        }

        public Qualification addIdentifier(IdentifierDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getIdentifier().add(theValue);
            return this;
        }

        public IdentifierDt getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                return this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Qualification setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Qualification setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public ResourceReferenceDt getIssuer() {
            if (this.myIssuer == null) {
                this.myIssuer = new ResourceReferenceDt();
            }
            return this.myIssuer;
        }

        public Qualification setIssuer(ResourceReferenceDt theValue) {
            this.myIssuer = theValue;
            return this;
        }
    }

    @Block
    public static class PractitionerRole
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="managingOrganization", order=0, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="The organization where the Practitioner performs the roles associated")
        private ResourceReferenceDt myManagingOrganization;
        @Child(name="role", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Roles which this practitioner is authorized to perform for the organization")
        private BoundCodeableConceptDt<PractitionerRoleEnum> myRole;
        @Child(name="specialty", type={CodeableConceptDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specific specialty of the practitioner")
        private List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> mySpecialty;
        @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="when.done", formalDefinition="The period during which the person is authorized to act as a practitioner in these role(s) for the organization")
        private PeriodDt myPeriod;
        @Child(name="location", order=4, min=0, max=-1, summary=false, modifier=false, type={Location.class})
        @Description(shortDefinition="where", formalDefinition="The location(s) at which this practitioner provides care")
        private List<ResourceReferenceDt> myLocation;
        @Child(name="healthcareService", order=5, min=0, max=-1, summary=false, modifier=false, type={HealthcareService.class})
        @Description(shortDefinition="", formalDefinition="")
        private List<ResourceReferenceDt> myHealthcareService;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myManagingOrganization, this.myRole, this.mySpecialty, this.myPeriod, this.myLocation, this.myHealthcareService});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myManagingOrganization, this.myRole, this.mySpecialty, this.myPeriod, this.myLocation, this.myHealthcareService});
        }

        public ResourceReferenceDt getManagingOrganization() {
            if (this.myManagingOrganization == null) {
                this.myManagingOrganization = new ResourceReferenceDt();
            }
            return this.myManagingOrganization;
        }

        public PractitionerRole setManagingOrganization(ResourceReferenceDt theValue) {
            this.myManagingOrganization = theValue;
            return this;
        }

        public BoundCodeableConceptDt<PractitionerRoleEnum> getRole() {
            if (this.myRole == null) {
                this.myRole = new BoundCodeableConceptDt<PractitionerRoleEnum>(PractitionerRoleEnum.VALUESET_BINDER);
            }
            return this.myRole;
        }

        public PractitionerRole setRole(BoundCodeableConceptDt<PractitionerRoleEnum> theValue) {
            this.myRole = theValue;
            return this;
        }

        public PractitionerRole setRole(PractitionerRoleEnum theValue) {
            this.getRole().setValueAsEnum(theValue);
            return this;
        }

        public List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> getSpecialty() {
            if (this.mySpecialty == null) {
                this.mySpecialty = new ArrayList<BoundCodeableConceptDt<PractitionerSpecialtyEnum>>();
            }
            return this.mySpecialty;
        }

        public PractitionerRole setSpecialty(List<BoundCodeableConceptDt<PractitionerSpecialtyEnum>> theValue) {
            this.mySpecialty = theValue;
            return this;
        }

        public BoundCodeableConceptDt<PractitionerSpecialtyEnum> addSpecialty(PractitionerSpecialtyEnum theValue) {
            BoundCodeableConceptDt<PractitionerSpecialtyEnum> retVal = new BoundCodeableConceptDt<PractitionerSpecialtyEnum>(PractitionerSpecialtyEnum.VALUESET_BINDER, theValue);
            this.getSpecialty().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<PractitionerSpecialtyEnum> getSpecialtyFirstRep() {
            if (this.getSpecialty().size() == 0) {
                this.addSpecialty();
            }
            return this.getSpecialty().get(0);
        }

        public BoundCodeableConceptDt<PractitionerSpecialtyEnum> addSpecialty() {
            BoundCodeableConceptDt<PractitionerSpecialtyEnum> retVal = new BoundCodeableConceptDt<PractitionerSpecialtyEnum>(PractitionerSpecialtyEnum.VALUESET_BINDER);
            this.getSpecialty().add(retVal);
            return retVal;
        }

        public PractitionerRole setSpecialty(PractitionerSpecialtyEnum theValue) {
            this.getSpecialty().clear();
            this.addSpecialty(theValue);
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PractitionerRole setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ArrayList<ResourceReferenceDt>();
            }
            return this.myLocation;
        }

        public PractitionerRole setLocation(List<ResourceReferenceDt> theValue) {
            this.myLocation = theValue;
            return this;
        }

        public ResourceReferenceDt addLocation() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getLocation().add(newType);
            return newType;
        }

        public List<ResourceReferenceDt> getHealthcareService() {
            if (this.myHealthcareService == null) {
                this.myHealthcareService = new ArrayList<ResourceReferenceDt>();
            }
            return this.myHealthcareService;
        }

        public PractitionerRole setHealthcareService(List<ResourceReferenceDt> theValue) {
            this.myHealthcareService = theValue;
            return this;
        }

        public ResourceReferenceDt addHealthcareService() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getHealthcareService().add(newType);
            return newType;
        }
    }
}

