/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.dstu2.valueset.AnswerFormatEnum;
import ca.uhn.fhir.model.dstu2.valueset.QuestionnaireStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Questionnaire", profile="http://hl7.org/fhir/profiles/Questionnaire", id="questionnaire")
public class Questionnaire
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="Questionnaire.status", description="The status of the questionnaire", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="Questionnaire.date", description="When the questionnaire was last changed", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="publisher", path="Questionnaire.publisher", description="The author of the questionnaire", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="identifier", path="Questionnaire.identifier", description="An identifier for the questionnaire", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="Questionnaire.version", description="The business version of the questionnaire", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");
    @SearchParamDefinition(name="code", path="Questionnaire.group.concept", description="A code that corresponds to the questionnaire or one of its groups", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="title", path="Questionnaire.group.title", description="All or part of the name of the questionnaire (title for the root group of the questionnaire)", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="This records identifiers associated with this question set that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id.version", formalDefinition="The version number assigned by the publisher for business reasons.  It may remain the same when the resource is updated")
    private StringDt myVersion;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The lifecycle status of the questionnaire as a whole.")
    private BoundCodeDt<QuestionnaireStatusEnum> myStatus;
    @Child(name="date", type={DateTimeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date that this questionnaire was last changed")
    private DateTimeDt myDate;
    @Child(name="publisher", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="Organization or person responsible for developing and maintaining the questionnaire")
    private StringDt myPublisher;
    @Child(name="telecom", type={ContactPointDt.class}, order=5, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contact details to assist a user in finding and communicating with the publisher")
    private List<ContactPointDt> myTelecom;
    @Child(name="subjectType", type={CodeDt.class}, order=6, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the types of subjects that can be the subject of the questionnaire.")
    private List<BoundCodeDt<ResourceTypeEnum>> mySubjectType;
    @Child(name="group", order=7, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A collection of related questions (or further groupings of questions)")
    private Group myGroup;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myVersion, this.myStatus, this.myDate, this.myPublisher, this.myTelecom, this.mySubjectType, this.myGroup});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myVersion, this.myStatus, this.myDate, this.myPublisher, this.myTelecom, this.mySubjectType, this.myGroup});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Questionnaire setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Questionnaire addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public Questionnaire setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public Questionnaire setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<QuestionnaireStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(QuestionnaireStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Questionnaire setStatus(BoundCodeDt<QuestionnaireStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Questionnaire setStatus(QuestionnaireStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public Questionnaire setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Questionnaire setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Questionnaire setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public Questionnaire setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public Questionnaire setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public Questionnaire setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public Questionnaire addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<BoundCodeDt<ResourceTypeEnum>> getSubjectType() {
        if (this.mySubjectType == null) {
            this.mySubjectType = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
        }
        return this.mySubjectType;
    }

    public Questionnaire setSubjectType(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
        this.mySubjectType = theValue;
        return this;
    }

    public BoundCodeDt<ResourceTypeEnum> addSubjectType(ResourceTypeEnum theValue) {
        BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
        this.getSubjectType().add((BoundCodeDt<ResourceTypeEnum>)retVal);
        return retVal;
    }

    public BoundCodeDt<ResourceTypeEnum> getSubjectTypeFirstRep() {
        if (this.getSubjectType().size() == 0) {
            this.addSubjectType();
        }
        return this.getSubjectType().get(0);
    }

    public BoundCodeDt<ResourceTypeEnum> addSubjectType() {
        BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
        this.getSubjectType().add((BoundCodeDt<ResourceTypeEnum>)retVal);
        return retVal;
    }

    public Questionnaire setSubjectType(ResourceTypeEnum theValue) {
        this.getSubjectType().clear();
        this.addSubjectType(theValue);
        return this;
    }

    public Group getGroup() {
        if (this.myGroup == null) {
            this.myGroup = new Group();
        }
        return this.myGroup;
    }

    public Questionnaire setGroup(Group theValue) {
        this.myGroup = theValue;
        return this;
    }

    public String getResourceName() {
        return "Questionnaire";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class GroupQuestion
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="linkId", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier that is unique within the questionnaire allowing linkage to the equivalent group in a [[[QuestionnaireResponse]]] resource.")
        private StringDt myLinkId;
        @Child(name="concept", type={CodingDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a how this question is known in a particular terminology such as LOINC.")
        private List<CodingDt> myConcept;
        @Child(name="text", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The actual question as shown to the user to prompt them for an answer.")
        private StringDt myText;
        @Child(name="type", type={CodeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The expected format of the answer, e.g. the type of input (string, integer) or whether a (multiple) choice is expected")
        private BoundCodeDt<AnswerFormatEnum> myType;
        @Child(name="required", type={BooleanDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If true, indicates that the question must be answered and have required groups within it also present.  If false, the question and any contained groups may be skipped when answering the questionnaire.")
        private BooleanDt myRequired;
        @Child(name="repeats", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If true, the question may have more than one answer.")
        private BooleanDt myRepeats;
        @Child(name="options", order=6, min=0, max=1, summary=false, modifier=false, type={ValueSet.class})
        @Description(shortDefinition="", formalDefinition="Reference to a value set containing a list of codes representing permitted answers for the question")
        private ResourceReferenceDt myOptions;
        @Child(name="option", type={CodingDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="For a \"choice\" question, identifies one of the permitted answers for the question.")
        private List<CodingDt> myOption;
        @Child(name="group", type={Group.class}, order=8, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Nested group, containing nested question for this question. The order of groups within the question is relevant")
        private List<Group> myGroup;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myLinkId, this.myConcept, this.myText, this.myType, this.myRequired, this.myRepeats, this.myOptions, this.myOption, this.myGroup});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLinkId, this.myConcept, this.myText, this.myType, this.myRequired, this.myRepeats, this.myOptions, this.myOption, this.myGroup});
        }

        public StringDt getLinkIdElement() {
            if (this.myLinkId == null) {
                this.myLinkId = new StringDt();
            }
            return this.myLinkId;
        }

        public String getLinkId() {
            return (String)this.getLinkIdElement().getValue();
        }

        public GroupQuestion setLinkId(StringDt theValue) {
            this.myLinkId = theValue;
            return this;
        }

        public GroupQuestion setLinkId(String theString) {
            this.myLinkId = new StringDt(theString);
            return this;
        }

        public List<CodingDt> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<CodingDt>();
            }
            return this.myConcept;
        }

        public GroupQuestion setConcept(List<CodingDt> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public CodingDt addConcept() {
            CodingDt newType = new CodingDt();
            this.getConcept().add(newType);
            return newType;
        }

        public GroupQuestion addConcept(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getConcept().add(theValue);
            return this;
        }

        public CodingDt getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public GroupQuestion setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public GroupQuestion setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<AnswerFormatEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(AnswerFormatEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public GroupQuestion setType(BoundCodeDt<AnswerFormatEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public GroupQuestion setType(AnswerFormatEnum theValue) {
            this.getTypeElement().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BooleanDt getRequiredElement() {
            if (this.myRequired == null) {
                this.myRequired = new BooleanDt();
            }
            return this.myRequired;
        }

        public Boolean getRequired() {
            return (Boolean)this.getRequiredElement().getValue();
        }

        public GroupQuestion setRequired(BooleanDt theValue) {
            this.myRequired = theValue;
            return this;
        }

        public GroupQuestion setRequired(boolean theBoolean) {
            this.myRequired = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getRepeatsElement() {
            if (this.myRepeats == null) {
                this.myRepeats = new BooleanDt();
            }
            return this.myRepeats;
        }

        public Boolean getRepeats() {
            return (Boolean)this.getRepeatsElement().getValue();
        }

        public GroupQuestion setRepeats(BooleanDt theValue) {
            this.myRepeats = theValue;
            return this;
        }

        public GroupQuestion setRepeats(boolean theBoolean) {
            this.myRepeats = new BooleanDt(theBoolean);
            return this;
        }

        public ResourceReferenceDt getOptions() {
            if (this.myOptions == null) {
                this.myOptions = new ResourceReferenceDt();
            }
            return this.myOptions;
        }

        public GroupQuestion setOptions(ResourceReferenceDt theValue) {
            this.myOptions = theValue;
            return this;
        }

        public List<CodingDt> getOption() {
            if (this.myOption == null) {
                this.myOption = new ArrayList<CodingDt>();
            }
            return this.myOption;
        }

        public GroupQuestion setOption(List<CodingDt> theValue) {
            this.myOption = theValue;
            return this;
        }

        public CodingDt addOption() {
            CodingDt newType = new CodingDt();
            this.getOption().add(newType);
            return newType;
        }

        public GroupQuestion addOption(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getOption().add(theValue);
            return this;
        }

        public CodingDt getOptionFirstRep() {
            if (this.getOption().isEmpty()) {
                return this.addOption();
            }
            return this.getOption().get(0);
        }

        public List<Group> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public GroupQuestion setGroup(List<Group> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Group addGroup() {
            Group newType = new Group();
            this.getGroup().add(newType);
            return newType;
        }

        public GroupQuestion addGroup(Group theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getGroup().add(theValue);
            return this;
        }

        public Group getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }
    }

    @Block
    public static class Group
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="linkId", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier that is unique within the Questionnaire allowing linkage to the equivalent group in a QuestionnaireResponse resource.")
        private StringDt myLinkId;
        @Child(name="title", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The human-readable name for this section of the questionnaire")
        private StringDt myTitle;
        @Child(name="concept", type={CodingDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a how this group of questions is known in a particular terminology such as LOINC.")
        private List<CodingDt> myConcept;
        @Child(name="text", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional text for the group, used for display purposes")
        private StringDt myText;
        @Child(name="required", type={BooleanDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If true, indicates that the group must be present and have required questions within it answered.  If false, the group may be skipped when answering the questionnaire.")
        private BooleanDt myRequired;
        @Child(name="repeats", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether the group may occur multiple times in the instance, containing multiple sets of answers")
        private BooleanDt myRepeats;
        @Child(name="group", type={Group.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A sub-group within a group. The ordering of groups within this group is relevant")
        private List<Group> myGroup;
        @Child(name="question", order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Set of questions within this group. The order of questions within the group is relevant")
        private List<GroupQuestion> myQuestion;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myLinkId, this.myTitle, this.myConcept, this.myText, this.myRequired, this.myRepeats, this.myGroup, this.myQuestion});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLinkId, this.myTitle, this.myConcept, this.myText, this.myRequired, this.myRepeats, this.myGroup, this.myQuestion});
        }

        public StringDt getLinkIdElement() {
            if (this.myLinkId == null) {
                this.myLinkId = new StringDt();
            }
            return this.myLinkId;
        }

        public String getLinkId() {
            return (String)this.getLinkIdElement().getValue();
        }

        public Group setLinkId(StringDt theValue) {
            this.myLinkId = theValue;
            return this;
        }

        public Group setLinkId(String theString) {
            this.myLinkId = new StringDt(theString);
            return this;
        }

        public StringDt getTitleElement() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public String getTitle() {
            return (String)this.getTitleElement().getValue();
        }

        public Group setTitle(StringDt theValue) {
            this.myTitle = theValue;
            return this;
        }

        public Group setTitle(String theString) {
            this.myTitle = new StringDt(theString);
            return this;
        }

        public List<CodingDt> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<CodingDt>();
            }
            return this.myConcept;
        }

        public Group setConcept(List<CodingDt> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public CodingDt addConcept() {
            CodingDt newType = new CodingDt();
            this.getConcept().add(newType);
            return newType;
        }

        public Group addConcept(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getConcept().add(theValue);
            return this;
        }

        public CodingDt getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Group setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Group setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public BooleanDt getRequiredElement() {
            if (this.myRequired == null) {
                this.myRequired = new BooleanDt();
            }
            return this.myRequired;
        }

        public Boolean getRequired() {
            return (Boolean)this.getRequiredElement().getValue();
        }

        public Group setRequired(BooleanDt theValue) {
            this.myRequired = theValue;
            return this;
        }

        public Group setRequired(boolean theBoolean) {
            this.myRequired = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getRepeatsElement() {
            if (this.myRepeats == null) {
                this.myRepeats = new BooleanDt();
            }
            return this.myRepeats;
        }

        public Boolean getRepeats() {
            return (Boolean)this.getRepeatsElement().getValue();
        }

        public Group setRepeats(BooleanDt theValue) {
            this.myRepeats = theValue;
            return this;
        }

        public Group setRepeats(boolean theBoolean) {
            this.myRepeats = new BooleanDt(theBoolean);
            return this;
        }

        public List<Group> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public Group setGroup(List<Group> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Group addGroup() {
            Group newType = new Group();
            this.getGroup().add(newType);
            return newType;
        }

        public Group addGroup(Group theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getGroup().add(theValue);
            return this;
        }

        public Group getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }

        public List<GroupQuestion> getQuestion() {
            if (this.myQuestion == null) {
                this.myQuestion = new ArrayList<GroupQuestion>();
            }
            return this.myQuestion;
        }

        public Group setQuestion(List<GroupQuestion> theValue) {
            this.myQuestion = theValue;
            return this;
        }

        public GroupQuestion addQuestion() {
            GroupQuestion newType = new GroupQuestion();
            this.getQuestion().add(newType);
            return newType;
        }

        public Group addQuestion(GroupQuestion theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getQuestion().add(theValue);
            return this;
        }

        public GroupQuestion getQuestionFirstRep() {
            if (this.getQuestion().isEmpty()) {
                return this.addQuestion();
            }
            return this.getQuestion().get(0);
        }
    }
}

