/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.QuantityDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Questionnaire;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.QuestionnaireResponseStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.TimeDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="QuestionnaireResponse", profile="http://hl7.org/fhir/profiles/QuestionnaireResponse", id="questionnaireresponse")
public class QuestionnaireResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="QuestionnaireResponse.status", description="The status of the questionnaire response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="authored", path="QuestionnaireResponse.authored", description="When the questionnaire was authored", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="subject", path="QuestionnaireResponse.subject", description="The subject of the questionnaire", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="author", path="QuestionnaireResponse.author", description="The author of the questionnaire", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="questionnaire", path="QuestionnaireResponse.questionnaire", description="The questionnaire the answers are provided for", type="reference")
    public static final String SP_QUESTIONNAIRE = "questionnaire";
    public static final ReferenceClientParam QUESTIONNAIRE = new ReferenceClientParam("questionnaire");
    @SearchParamDefinition(name="encounter", path="QuestionnaireResponse.encounter", description="Encounter during which questionnaire was authored", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="patient", path="QuestionnaireResponse.subject", description="The patient that is the subject of the questionnaire", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="source", path="QuestionnaireResponse.source", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_AUTHOR = new Include("QuestionnaireResponse:author");
    public static final Include INCLUDE_ENCOUNTER = new Include("QuestionnaireResponse:encounter");
    public static final Include INCLUDE_PATIENT = new Include("QuestionnaireResponse:patient");
    public static final Include INCLUDE_QUESTIONNAIRE = new Include("QuestionnaireResponse:questionnaire");
    public static final Include INCLUDE_SOURCE = new Include("QuestionnaireResponse:source");
    public static final Include INCLUDE_SUBJECT = new Include("QuestionnaireResponse:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="A business identifier assigned to a particular completed (or partially completed) questionnaire")
    private IdentifierDt myIdentifier;
    @Child(name="questionnaire", order=1, min=0, max=1, summary=true, modifier=false, type={Questionnaire.class})
    @Description(shortDefinition="", formalDefinition="Indicates the Questionnaire resource that defines the form for which answers are being provided")
    private ResourceReferenceDt myQuestionnaire;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The lifecycle status of the questionnaire response as a whole.")
    private BoundCodeDt<QuestionnaireResponseStatusEnum> myStatus;
    @Child(name="subject", order=3, min=0, max=1, summary=true, modifier=false, type={IResource.class})
    @Description(shortDefinition="who.focus", formalDefinition="The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=4, min=0, max=1, summary=true, modifier=false, type={Device.class, Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.author", formalDefinition="Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system")
    private ResourceReferenceDt myAuthor;
    @Child(name="authored", type={DateTimeDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date and/or time that this version of the questionnaire response was authored")
    private DateTimeDt myAuthored;
    @Child(name="source", order=6, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="who.source", formalDefinition="The person who answered the questions about the subject.")
    private ResourceReferenceDt mySource;
    @Child(name="encounter", order=7, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="Encounter during which this set of questionnaire response were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.")
    private ResourceReferenceDt myEncounter;
    @Child(name="group", order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A group of questions to a possibly similarly grouped set of questions in the questionnaire response")
    private Group myGroup;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myQuestionnaire, this.myStatus, this.mySubject, this.myAuthor, this.myAuthored, this.mySource, this.myEncounter, this.myGroup});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myQuestionnaire, this.myStatus, this.mySubject, this.myAuthor, this.myAuthored, this.mySource, this.myEncounter, this.myGroup});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public QuestionnaireResponse setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public ResourceReferenceDt getQuestionnaire() {
        if (this.myQuestionnaire == null) {
            this.myQuestionnaire = new ResourceReferenceDt();
        }
        return this.myQuestionnaire;
    }

    public QuestionnaireResponse setQuestionnaire(ResourceReferenceDt theValue) {
        this.myQuestionnaire = theValue;
        return this;
    }

    public BoundCodeDt<QuestionnaireResponseStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(QuestionnaireResponseStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public QuestionnaireResponse setStatus(BoundCodeDt<QuestionnaireResponseStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public QuestionnaireResponse setStatus(QuestionnaireResponseStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public QuestionnaireResponse setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public QuestionnaireResponse setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateTimeDt getAuthoredElement() {
        if (this.myAuthored == null) {
            this.myAuthored = new DateTimeDt();
        }
        return this.myAuthored;
    }

    public Date getAuthored() {
        return (Date)this.getAuthoredElement().getValue();
    }

    public QuestionnaireResponse setAuthored(DateTimeDt theValue) {
        this.myAuthored = theValue;
        return this;
    }

    public QuestionnaireResponse setAuthored(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myAuthored = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public QuestionnaireResponse setAuthoredWithSecondsPrecision(Date theDate) {
        this.myAuthored = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public QuestionnaireResponse setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public QuestionnaireResponse setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public Group getGroup() {
        if (this.myGroup == null) {
            this.myGroup = new Group();
        }
        return this.myGroup;
    }

    public QuestionnaireResponse setGroup(Group theValue) {
        this.myGroup = theValue;
        return this;
    }

    public String getResourceName() {
        return "QuestionnaireResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class GroupQuestionAnswer
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="value", order=0, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, DecimalDt.class, IntegerDt.class, DateDt.class, DateTimeDt.class, InstantDt.class, TimeDt.class, StringDt.class, UriDt.class, AttachmentDt.class, CodingDt.class, QuantityDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="The answer (or one of the answers) provided by the respondent to the question")
        private IDatatype myValue;
        @Child(name="group", type={Group.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Nested group, containing nested question for this question. The order of groups within the question is relevant")
        private List<Group> myGroup;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myValue, this.myGroup});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myValue, this.myGroup});
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public GroupQuestionAnswer setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }

        public List<Group> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public GroupQuestionAnswer setGroup(List<Group> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Group addGroup() {
            Group newType = new Group();
            this.getGroup().add(newType);
            return newType;
        }

        public GroupQuestionAnswer addGroup(Group theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getGroup().add(theValue);
            return this;
        }

        public Group getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }
    }

    @Block
    public static class GroupQuestion
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="linkId", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the question from the Questionnaire that corresponds to this question in the QuestionnaireResponse resource.")
        private StringDt myLinkId;
        @Child(name="text", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The actual question as shown to the user to prompt them for an answer.")
        private StringDt myText;
        @Child(name="answer", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The respondent's answer(s) to the question")
        private List<GroupQuestionAnswer> myAnswer;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myLinkId, this.myText, this.myAnswer});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLinkId, this.myText, this.myAnswer});
        }

        public StringDt getLinkIdElement() {
            if (this.myLinkId == null) {
                this.myLinkId = new StringDt();
            }
            return this.myLinkId;
        }

        public String getLinkId() {
            return (String)this.getLinkIdElement().getValue();
        }

        public GroupQuestion setLinkId(StringDt theValue) {
            this.myLinkId = theValue;
            return this;
        }

        public GroupQuestion setLinkId(String theString) {
            this.myLinkId = new StringDt(theString);
            return this;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public GroupQuestion setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public GroupQuestion setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public List<GroupQuestionAnswer> getAnswer() {
            if (this.myAnswer == null) {
                this.myAnswer = new ArrayList<GroupQuestionAnswer>();
            }
            return this.myAnswer;
        }

        public GroupQuestion setAnswer(List<GroupQuestionAnswer> theValue) {
            this.myAnswer = theValue;
            return this;
        }

        public GroupQuestionAnswer addAnswer() {
            GroupQuestionAnswer newType = new GroupQuestionAnswer();
            this.getAnswer().add(newType);
            return newType;
        }

        public GroupQuestion addAnswer(GroupQuestionAnswer theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAnswer().add(theValue);
            return this;
        }

        public GroupQuestionAnswer getAnswerFirstRep() {
            if (this.getAnswer().isEmpty()) {
                return this.addAnswer();
            }
            return this.getAnswer().get(0);
        }
    }

    @Block
    public static class Group
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="linkId", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the group from the Questionnaire that corresponds to this group in the QuestionnaireResponse resource.")
        private StringDt myLinkId;
        @Child(name="title", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Text that is displayed above the contents of the group")
        private StringDt myTitle;
        @Child(name="text", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional text for the group, used for display purposes")
        private StringDt myText;
        @Child(name="subject", order=3, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="More specific subject this section's answers are about, details the subject given in QuestionnaireResponse")
        private ResourceReferenceDt mySubject;
        @Child(name="group", type={Group.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A sub-group within a group. The ordering of groups within this group is relevant")
        private List<Group> myGroup;
        @Child(name="question", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Set of questions within this group. The order of questions within the group is relevant")
        private List<GroupQuestion> myQuestion;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myLinkId, this.myTitle, this.myText, this.mySubject, this.myGroup, this.myQuestion});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLinkId, this.myTitle, this.myText, this.mySubject, this.myGroup, this.myQuestion});
        }

        public StringDt getLinkIdElement() {
            if (this.myLinkId == null) {
                this.myLinkId = new StringDt();
            }
            return this.myLinkId;
        }

        public String getLinkId() {
            return (String)this.getLinkIdElement().getValue();
        }

        public Group setLinkId(StringDt theValue) {
            this.myLinkId = theValue;
            return this;
        }

        public Group setLinkId(String theString) {
            this.myLinkId = new StringDt(theString);
            return this;
        }

        public StringDt getTitleElement() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public String getTitle() {
            return (String)this.getTitleElement().getValue();
        }

        public Group setTitle(StringDt theValue) {
            this.myTitle = theValue;
            return this;
        }

        public Group setTitle(String theString) {
            this.myTitle = new StringDt(theString);
            return this;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Group setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Group setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getSubject() {
            if (this.mySubject == null) {
                this.mySubject = new ResourceReferenceDt();
            }
            return this.mySubject;
        }

        public Group setSubject(ResourceReferenceDt theValue) {
            this.mySubject = theValue;
            return this;
        }

        public List<Group> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public Group setGroup(List<Group> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Group addGroup() {
            Group newType = new Group();
            this.getGroup().add(newType);
            return newType;
        }

        public Group addGroup(Group theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getGroup().add(theValue);
            return this;
        }

        public Group getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }

        public List<GroupQuestion> getQuestion() {
            if (this.myQuestion == null) {
                this.myQuestion = new ArrayList<GroupQuestion>();
            }
            return this.myQuestion;
        }

        public Group setQuestion(List<GroupQuestion> theValue) {
            this.myQuestion = theValue;
            return this;
        }

        public GroupQuestion addQuestion() {
            GroupQuestion newType = new GroupQuestion();
            this.getQuestion().add(newType);
            return newType;
        }

        public Group addQuestion(GroupQuestion theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getQuestion().add(theValue);
            return this;
        }

        public GroupQuestion getQuestionFirstRep() {
            if (this.getQuestion().isEmpty()) {
                return this.addQuestion();
            }
            return this.getQuestion().get(0);
        }
    }
}

