/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Remittance", profile="http://hl7.org/fhir/profiles/Remittance", id="remittance")
public class Remittance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Remittance.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="service", path="Remittance.service.code", description="", type="token")
    public static final String SP_SERVICE = "service";
    public static final TokenClientParam SERVICE = new TokenClientParam("service");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The remittance identifier")
    private IdentifierDt myIdentifier;
    @Child(name="service", order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A service paid as part of remittance")
    private List<Service> myService;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myService});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myService});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Remittance setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public List<Service> getService() {
        if (this.myService == null) {
            this.myService = new ArrayList<Service>();
        }
        return this.myService;
    }

    public Remittance setService(List<Service> theValue) {
        this.myService = theValue;
        return this;
    }

    public Service addService() {
        Service newType = new Service();
        this.getService().add(newType);
        return newType;
    }

    public Remittance addService(Service theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getService().add(theValue);
        return this;
    }

    public Service getServiceFirstRep() {
        if (this.getService().isEmpty()) {
            return this.addService();
        }
        return this.getService().get(0);
    }

    public String getResourceName() {
        return "Remittance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Service
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="instance", type={IntegerDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The service instance number for the original transaction")
        private IntegerDt myInstance;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The code for the professional service")
        private CodeableConceptDt myCode;
        @Child(name="rate", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The percent of the service fee which would be eligible for coverage")
        private DecimalDt myRate;
        @Child(name="benefit", type={DecimalDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount payable for a submitted service (includes both professional and lab fees.)")
        private DecimalDt myBenefit;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myInstance, this.myCode, this.myRate, this.myBenefit});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myInstance, this.myCode, this.myRate, this.myBenefit});
        }

        public IntegerDt getInstanceElement() {
            if (this.myInstance == null) {
                this.myInstance = new IntegerDt();
            }
            return this.myInstance;
        }

        public Integer getInstance() {
            return (Integer)this.getInstanceElement().getValue();
        }

        public Service setInstance(IntegerDt theValue) {
            this.myInstance = theValue;
            return this;
        }

        public Service setInstance(int theInteger) {
            this.myInstance = new IntegerDt(theInteger);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Service setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public DecimalDt getRateElement() {
            if (this.myRate == null) {
                this.myRate = new DecimalDt();
            }
            return this.myRate;
        }

        public BigDecimal getRate() {
            return (BigDecimal)this.getRateElement().getValue();
        }

        public Service setRate(DecimalDt theValue) {
            this.myRate = theValue;
            return this;
        }

        public Service setRate(long theValue) {
            this.myRate = new DecimalDt(theValue);
            return this;
        }

        public Service setRate(double theValue) {
            this.myRate = new DecimalDt(theValue);
            return this;
        }

        public Service setRate(BigDecimal theValue) {
            this.myRate = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getBenefitElement() {
            if (this.myBenefit == null) {
                this.myBenefit = new DecimalDt();
            }
            return this.myBenefit;
        }

        public BigDecimal getBenefit() {
            return (BigDecimal)this.getBenefitElement().getValue();
        }

        public Service setBenefit(DecimalDt theValue) {
            this.myBenefit = theValue;
            return this;
        }

        public Service setBenefit(long theValue) {
            this.myBenefit = new DecimalDt(theValue);
            return this;
        }

        public Service setBenefit(double theValue) {
            this.myBenefit = new DecimalDt(theValue);
            return this;
        }

        public Service setBenefit(BigDecimal theValue) {
            this.myBenefit = new DecimalDt(theValue);
            return this;
        }
    }
}

