/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Schedule;
import ca.uhn.fhir.model.dstu2.valueset.SlotStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Slot", profile="http://hl7.org/fhir/profiles/Slot", id="slot")
public class Slot
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="slot-type", path="Slot.type", description="The type of appointments that can be booked into the slot", type="token")
    public static final String SP_SLOT_TYPE = "slot-type";
    public static final TokenClientParam SLOT_TYPE = new TokenClientParam("slot-type");
    @SearchParamDefinition(name="schedule", path="Slot.schedule", description="The Schedule Resource that we are seeking a slot within", type="reference")
    public static final String SP_SCHEDULE = "schedule";
    public static final ReferenceClientParam SCHEDULE = new ReferenceClientParam("schedule");
    @SearchParamDefinition(name="start", path="Slot.start", description="Appointment date/time.", type="date")
    public static final String SP_START = "start";
    public static final DateClientParam START = new DateClientParam("start");
    @SearchParamDefinition(name="fb-type", path="Slot.freeBusyType", description="The free/busy status of the appointment", type="token")
    public static final String SP_FB_TYPE = "fb-type";
    public static final TokenClientParam FB_TYPE = new TokenClientParam("fb-type");
    @SearchParamDefinition(name="identifier", path="Slot.identifier", description="A Slot Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_SCHEDULE = new Include("Slot:schedule");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="")
    private CodeableConceptDt myType;
    @Child(name="schedule", order=2, min=1, max=1, summary=true, modifier=false, type={Schedule.class})
    @Description(shortDefinition="", formalDefinition="")
    private ResourceReferenceDt mySchedule;
    @Child(name="freeBusyType", type={CodeDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private BoundCodeDt<SlotStatusEnum> myFreeBusyType;
    @Child(name="start", type={InstantDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.planned", formalDefinition="")
    private InstantDt myStart;
    @Child(name="end", type={InstantDt.class}, order=5, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.planned", formalDefinition="")
    private InstantDt myEnd;
    @Child(name="overbooked", type={BooleanDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private BooleanDt myOverbooked;
    @Child(name="comment", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private StringDt myComment;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.mySchedule, this.myFreeBusyType, this.myStart, this.myEnd, this.myOverbooked, this.myComment});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.mySchedule, this.myFreeBusyType, this.myStart, this.myEnd, this.myOverbooked, this.myComment});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Slot setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Slot addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Slot setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public ResourceReferenceDt getSchedule() {
        if (this.mySchedule == null) {
            this.mySchedule = new ResourceReferenceDt();
        }
        return this.mySchedule;
    }

    public Slot setSchedule(ResourceReferenceDt theValue) {
        this.mySchedule = theValue;
        return this;
    }

    public BoundCodeDt<SlotStatusEnum> getFreeBusyTypeElement() {
        if (this.myFreeBusyType == null) {
            this.myFreeBusyType = new BoundCodeDt(SlotStatusEnum.VALUESET_BINDER);
        }
        return this.myFreeBusyType;
    }

    public String getFreeBusyType() {
        return (String)this.getFreeBusyTypeElement().getValue();
    }

    public Slot setFreeBusyType(BoundCodeDt<SlotStatusEnum> theValue) {
        this.myFreeBusyType = theValue;
        return this;
    }

    public Slot setFreeBusyType(SlotStatusEnum theValue) {
        this.getFreeBusyTypeElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public InstantDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public Date getStart() {
        return (Date)this.getStartElement().getValue();
    }

    public Slot setStart(InstantDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public Slot setStartWithMillisPrecision(Date theDate) {
        this.myStart = new InstantDt(theDate);
        return this;
    }

    public Slot setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new InstantDt(theDate, thePrecision);
        return this;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public Date getEnd() {
        return (Date)this.getEndElement().getValue();
    }

    public Slot setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public Slot setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public Slot setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public BooleanDt getOverbookedElement() {
        if (this.myOverbooked == null) {
            this.myOverbooked = new BooleanDt();
        }
        return this.myOverbooked;
    }

    public Boolean getOverbooked() {
        return (Boolean)this.getOverbookedElement().getValue();
    }

    public Slot setOverbooked(BooleanDt theValue) {
        this.myOverbooked = theValue;
        return this;
    }

    public Slot setOverbooked(boolean theBoolean) {
        this.myOverbooked = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public String getComment() {
        return (String)this.getCommentElement().getValue();
    }

    public Slot setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public Slot setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Slot";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

