/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.SubstanceCategoryCodesEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Substance", profile="http://hl7.org/fhir/profiles/Substance", id="substance")
public class Substance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Substance.code", description="The code of the substance", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="category", path="Substance.category", description="The category of the substance", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="container-identifier", path="Substance.instance.identifier", description="Identifier of the package/container", type="token")
    public static final String SP_CONTAINER_IDENTIFIER = "container-identifier";
    public static final TokenClientParam CONTAINER_IDENTIFIER = new TokenClientParam("container-identifier");
    @SearchParamDefinition(name="expiry", path="Substance.instance.expiry", description="Expiry date of package or container of substance", type="date")
    public static final String SP_EXPIRY = "expiry";
    public static final DateClientParam EXPIRY = new DateClientParam("expiry");
    @SearchParamDefinition(name="quantity", path="Substance.instance.quantity", description="Amount of substance in the package", type="quantity")
    public static final String SP_QUANTITY = "quantity";
    public static final QuantityClientParam QUANTITY = new QuantityClientParam("quantity");
    @SearchParamDefinition(name="substance", path="Substance.ingredient.substance", description="A component of the substance", type="reference")
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    @SearchParamDefinition(name="identifier", path="Substance.identifier", description="Unique identifier for the substance", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_SUBSTANCE = new Include("Substance:substance");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Unique identifier for the substance")
    private List<IdentifierDt> myIdentifier;
    @Child(name="category", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A code that classifies the general type of substance.  This is used  for searching, sorting and display purposes.")
    private List<BoundCodeableConceptDt<SubstanceCategoryCodesEnum>> myCategory;
    @Child(name="code", type={CodeableConceptDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="what", formalDefinition="A code (or set of codes) that identify this substance")
    private CodeableConceptDt myCode;
    @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the substance - its appearance, handling requirements, and other usage notes")
    private StringDt myDescription;
    @Child(name="instance", order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance")
    private List<Instance> myInstance;
    @Child(name="ingredient", order=5, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A substance can be composed of other substances")
    private List<Ingredient> myIngredient;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCategory, this.myCode, this.myDescription, this.myInstance, this.myIngredient});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCategory, this.myCode, this.myDescription, this.myInstance, this.myIngredient});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Substance setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Substance addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<BoundCodeableConceptDt<SubstanceCategoryCodesEnum>> getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new ArrayList<BoundCodeableConceptDt<SubstanceCategoryCodesEnum>>();
        }
        return this.myCategory;
    }

    public Substance setCategory(List<BoundCodeableConceptDt<SubstanceCategoryCodesEnum>> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public BoundCodeableConceptDt<SubstanceCategoryCodesEnum> addCategory(SubstanceCategoryCodesEnum theValue) {
        BoundCodeableConceptDt<SubstanceCategoryCodesEnum> retVal = new BoundCodeableConceptDt<SubstanceCategoryCodesEnum>(SubstanceCategoryCodesEnum.VALUESET_BINDER, theValue);
        this.getCategory().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<SubstanceCategoryCodesEnum> getCategoryFirstRep() {
        if (this.getCategory().size() == 0) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public BoundCodeableConceptDt<SubstanceCategoryCodesEnum> addCategory() {
        BoundCodeableConceptDt<SubstanceCategoryCodesEnum> retVal = new BoundCodeableConceptDt<SubstanceCategoryCodesEnum>(SubstanceCategoryCodesEnum.VALUESET_BINDER);
        this.getCategory().add(retVal);
        return retVal;
    }

    public Substance setCategory(SubstanceCategoryCodesEnum theValue) {
        this.getCategory().clear();
        this.addCategory(theValue);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Substance setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public Substance setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Substance setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<Instance> getInstance() {
        if (this.myInstance == null) {
            this.myInstance = new ArrayList<Instance>();
        }
        return this.myInstance;
    }

    public Substance setInstance(List<Instance> theValue) {
        this.myInstance = theValue;
        return this;
    }

    public Instance addInstance() {
        Instance newType = new Instance();
        this.getInstance().add(newType);
        return newType;
    }

    public Substance addInstance(Instance theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getInstance().add(theValue);
        return this;
    }

    public Instance getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            return this.addInstance();
        }
        return this.getInstance().get(0);
    }

    public List<Ingredient> getIngredient() {
        if (this.myIngredient == null) {
            this.myIngredient = new ArrayList<Ingredient>();
        }
        return this.myIngredient;
    }

    public Substance setIngredient(List<Ingredient> theValue) {
        this.myIngredient = theValue;
        return this;
    }

    public Ingredient addIngredient() {
        Ingredient newType = new Ingredient();
        this.getIngredient().add(newType);
        return newType;
    }

    public Substance addIngredient(Ingredient theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIngredient().add(theValue);
        return this;
    }

    public Ingredient getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            return this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public String getResourceName() {
        return "Substance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Ingredient
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="quantity", type={RatioDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount of the ingredient in the substance - a concentration ratio")
        private RatioDt myQuantity;
        @Child(name="substance", order=1, min=1, max=1, summary=true, modifier=false, type={Substance.class})
        @Description(shortDefinition="", formalDefinition="Another substance that is a component of this substance")
        private ResourceReferenceDt mySubstance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myQuantity, this.mySubstance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myQuantity, this.mySubstance});
        }

        public RatioDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new RatioDt();
            }
            return this.myQuantity;
        }

        public Ingredient setQuantity(RatioDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public ResourceReferenceDt getSubstance() {
            if (this.mySubstance == null) {
                this.mySubstance = new ResourceReferenceDt();
            }
            return this.mySubstance;
        }

        public Ingredient setSubstance(ResourceReferenceDt theValue) {
            this.mySubstance = theValue;
            return this;
        }
    }

    @Block
    public static class Instance
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifier associated with the package/container (usually a label affixed directly)")
        private IdentifierDt myIdentifier;
        @Child(name="expiry", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.")
        private DateTimeDt myExpiry;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount of the substance")
        private SimpleQuantityDt myQuantity;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myExpiry, this.myQuantity});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myExpiry, this.myQuantity});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Instance setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public DateTimeDt getExpiryElement() {
            if (this.myExpiry == null) {
                this.myExpiry = new DateTimeDt();
            }
            return this.myExpiry;
        }

        public Date getExpiry() {
            return (Date)this.getExpiryElement().getValue();
        }

        public Instance setExpiry(DateTimeDt theValue) {
            this.myExpiry = theValue;
            return this;
        }

        public Instance setExpiry(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myExpiry = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Instance setExpiryWithSecondsPrecision(Date theDate) {
            this.myExpiry = new DateTimeDt(theDate);
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public Instance setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }
    }
}

