/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.dstu2.valueset.SupplyDeliveryStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="SupplyDelivery", profile="http://hl7.org/fhir/profiles/SupplyDelivery", id="supplydelivery")
public class SupplyDelivery
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="supplier", path="SupplyDelivery.supplier", description="", type="reference")
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    @SearchParamDefinition(name="identifier", path="SupplyDelivery.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="SupplyDelivery.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="patient", path="SupplyDelivery.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="receiver", path="SupplyDelivery.receiver", description="", type="reference")
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_PATIENT = new Include("SupplyDelivery:patient");
    public static final Include INCLUDE_RECEIVER = new Include("SupplyDelivery:receiver");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyDelivery:supplier");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifier assigned by the dispensing facility when the item(s) is dispensed.")
    private IdentifierDt myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="A code specifying the state of the dispense event.")
    private BoundCodeDt<SupplyDeliveryStatusEnum> myStatus;
    @Child(name="patient", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="A link to a resource representing the person whom the delivered item is for")
    private ResourceReferenceDt myPatient;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
    private CodeableConceptDt myType;
    @Child(name="quantity", type={SimpleQuantityDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The amount of supply that has been dispensed. Includes unit of measure.")
    private SimpleQuantityDt myQuantity;
    @Child(name="suppliedItem", order=5, min=0, max=1, summary=false, modifier=false, type={Medication.class, Substance.class, Device.class})
    @Description(shortDefinition="", formalDefinition="Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a simple attribute carrying a code that identifies the item from a known list.")
    private ResourceReferenceDt mySuppliedItem;
    @Child(name="supplier", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The individual responsible for dispensing the medication, supplier or device.")
    private ResourceReferenceDt mySupplier;
    @Child(name="whenPrepared", type={PeriodDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time the dispense event occurred.")
    private PeriodDt myWhenPrepared;
    @Child(name="time", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time the dispensed item was sent or handed to the patient (or agent).")
    private DateTimeDt myTime;
    @Child(name="destination", order=9, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="Identification of the facility/location where the Supply was shipped to, as part of the dispense event.")
    private ResourceReferenceDt myDestination;
    @Child(name="receiver", order=10, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="Identifies the person who picked up the Supply.")
    private List<ResourceReferenceDt> myReceiver;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myType, this.myQuantity, this.mySuppliedItem, this.mySupplier, this.myWhenPrepared, this.myTime, this.myDestination, this.myReceiver});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myType, this.myQuantity, this.mySuppliedItem, this.mySupplier, this.myWhenPrepared, this.myTime, this.myDestination, this.myReceiver});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public SupplyDelivery setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public BoundCodeDt<SupplyDeliveryStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SupplyDeliveryStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public SupplyDelivery setStatus(BoundCodeDt<SupplyDeliveryStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public SupplyDelivery setStatus(SupplyDeliveryStatusEnum theValue) {
        this.getStatusElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public SupplyDelivery setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public SupplyDelivery setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public SimpleQuantityDt getQuantity() {
        if (this.myQuantity == null) {
            this.myQuantity = new SimpleQuantityDt();
        }
        return this.myQuantity;
    }

    public SupplyDelivery setQuantity(SimpleQuantityDt theValue) {
        this.myQuantity = theValue;
        return this;
    }

    public ResourceReferenceDt getSuppliedItem() {
        if (this.mySuppliedItem == null) {
            this.mySuppliedItem = new ResourceReferenceDt();
        }
        return this.mySuppliedItem;
    }

    public SupplyDelivery setSuppliedItem(ResourceReferenceDt theValue) {
        this.mySuppliedItem = theValue;
        return this;
    }

    public ResourceReferenceDt getSupplier() {
        if (this.mySupplier == null) {
            this.mySupplier = new ResourceReferenceDt();
        }
        return this.mySupplier;
    }

    public SupplyDelivery setSupplier(ResourceReferenceDt theValue) {
        this.mySupplier = theValue;
        return this;
    }

    public PeriodDt getWhenPrepared() {
        if (this.myWhenPrepared == null) {
            this.myWhenPrepared = new PeriodDt();
        }
        return this.myWhenPrepared;
    }

    public SupplyDelivery setWhenPrepared(PeriodDt theValue) {
        this.myWhenPrepared = theValue;
        return this;
    }

    public DateTimeDt getTimeElement() {
        if (this.myTime == null) {
            this.myTime = new DateTimeDt();
        }
        return this.myTime;
    }

    public Date getTime() {
        return (Date)this.getTimeElement().getValue();
    }

    public SupplyDelivery setTime(DateTimeDt theValue) {
        this.myTime = theValue;
        return this;
    }

    public SupplyDelivery setTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public SupplyDelivery setTimeWithSecondsPrecision(Date theDate) {
        this.myTime = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getDestination() {
        if (this.myDestination == null) {
            this.myDestination = new ResourceReferenceDt();
        }
        return this.myDestination;
    }

    public SupplyDelivery setDestination(ResourceReferenceDt theValue) {
        this.myDestination = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getReceiver() {
        if (this.myReceiver == null) {
            this.myReceiver = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReceiver;
    }

    public SupplyDelivery setReceiver(List<ResourceReferenceDt> theValue) {
        this.myReceiver = theValue;
        return this;
    }

    public ResourceReferenceDt addReceiver() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getReceiver().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "SupplyDelivery";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

