/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ConditionsCodesEnum {
    HEADACHE("123987", "http://hl7.org/fhir/fm-conditions");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Conditions Codes";
    private static Map<String, ConditionsCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ConditionsCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ConditionsCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ConditionsCodesEnum forCode(String theCode) {
        ConditionsCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ConditionsCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ConditionsCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ConditionsCodesEnum>>();
        for (ConditionsCodesEnum next : ConditionsCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ConditionsCodesEnum>(){

            public String toCodeString(ConditionsCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ConditionsCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ConditionsCodesEnum fromCodeString(String theCodeString) {
                return (ConditionsCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ConditionsCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ConditionsCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

