/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ContactPointSystemEnum {
    PHONE("phone", "http://hl7.org/fhir/contact-point-system"),
    FAX("fax", "http://hl7.org/fhir/contact-point-system"),
    EMAIL("email", "http://hl7.org/fhir/contact-point-system"),
    PAGER("pager", "http://hl7.org/fhir/contact-point-system"),
    URL("other", "http://hl7.org/fhir/contact-point-system");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "ContactPointSystem";
    private static Map<String, ContactPointSystemEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ContactPointSystemEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ContactPointSystemEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ContactPointSystemEnum forCode(String theCode) {
        ContactPointSystemEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ContactPointSystemEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ContactPointSystemEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ContactPointSystemEnum>>();
        for (ContactPointSystemEnum next : ContactPointSystemEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ContactPointSystemEnum>(){

            public String toCodeString(ContactPointSystemEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ContactPointSystemEnum theEnum) {
                return theEnum.getSystem();
            }

            public ContactPointSystemEnum fromCodeString(String theCodeString) {
                return (ContactPointSystemEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ContactPointSystemEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ContactPointSystemEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

