/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum InterventionCodesEnum {
    UNKNOWN("unknown", "http://hl7.org/fhir/intervention"),
    OTHER("other", "http://hl7.org/fhir/intervention");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Intervention Codes";
    private static Map<String, InterventionCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, InterventionCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<InterventionCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static InterventionCodesEnum forCode(String theCode) {
        InterventionCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private InterventionCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, InterventionCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, InterventionCodesEnum>>();
        for (InterventionCodesEnum next : InterventionCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<InterventionCodesEnum>(){

            public String toCodeString(InterventionCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(InterventionCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public InterventionCodesEnum fromCodeString(String theCodeString) {
                return (InterventionCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public InterventionCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (InterventionCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

