/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ObservationCategoryCodesEnum {
    SOCIAL_HISTORY("social-history", "http://hl7.org/fhir/observation-category"),
    VITAL_SIGNS("vital-signs", "http://hl7.org/fhir/observation-category"),
    IMAGING("imaging", "http://hl7.org/fhir/observation-category"),
    LABORATORY("laboratory", "http://hl7.org/fhir/observation-category"),
    PROCEDURE("procedure", "http://hl7.org/fhir/observation-category"),
    SURVEY("survey", "http://hl7.org/fhir/observation-category"),
    EXAM("exam", "http://hl7.org/fhir/observation-category"),
    THERAPY("therapy", "http://hl7.org/fhir/observation-category");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Observation Category Codes";
    private static Map<String, ObservationCategoryCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ObservationCategoryCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ObservationCategoryCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ObservationCategoryCodesEnum forCode(String theCode) {
        ObservationCategoryCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ObservationCategoryCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ObservationCategoryCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ObservationCategoryCodesEnum>>();
        for (ObservationCategoryCodesEnum next : ObservationCategoryCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ObservationCategoryCodesEnum>(){

            public String toCodeString(ObservationCategoryCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ObservationCategoryCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ObservationCategoryCodesEnum fromCodeString(String theCodeString) {
                return (ObservationCategoryCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ObservationCategoryCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ObservationCategoryCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

