/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum UDICodesEnum {
    _01_123456789("{01}123456789", "http://hl7.org/fhir/ex-udi");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "UDI Codes";
    private static Map<String, UDICodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, UDICodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<UDICodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static UDICodesEnum forCode(String theCode) {
        UDICodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private UDICodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, UDICodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, UDICodesEnum>>();
        for (UDICodesEnum next : UDICodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<UDICodesEnum>(){

            public String toCodeString(UDICodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(UDICodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public UDICodesEnum fromCodeString(String theCodeString) {
                return (UDICodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public UDICodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (UDICodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

