/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.escposutils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lexpo/modules/escposutils/BitmapProcessor;", "", "<init>", "()V", "processBitmapForPrinting", "", "bitmap", "Landroid/graphics/Bitmap;", "model", "", "width", "resizeBitmap", "targetWidth", "splitBitmap", "Ljava/util/ArrayList;", "processBitmapPart", "getPixels", "", "convertPixelsToPrintData", "pixels", "height", "Companion", "expo-esc-pos-utils_debug"})
@SourceDebugExtension(value={"SMAP\nBitmapProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapProcessor.kt\nexpo/modules/escposutils/BitmapProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1863#2,2:179\n2669#2,7:181\n*S KotlinDebug\n*F\n+ 1 BitmapProcessor.kt\nexpo/modules/escposutils/BitmapProcessor\n*L\n24#1:179,2\n41#1:181,7\n*E\n"})
public final class BitmapProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int GS = 29;
    private static final int v = 118;
    private static final int MAX_HEIGHT = 320;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] processBitmapForPrinting(@NotNull Bitmap bitmap, int model, int width) {
        Object part;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap resizedBitmap = this.resizeBitmap(bitmap, width);
        ArrayList<Bitmap> bitmapParts = this.splitBitmap(resizedBitmap);
        ArrayList<byte[]> allData = new ArrayList<byte[]>();
        Iterable $this$forEach$iv = bitmapParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            part = (Bitmap)element$iv;
            boolean bl = false;
            byte[] partData = this.processBitmapPart((Bitmap)part, model);
            allData.add(partData);
            if (part.isRecycled()) continue;
            part.recycle();
        }
        if (!Intrinsics.areEqual((Object)resizedBitmap, (Object)bitmap) && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
        if (!resizedBitmap.isRecycled()) {
            resizedBitmap.recycle();
        }
        Iterable $this$reduce$iv = allData;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void bytes;
            part = (byte[])iterator$iv.next();
            byte[] acc = (byte[])accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])bytes);
        }
        return (byte[])accumulator$iv;
    }

    private final Bitmap resizeBitmap(Bitmap bitmap, int targetWidth) {
        int originalWidth = bitmap.getWidth();
        int originalHeight = bitmap.getHeight();
        if (originalWidth <= targetWidth) {
            return bitmap;
        }
        float scale = (float)targetWidth / (float)originalWidth;
        int targetHeight = (int)((float)originalHeight * scale);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)originalWidth, (int)originalHeight, (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        return bitmap2;
    }

    private final ArrayList<Bitmap> splitBitmap(Bitmap bitmap) {
        int partHeight;
        ArrayList<Bitmap> parts = new ArrayList<Bitmap>();
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        for (int currentY = 0; currentY < height; currentY += partHeight) {
            Bitmap part;
            partHeight = currentY + 320 > height ? height - currentY : 320;
            Intrinsics.checkNotNullExpressionValue((Object)Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)currentY, (int)width, (int)partHeight), (String)"createBitmap(...)");
            parts.add(part);
        }
        return parts;
    }

    private final byte[] processBitmapPart(Bitmap bitmap, int model) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = this.getPixels(bitmap);
        int bytesPerLine = (width + 7) / 8;
        byte[] byArray = new byte[]{29, 118, 48, (byte)model, (byte)(bytesPerLine % 256), (byte)(bytesPerLine / 256), (byte)(height % 256), (byte)(height / 256)};
        byte[] header = byArray;
        byte[] printData = this.convertPixelsToPrintData(pixels, width, height);
        return ArraysKt.plus((byte[])header, (byte[])printData);
    }

    private final int[] getPixels(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int n = pixels.length;
        for (int i = 0; i < n; ++i) {
            int pixel = pixels[i];
            int alpha = (pixel & 0xFF000000) >>> 24;
            int red = (pixel & 0xFF0000) >>> 16;
            int green = (pixel & 0xFF00) >>> 8;
            int blue = pixel & 0xFF;
            int gray = red + green + blue;
            pixels[i] = alpha != 0 && gray <= 382 ? -16777216 : -1;
        }
        return pixels;
    }

    private final byte[] convertPixelsToPrintData(int[] pixels, int width, int height) {
        int bytesPerLine = (width + 7) / 8;
        byte[] printData = new byte[bytesPerLine * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixelIndex = y * width + x;
                int byteIndex = y * bytesPerLine + x / 8;
                int bitIndex = 7 - x % 8;
                if (pixels[pixelIndex] != -16777216) continue;
                printData[byteIndex] = (byte)(printData[byteIndex] | 1 << bitIndex);
            }
        }
        return printData;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lexpo/modules/escposutils/BitmapProcessor$Companion;", "", "<init>", "()V", "GS", "", "v", "MAX_HEIGHT", "expo-esc-pos-utils_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

