/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.appchecker;

import android.content.pm.PackageManager;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lexpo/modules/appchecker/AppCheckerModule;", "Lcom/facebook/react/bridge/ReactContextBaseJavaModule;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "context", "checkAppExists", "", "packageName", "", "promise", "Lcom/facebook/react/bridge/Promise;", "getName", "expo-plugin-app-checker_debug"})
public final class AppCheckerModule
extends ReactContextBaseJavaModule {
    @NotNull
    private final ReactApplicationContext context;

    public AppCheckerModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)reactContext, (String)"reactContext");
        super(reactContext);
        this.context = reactContext;
    }

    @NotNull
    public String getName() {
        return "AppChecker";
    }

    @ReactMethod
    public final void checkAppExists(@NotNull String packageName, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        PackageManager packageManager = this.context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
        PackageManager pm = packageManager;
        try {
            pm.getPackageInfo(packageName, 1);
            promise.resolve((Object)true);
        }
        catch (PackageManager.NameNotFoundException e) {
            promise.resolve((Object)false);
        }
        catch (Exception e) {
            promise.reject("APP_CHECK_ERROR", "Error checking app: " + e.getMessage(), (Throwable)e);
        }
    }
}

