/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.wing.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static final String EXT = ".zip";
    private static final String PATH = "/";
    private static final int BUFFER = 1024;
    private static File destFile;

    public static void compress(File srcFile, File destFile) throws Exception {
        ZipUtils.destFile = destFile;
        CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(destFile), new CRC32());
        ZipOutputStream zos = new ZipOutputStream(cos);
        File[] files = srcFile.listFiles();
        if (files.length < 1) {
            ZipEntry entry = new ZipEntry(PATH);
            zos.putNextEntry(entry);
            zos.closeEntry();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ZipUtils.compress(file, zos, "");
            ++n2;
        }
        zos.flush();
        zos.close();
    }

    private static void compress(File srcFile, ZipOutputStream zos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            ZipUtils.compressDir(srcFile, zos, basePath);
        } else {
            ZipUtils.compressFile(srcFile, zos, basePath);
        }
    }

    private static void compressDir(File dir, ZipOutputStream zos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files.length < 1) {
            ZipEntry entry = new ZipEntry(String.valueOf(basePath) + dir.getName() + PATH);
            zos.putNextEntry(entry);
            zos.closeEntry();
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ZipUtils.compress(file, zos, String.valueOf(basePath) + dir.getName() + PATH);
            ++n2;
        }
    }

    private static void compressFile(File file, ZipOutputStream zos, String dir) throws Exception {
        int count;
        if (file.getAbsolutePath().equals(destFile.getAbsolutePath())) {
            return;
        }
        ZipEntry entry = new ZipEntry(String.valueOf(dir) + file.getName());
        zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[1024];
        while ((count = bis.read(data, 0, 1024)) != -1) {
            zos.write(data, 0, count);
        }
        bis.close();
        zos.closeEntry();
    }

    public static void main(String[] args) throws Exception {
        File source = new File(args[0]);
        if (!source.exists()) {
            System.out.println(String.valueOf(args[0]) + " is not found");
            return;
        }
        File targetZip = new File(args[1]);
        ZipUtils.compress(source, targetZip);
    }
}

