/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.GroupedRandomAccessSource;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.MappedChannelRandomAccessSource;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PagedChannelRandomAccessSource
extends GroupedRandomAccessSource
implements IRandomAccessSource {
    public static final int DEFAULT_TOTAL_BUFSIZE = 0x4000000;
    public static final int DEFAULT_MAX_OPEN_BUFFERS = 16;
    private static final long serialVersionUID = 4297575388315637274L;
    private final int bufferSize;
    private final FileChannel channel;
    private final MRU<IRandomAccessSource> mru;

    public PagedChannelRandomAccessSource(FileChannel channel) throws IOException {
        this(channel, 0x4000000, 16);
    }

    public PagedChannelRandomAccessSource(FileChannel channel, int totalBufferSize, int maxOpenBuffers) throws IOException {
        super(PagedChannelRandomAccessSource.buildSources(channel, totalBufferSize / maxOpenBuffers));
        this.channel = channel;
        this.bufferSize = totalBufferSize / maxOpenBuffers;
        this.mru = new MRU(maxOpenBuffers);
    }

    private static IRandomAccessSource[] buildSources(FileChannel channel, int bufferSize) throws IOException {
        long size = channel.size();
        if (size <= 0L) {
            throw new IOException("File size must be greater than zero");
        }
        int bufferCount = (int)(size / (long)bufferSize) + (size % (long)bufferSize == 0L ? 0 : 1);
        IRandomAccessSource[] sources = new MappedChannelRandomAccessSource[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            long pageOffset = (long)i * (long)bufferSize;
            long pageLength = Math.min(size - pageOffset, (long)bufferSize);
            sources[i] = new MappedChannelRandomAccessSource(channel, pageOffset, pageLength);
        }
        return sources;
    }

    @Override
    protected int getStartingSourceIndex(long offset) {
        return (int)(offset / (long)this.bufferSize);
    }

    @Override
    protected void sourceReleased(IRandomAccessSource source) throws IOException {
        IRandomAccessSource old = this.mru.enqueue(source);
        if (old != null) {
            old.close();
        }
    }

    @Override
    protected void sourceInUse(IRandomAccessSource source) throws IOException {
        ((MappedChannelRandomAccessSource)source).open();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                Logger logger = LoggerFactory.getLogger(PagedChannelRandomAccessSource.class);
                logger.error("Closing of the file channel this source is based on failed.", ex);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this.getClass().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.getClass().toString());
    }

    private static class MRU<E> {
        private final int limit;
        private LinkedList<E> queue = new LinkedList();

        public MRU(int limit) {
            this.limit = limit;
        }

        public E enqueue(E newElement) {
            if (this.queue.size() > 0 && this.queue.getFirst() == newElement) {
                return null;
            }
            Iterator it = this.queue.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (newElement != element) continue;
                it.remove();
                this.queue.addFirst(newElement);
                return null;
            }
            this.queue.addFirst(newElement);
            if (this.queue.size() > this.limit) {
                return this.queue.removeLast();
            }
            return null;
        }
    }
}

