/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.AdobeGlyphList;
import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.DocFontEncoding;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.font.PdfSimpleFont;
import com.itextpdf.kernel.font.Type3FontProgram;
import com.itextpdf.kernel.font.Type3Glyph;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;

public class PdfType3Font
extends PdfSimpleFont<Type3FontProgram> {
    private static final long serialVersionUID = 4940119184993066859L;
    private double[] fontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};

    PdfType3Font(PdfDocument document, boolean colorized) {
        this.makeIndirect(document);
        this.subset = true;
        this.embedded = true;
        this.fontProgram = new Type3FontProgram(colorized);
        this.fontEncoding = FontEncoding.createEmptyFontEncoding();
    }

    PdfType3Font(PdfDictionary fontDictionary) {
        super(fontDictionary);
        PdfType3Font.ensureObjectIsAddedToDocument(fontDictionary);
        this.subset = true;
        this.embedded = true;
        this.fontProgram = new Type3FontProgram(false);
        this.fontEncoding = DocFontEncoding.createDocFontEncoding(fontDictionary.get(PdfName.Encoding), null, false);
        PdfDictionary charProcsDic = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.CharProcs);
        PdfArray fontMatrixArray = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.FontMatrix);
        if (((PdfDictionary)this.getPdfObject()).containsKey(PdfName.FontBBox)) {
            PdfArray fontBBox = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.FontBBox);
            this.fontProgram.getFontMetrics().setBbox(fontBBox.getAsNumber(0).intValue(), fontBBox.getAsNumber(1).intValue(), fontBBox.getAsNumber(2).intValue(), fontBBox.getAsNumber(3).intValue());
        } else {
            this.fontProgram.getFontMetrics().setBbox(0, 0, 0, 0);
        }
        PdfNumber firstCharNumber = fontDictionary.getAsNumber(PdfName.FirstChar);
        int firstChar = firstCharNumber != null ? Math.max(firstCharNumber.intValue(), 0) : 0;
        int[] widths = FontUtil.convertSimpleWidthsArray(fontDictionary.getAsArray(PdfName.Widths), firstChar, 0);
        double[] fontMatrix = new double[6];
        for (int i = 0; i < fontMatrixArray.size(); ++i) {
            fontMatrix[i] = ((PdfNumber)fontMatrixArray.get(i)).getValue();
        }
        this.setFontMatrix(fontMatrix);
        for (PdfName glyphName : charProcsDic.keySet()) {
            int unicode = AdobeGlyphList.nameToUnicode(glyphName.getValue());
            if (unicode == -1 || !this.fontEncoding.canEncode(unicode)) continue;
            int code = this.fontEncoding.convertToByte(unicode);
            ((Type3FontProgram)this.getFontProgram()).addGlyph(code, unicode, widths[code], null, new Type3Glyph(charProcsDic.getAsStream(glyphName), this.getDocument()));
        }
    }

    public Type3Glyph getType3Glyph(int unicode) {
        return ((Type3FontProgram)this.getFontProgram()).getType3Glyph(unicode);
    }

    @Override
    public boolean isSubset() {
        return true;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public double[] getFontMatrix() {
        return this.fontMatrix;
    }

    public void setFontMatrix(double[] fontMatrix) {
        this.fontMatrix = fontMatrix;
    }

    public Type3Glyph addGlyph(char c, int wx, int llx, int lly, int urx, int ury) {
        Type3Glyph glyph = this.getType3Glyph(c);
        if (glyph != null) {
            return glyph;
        }
        int code = this.getFirstEmptyCode();
        glyph = new Type3Glyph(this.getDocument(), wx, llx, lly, urx, ury, ((Type3FontProgram)this.getFontProgram()).isColorized());
        ((Type3FontProgram)this.getFontProgram()).addGlyph(code, c, wx, new int[]{llx, lly, urx, ury}, glyph);
        this.fontEncoding.addSymbol((byte)code, c);
        if (!((Type3FontProgram)this.getFontProgram()).isColorized()) {
            if (this.fontProgram.countOfGlyphs() == 0) {
                this.fontProgram.getFontMetrics().setBbox(llx, lly, urx, ury);
            } else {
                int[] bbox = this.fontProgram.getFontMetrics().getBbox();
                int newLlx = Math.min(bbox[0], llx);
                int newLly = Math.min(bbox[1], lly);
                int newUrx = Math.max(bbox[2], urx);
                int newUry = Math.max(bbox[3], ury);
                this.fontProgram.getFontMetrics().setBbox(newLlx, newLly, newUrx, newUry);
            }
        }
        return glyph;
    }

    @Override
    public Glyph getGlyph(int unicode) {
        if (this.fontEncoding.canEncode(unicode) || unicode < 33) {
            Glyph glyph = ((Type3FontProgram)this.getFontProgram()).getGlyph(this.fontEncoding.getUnicodeDifference(unicode));
            if (glyph == null && (glyph = (Glyph)this.notdefGlyphs.get(unicode)) == null) {
                glyph = new Glyph(-1, 0, unicode);
                this.notdefGlyphs.put(unicode, glyph);
            }
            return glyph;
        }
        return null;
    }

    @Override
    public boolean containsGlyph(String text, int from) {
        return this.containsGlyph((int)text.charAt(from));
    }

    @Override
    public boolean containsGlyph(int unicode) {
        return (this.fontEncoding.canEncode(unicode) || unicode < 33) && ((Type3FontProgram)this.getFontProgram()).getGlyph(this.fontEncoding.getUnicodeDifference(unicode)) != null;
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        return null;
    }

    @Override
    protected void addFontStream(PdfDictionary fontDescriptor) {
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    @Override
    public void flush() {
        if (((Type3FontProgram)this.getFontProgram()).getGlyphsCount() < 1) {
            throw new PdfException("no.glyphs.defined.fo r.type3.font");
        }
        PdfDictionary charProcs = new PdfDictionary();
        for (int i = 0; i < 256; ++i) {
            if (!this.fontEncoding.canDecode(i)) continue;
            Type3Glyph glyph = this.getType3Glyph(this.fontEncoding.getUnicode(i));
            charProcs.put(new PdfName(this.fontEncoding.getDifference(i)), glyph.getContentStream());
            glyph.getContentStream().flush();
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.CharProcs, charProcs);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.FontMatrix, new PdfArray(this.getFontMatrix()));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.FontBBox, new PdfArray(this.fontProgram.getFontMetrics().getBbox()));
        super.flushFontData(null, PdfName.Type3);
        super.flush();
    }

    private int getFirstEmptyCode() {
        boolean startFrom = true;
        for (int i = 1; i < 256; ++i) {
            if (this.fontEncoding.canDecode(i)) continue;
            return i;
        }
        return -1;
    }
}

