/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;

public class PdfString
extends PdfPrimitiveObject {
    private static final long serialVersionUID = 390789504287887010L;
    protected String value;
    protected String encoding;
    protected boolean hexWriting = false;
    private int decryptInfoNum = 0;
    private int decryptInfoGen = 0;

    public PdfString(String value, String encoding) {
        this.value = value;
        this.encoding = encoding;
    }

    public PdfString(String value) {
        this(value, null);
    }

    public PdfString(byte[] content) {
        if (content != null && content.length > 0) {
            StringBuilder str = new StringBuilder(content.length);
            for (byte b : content) {
                str.append((char)(b & 0xFF));
            }
            this.value = str.toString();
        } else {
            this.value = "";
        }
    }

    protected PdfString(byte[] content, boolean hexWriting) {
        super(content);
        this.hexWriting = hexWriting;
    }

    private PdfString() {
    }

    @Override
    public byte getType() {
        return 10;
    }

    public boolean isHexWriting() {
        return this.hexWriting;
    }

    public PdfString setHexWriting(boolean hexWriting) {
        if (this.value == null) {
            this.generateValue();
            this.content = null;
        }
        this.hexWriting = hexWriting;
        return this;
    }

    public String getValue() {
        if (this.value == null) {
            this.generateValue();
        }
        return this.value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Deprecated
    public void setEncoding(String encoding) {
        if (this.value == null) {
            this.generateValue();
            this.content = null;
        }
        this.encoding = encoding;
    }

    public String toUnicodeString() {
        byte[] b;
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.getValue();
        }
        if (this.content == null) {
            this.generateContent();
        }
        if ((b = PdfTokenizer.decodeStringContent(this.content, this.hexWriting)).length >= 2 && b[0] == -2 && b[1] == -1) {
            return PdfEncodings.convertToString(b, "UnicodeBig");
        }
        return PdfEncodings.convertToString(b, "PDF");
    }

    public byte[] getValueBytes() {
        if (this.value == null) {
            this.generateValue();
        }
        if (this.encoding != null && this.encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(this.value)) {
            return PdfEncodings.convertToBytes(this.value, "PDF");
        }
        return PdfEncodings.convertToBytes(this.value, this.encoding);
    }

    @Override
    public PdfString makeIndirect(PdfDocument document) {
        return (PdfString)super.makeIndirect(document);
    }

    @Override
    public PdfString makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfString)super.makeIndirect(document, reference);
    }

    @Override
    public PdfString copyTo(PdfDocument document) {
        return (PdfString)super.copyTo(document, true);
    }

    @Override
    public PdfString copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfString)super.copyTo(document, allowDuplicating);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfString that = (PdfString)o;
        String v1 = this.getValue();
        String v2 = that.getValue();
        if (v1 != null && v1.equals(v2)) {
            String e1 = this.getEncoding();
            String e2 = that.getEncoding();
            if (e1 == null && e2 == null || e1 != null && e1.equals(e2)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return new String(PdfTokenizer.decodeStringContent(this.content, this.hexWriting));
        }
        return this.getValue();
    }

    public int hashCode() {
        String v = this.getValue();
        String e = this.getEncoding();
        int result = v != null ? v.hashCode() : 0;
        return 31 * result + (e != null ? e.hashCode() : 0);
    }

    protected void generateValue() {
        assert (this.content != null) : "No byte[] content to generate value";
        this.value = PdfEncodings.convertToString(PdfTokenizer.decodeStringContent(this.content, this.hexWriting), null);
    }

    @Override
    protected void generateContent() {
        this.content = this.encodeBytes(this.getValueBytes());
    }

    protected PdfString decrypt(PdfEncryption decrypt) {
        if (decrypt != null) {
            assert (this.content != null) : "No byte content to decrypt value";
            byte[] decodedContent = PdfTokenizer.decodeStringContent(this.content, this.hexWriting);
            this.content = null;
            decrypt.setHashKeyForNextObject(this.decryptInfoNum, this.decryptInfoGen);
            this.value = PdfEncodings.convertToString(decrypt.decryptByteArray(decodedContent), null);
        }
        return this;
    }

    protected boolean encrypt(PdfEncryption encrypt) {
        if (encrypt != null && !encrypt.isEmbeddedFilesOnly()) {
            byte[] b = encrypt.encryptByteArray(this.getValueBytes());
            this.content = this.encodeBytes(b);
            return true;
        }
        return false;
    }

    protected byte[] encodeBytes(byte[] bytes) {
        if (this.hexWriting) {
            ByteBuffer buf = new ByteBuffer(bytes.length * 2);
            for (byte b : bytes) {
                buf.appendHex(b);
            }
            return buf.getInternalBuffer();
        }
        ByteBuffer buf = StreamUtil.createBufferedEscapedString(bytes);
        return buf.toByteArray(1, buf.size() - 2);
    }

    @Override
    protected PdfString newInstance() {
        return new PdfString();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfString string = (PdfString)from;
        this.value = string.value;
        this.hexWriting = string.hexWriting;
    }

    void setDecryptInfoNum(int decryptInfoNum) {
        this.decryptInfoNum = decryptInfoNum;
    }

    void setDecryptInfoGen(int decryptInfoGen) {
        this.decryptInfoGen = decryptInfoGen;
    }
}

