/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.listener;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class TextMarginFinder
implements IEventListener {
    private Rectangle textRectangle = null;

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type != EventType.RENDER_TEXT) {
            throw new IllegalStateException(MessageFormat.format("Event type not supported: {0}", new Object[]{type}));
        }
        TextRenderInfo info = (TextRenderInfo)data;
        this.textRectangle = this.textRectangle == null ? info.getDescentLine().getBoundingRectangle() : Rectangle.getCommonRectangle(this.textRectangle, info.getDescentLine().getBoundingRectangle());
        this.textRectangle = Rectangle.getCommonRectangle(this.textRectangle, info.getAscentLine().getBoundingRectangle());
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return new LinkedHashSet<EventType>(Collections.singletonList(EventType.RENDER_TEXT));
    }

    public Rectangle getTextRectangle() {
        return this.textRectangle;
    }
}

