/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.util;

import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import com.itextpdf.kernel.pdf.filters.DoNothingFilter;
import com.itextpdf.kernel.pdf.filters.FilterHandlers;
import com.itextpdf.kernel.pdf.filters.IFilterHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class InlineImageParsingUtils {
    private static final Map<PdfName, PdfName> inlineImageEntryAbbreviationMap = new HashMap<PdfName, PdfName>();
    private static final Map<PdfName, PdfName> inlineImageColorSpaceAbbreviationMap;
    private static final Map<PdfName, PdfName> inlineImageFilterAbbreviationMap;

    private InlineImageParsingUtils() {
    }

    public static PdfStream parse(PdfCanvasParser ps, PdfDictionary colorSpaceDic) throws IOException {
        PdfDictionary inlineImageDict = InlineImageParsingUtils.parseDictionary(ps);
        byte[] samples = InlineImageParsingUtils.parseSamples(inlineImageDict, colorSpaceDic, ps);
        PdfStream inlineImageAsStreamObject = new PdfStream(samples);
        inlineImageAsStreamObject.putAll(inlineImageDict);
        return inlineImageAsStreamObject;
    }

    private static PdfDictionary parseDictionary(PdfCanvasParser ps) throws IOException {
        PdfDictionary dict = new PdfDictionary();
        PdfObject key = ps.readObject();
        while (key != null && !"ID".equals(key.toString())) {
            PdfObject value = ps.readObject();
            PdfName resolvedKey = inlineImageEntryAbbreviationMap.get((PdfName)key);
            if (resolvedKey == null) {
                resolvedKey = (PdfName)key;
            }
            dict.put(resolvedKey, InlineImageParsingUtils.getAlternateValue(resolvedKey, value));
            key = ps.readObject();
        }
        int ch = ps.getTokeniser().read();
        if (!PdfTokenizer.isWhitespace(ch)) {
            throw new InlineImageParseException("Unexpected character {0} found after ID in inline image.").setMessageParams(ch);
        }
        return dict;
    }

    private static PdfObject getAlternateValue(PdfName key, PdfObject value) {
        PdfName altValue;
        if (key == PdfName.Filter) {
            if (value instanceof PdfName) {
                PdfName altValue2 = inlineImageFilterAbbreviationMap.get((PdfName)value);
                if (altValue2 != null) {
                    return altValue2;
                }
            } else if (value instanceof PdfArray) {
                PdfArray array = (PdfArray)value;
                PdfArray altArray = new PdfArray();
                int count = array.size();
                for (int i = 0; i < count; ++i) {
                    altArray.add(InlineImageParsingUtils.getAlternateValue(key, array.get(i)));
                }
                return altArray;
            }
        } else if (key == PdfName.ColorSpace && value instanceof PdfName && (altValue = inlineImageColorSpaceAbbreviationMap.get((PdfName)value)) != null) {
            return altValue;
        }
        return value;
    }

    private static int getComponentsPerPixel(PdfName colorSpaceName, PdfDictionary colorSpaceDic) {
        if (colorSpaceName == null) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DeviceGray)) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DeviceRGB)) {
            return 3;
        }
        if (colorSpaceName.equals(PdfName.DeviceCMYK)) {
            return 4;
        }
        if (colorSpaceDic != null) {
            PdfArray colorSpace = colorSpaceDic.getAsArray(colorSpaceName);
            if (colorSpace != null) {
                if (PdfName.Indexed.equals(colorSpace.getAsName(0))) {
                    return 1;
                }
            } else {
                PdfName tempName = colorSpaceDic.getAsName(colorSpaceName);
                if (tempName != null) {
                    return InlineImageParsingUtils.getComponentsPerPixel(tempName, colorSpaceDic);
                }
            }
        }
        throw new InlineImageParseException("Unexpected ColorSpace: {0}.").setMessageParams(colorSpaceName);
    }

    private static int computeBytesPerRow(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic) {
        PdfNumber wObj = imageDictionary.getAsNumber(PdfName.Width);
        PdfNumber bpcObj = imageDictionary.getAsNumber(PdfName.BitsPerComponent);
        int cpp = InlineImageParsingUtils.getComponentsPerPixel(imageDictionary.getAsName(PdfName.ColorSpace), colorSpaceDic);
        int w = wObj.intValue();
        int bpc = bpcObj != null ? bpcObj.intValue() : 1;
        return (w * bpc * cpp + 7) / 8;
    }

    private static byte[] parseUnfilteredSamples(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic, PdfCanvasParser ps) throws IOException {
        PdfObject ei2;
        if (imageDictionary.containsKey(PdfName.Filter)) {
            throw new IllegalArgumentException("Dictionary contains filters");
        }
        PdfNumber h = imageDictionary.getAsNumber(PdfName.Height);
        int bytesToRead = InlineImageParsingUtils.computeBytesPerRow(imageDictionary, colorSpaceDic) * h.intValue();
        byte[] bytes = new byte[bytesToRead];
        PdfTokenizer tokeniser = ps.getTokeniser();
        int shouldBeWhiteSpace = tokeniser.read();
        int startIndex = 0;
        if (!PdfTokenizer.isWhitespace(shouldBeWhiteSpace) || shouldBeWhiteSpace == 0) {
            bytes[0] = (byte)shouldBeWhiteSpace;
            ++startIndex;
        }
        for (int i = startIndex; i < bytesToRead; ++i) {
            int ch = tokeniser.read();
            if (ch == -1) {
                throw new InlineImageParseException("End of content stream reached before end of image data.");
            }
            bytes[i] = (byte)ch;
        }
        PdfObject ei = ps.readObject();
        if (!ei.toString().equals("EI") && !(ei2 = ps.readObject()).toString().equals("EI")) {
            throw new InlineImageParseException("Operator EI not found after the end of image data.");
        }
        return bytes;
    }

    private static byte[] parseSamples(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic, PdfCanvasParser ps) throws IOException {
        int ch;
        if (!imageDictionary.containsKey(PdfName.Filter) && InlineImageParsingUtils.imageColorSpaceIsKnown(imageDictionary, colorSpaceDic)) {
            return InlineImageParsingUtils.parseUnfilteredSamples(imageDictionary, colorSpaceDic, ps);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream accumulated = new ByteArrayOutputStream();
        int found = 0;
        PdfTokenizer tokeniser = ps.getTokeniser();
        while ((ch = tokeniser.read()) != -1) {
            if (found == 0 && PdfTokenizer.isWhitespace(ch)) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 1 && ch == 69) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 1 && PdfTokenizer.isWhitespace(ch)) {
                baos.write(accumulated.toByteArray());
                accumulated.reset();
                accumulated.write(ch);
                continue;
            }
            if (found == 2 && ch == 73) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 3 && PdfTokenizer.isWhitespace(ch)) {
                byte[] tmp = baos.toByteArray();
                if (InlineImageParsingUtils.inlineImageStreamBytesAreComplete(tmp, imageDictionary)) {
                    return tmp;
                }
                baos.write(accumulated.toByteArray());
                accumulated.reset();
                baos.write(ch);
                found = 0;
                continue;
            }
            baos.write(accumulated.toByteArray());
            accumulated.reset();
            baos.write(ch);
            found = 0;
        }
        throw new InlineImageParseException("Cannot find image data or EI.");
    }

    private static boolean imageColorSpaceIsKnown(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic) {
        PdfName cs = imageDictionary.getAsName(PdfName.ColorSpace);
        if (cs == null || cs.equals(PdfName.DeviceGray) || cs.equals(PdfName.DeviceRGB) || cs.equals(PdfName.DeviceCMYK)) {
            return true;
        }
        return colorSpaceDic != null && colorSpaceDic.containsKey(cs);
    }

    private static boolean inlineImageStreamBytesAreComplete(byte[] samples, PdfDictionary imageDictionary) {
        try {
            HashMap<PdfName, IFilterHandler> filters = new HashMap<PdfName, IFilterHandler>(FilterHandlers.getDefaultFilterHandlers());
            DoNothingFilter stubfilter = new DoNothingFilter();
            filters.put(PdfName.DCTDecode, stubfilter);
            filters.put(PdfName.JBIG2Decode, stubfilter);
            filters.put(PdfName.JPXDecode, stubfilter);
            PdfReader.decodeBytes(samples, imageDictionary, filters);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    static {
        inlineImageEntryAbbreviationMap.put(PdfName.BitsPerComponent, PdfName.BitsPerComponent);
        inlineImageEntryAbbreviationMap.put(PdfName.ColorSpace, PdfName.ColorSpace);
        inlineImageEntryAbbreviationMap.put(PdfName.Decode, PdfName.Decode);
        inlineImageEntryAbbreviationMap.put(PdfName.DecodeParms, PdfName.DecodeParms);
        inlineImageEntryAbbreviationMap.put(PdfName.Filter, PdfName.Filter);
        inlineImageEntryAbbreviationMap.put(PdfName.Height, PdfName.Height);
        inlineImageEntryAbbreviationMap.put(PdfName.ImageMask, PdfName.ImageMask);
        inlineImageEntryAbbreviationMap.put(PdfName.Intent, PdfName.Intent);
        inlineImageEntryAbbreviationMap.put(PdfName.Interpolate, PdfName.Interpolate);
        inlineImageEntryAbbreviationMap.put(PdfName.Width, PdfName.Width);
        inlineImageEntryAbbreviationMap.put(new PdfName("BPC"), PdfName.BitsPerComponent);
        inlineImageEntryAbbreviationMap.put(new PdfName("CS"), PdfName.ColorSpace);
        inlineImageEntryAbbreviationMap.put(new PdfName("D"), PdfName.Decode);
        inlineImageEntryAbbreviationMap.put(new PdfName("DP"), PdfName.DecodeParms);
        inlineImageEntryAbbreviationMap.put(new PdfName("F"), PdfName.Filter);
        inlineImageEntryAbbreviationMap.put(new PdfName("H"), PdfName.Height);
        inlineImageEntryAbbreviationMap.put(new PdfName("IM"), PdfName.ImageMask);
        inlineImageEntryAbbreviationMap.put(new PdfName("I"), PdfName.Interpolate);
        inlineImageEntryAbbreviationMap.put(new PdfName("W"), PdfName.Width);
        inlineImageColorSpaceAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("G"), PdfName.DeviceGray);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("RGB"), PdfName.DeviceRGB);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("CMYK"), PdfName.DeviceCMYK);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("I"), PdfName.Indexed);
        inlineImageFilterAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageFilterAbbreviationMap.put(new PdfName("AHx"), PdfName.ASCIIHexDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("A85"), PdfName.ASCII85Decode);
        inlineImageFilterAbbreviationMap.put(new PdfName("LZW"), PdfName.LZWDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("Fl"), PdfName.FlateDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("RL"), PdfName.RunLengthDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("CCF"), PdfName.CCITTFaxDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("DCT"), PdfName.DCTDecode);
    }

    public static class InlineImageParseException
    extends PdfException
    implements Serializable {
        private static final long serialVersionUID = 233760879000268548L;

        public InlineImageParseException(String message) {
            super(message);
        }
    }
}

