/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class StructureTreeCopier {
    private static List<PdfName> ignoreKeysForCopy = new ArrayList<PdfName>();
    private static List<PdfName> ignoreKeysForClone = new ArrayList<PdfName>();

    StructureTreeCopier() {
    }

    public static void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument) {
        if (!destDocument.isTagged()) {
            return;
        }
        StructureTreeCopier.copyTo(destDocument, page2page, callingDocument, false);
    }

    public static void copyTo(PdfDocument destDocument, int insertBeforePage, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument) {
        int i;
        if (!destDocument.isTagged()) {
            return;
        }
        HashSet<PdfObject> firstPartElems = new HashSet<PdfObject>();
        PdfStructTreeRoot destStructTreeRoot = destDocument.getStructTreeRoot();
        for (int i2 = 1; i2 < insertBeforePage; ++i2) {
            PdfPage pageOfFirstHalf = destDocument.getPage(i2);
            Collection<PdfMcr> pageMcrs = destStructTreeRoot.getPageMarkedContentReferences(pageOfFirstHalf);
            if (pageMcrs == null) continue;
            for (PdfMcr mcr : pageMcrs) {
                firstPartElems.add((PdfObject)mcr.getPdfObject());
                PdfDictionary top = StructureTreeCopier.addAllParentsToSet(mcr, firstPartElems);
                if (!top.isFlushed()) continue;
                throw new PdfException("Tag from the existing tag structure is flushed. Cannot add copied page tags.");
            }
        }
        ArrayList<PdfDictionary> clonedTops = new ArrayList<PdfDictionary>();
        PdfArray tops = destStructTreeRoot.getKidsObject();
        int lastTopBefore = 0;
        for (i = 0; i < tops.size(); ++i) {
            PdfDictionary top = tops.getAsDictionary(i);
            if (!firstPartElems.contains(top)) continue;
            lastTopBefore = i;
            LastClonedAncestor lastCloned = new LastClonedAncestor();
            lastCloned.ancestor = top;
            PdfDictionary topClone = top.clone(ignoreKeysForClone);
            topClone.put(PdfName.P, (PdfObject)destStructTreeRoot.getPdfObject());
            lastCloned.clone = topClone;
            StructureTreeCopier.separateKids(top, firstPartElems, lastCloned);
            if (!topClone.containsKey(PdfName.K)) continue;
            topClone.makeIndirect(destDocument);
            clonedTops.add(topClone);
        }
        for (i = 0; i < clonedTops.size(); ++i) {
            destStructTreeRoot.addKidObject(lastTopBefore + 1 + i, (PdfDictionary)clonedTops.get(i));
        }
        StructureTreeCopier.copyTo(destDocument, page2page, callingDocument, false, lastTopBefore + 1);
    }

    private static void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument, boolean copyFromDestDocument) {
        StructureTreeCopier.copyTo(destDocument, page2page, callingDocument, copyFromDestDocument, -1);
    }

    private static void copyTo(PdfDocument destDocument, Map<PdfPage, PdfPage> page2page, PdfDocument callingDocument, boolean copyFromDestDocument, int insertIndex) {
        PdfDocument fromDocument = copyFromDestDocument ? destDocument : callingDocument;
        HashSet<PdfDictionary> tops = new HashSet<PdfDictionary>();
        HashSet<PdfObject> objectsToCopy = new HashSet<PdfObject>();
        HashMap<PdfDictionary, PdfDictionary> page2pageDictionaries = new HashMap<PdfDictionary, PdfDictionary>();
        for (Map.Entry<PdfPage, PdfPage> page : page2page.entrySet()) {
            page2pageDictionaries.put((PdfDictionary)page.getKey().getPdfObject(), (PdfDictionary)page.getValue().getPdfObject());
            Collection<PdfMcr> mcrs = fromDocument.getStructTreeRoot().getPageMarkedContentReferences(page.getKey());
            if (mcrs == null) continue;
            for (PdfMcr mcr : mcrs) {
                PdfDictionary top;
                if (mcr instanceof PdfMcrDictionary || mcr instanceof PdfObjRef) {
                    objectsToCopy.add((PdfObject)mcr.getPdfObject());
                }
                if ((top = StructureTreeCopier.addAllParentsToSet(mcr, objectsToCopy)).isFlushed()) {
                    throw new PdfException("Cannot copy flushed tag.");
                }
                tops.add(top);
            }
        }
        ArrayList<PdfDictionary> topsInOriginalOrder = new ArrayList<PdfDictionary>();
        for (IPdfStructElem kid : fromDocument.getStructTreeRoot().getKids()) {
            PdfDictionary kidObject;
            if (kid == null || !tops.contains(kidObject = (PdfDictionary)((PdfStructElem)kid).getPdfObject())) continue;
            topsInOriginalOrder.add(kidObject);
        }
        for (PdfDictionary top : topsInOriginalOrder) {
            PdfDictionary copied = StructureTreeCopier.copyObject(top, objectsToCopy, destDocument, page2pageDictionaries, copyFromDestDocument);
            destDocument.getStructTreeRoot().addKidObject(insertIndex, copied);
            if (insertIndex <= -1) continue;
            ++insertIndex;
        }
    }

    private static PdfDictionary copyObject(PdfDictionary source, Set<PdfObject> objectsToCopy, PdfDocument toDocument, Map<PdfDictionary, PdfDictionary> page2page, boolean copyFromDestDocument) {
        PdfObject k;
        PdfDictionary pg;
        PdfDictionary copied;
        if (copyFromDestDocument) {
            copied = source.clone(ignoreKeysForCopy);
            if (source.isIndirect()) {
                copied.makeIndirect(toDocument);
            }
        } else {
            copied = source.copyTo(toDocument, ignoreKeysForCopy, true);
        }
        if (source.containsKey(PdfName.Obj)) {
            PdfDictionary obj = source.getAsDictionary(PdfName.Obj);
            if (!copyFromDestDocument && obj != null) {
                obj = obj.copyTo(toDocument, Arrays.asList(PdfName.P), false);
                copied.put(PdfName.Obj, obj);
            }
        }
        if ((pg = source.getAsDictionary(PdfName.Pg)) != null) {
            copied.put(PdfName.Pg, page2page.get(pg));
        }
        if ((k = source.get(PdfName.K)) != null) {
            if (k.isArray()) {
                PdfArray kArr = (PdfArray)k;
                PdfArray newArr = new PdfArray();
                for (int i = 0; i < kArr.size(); ++i) {
                    PdfObject copiedKid = StructureTreeCopier.copyObjectKid(kArr.get(i), copied, objectsToCopy, toDocument, page2page, copyFromDestDocument);
                    if (copiedKid == null) continue;
                    newArr.add(copiedKid);
                }
                copied.put(PdfName.K, newArr);
            } else {
                PdfObject copiedKid = StructureTreeCopier.copyObjectKid(k, copied, objectsToCopy, toDocument, page2page, copyFromDestDocument);
                if (copiedKid != null) {
                    copied.put(PdfName.K, copiedKid);
                }
            }
        }
        return copied;
    }

    private static PdfObject copyObjectKid(PdfObject kid, PdfDictionary copiedParent, Set<PdfObject> objectsToCopy, PdfDocument toDocument, Map<PdfDictionary, PdfDictionary> page2page, boolean copyFromDestDocument) {
        PdfDictionary kidAsDict;
        if (kid.isNumber()) {
            toDocument.getStructTreeRoot().getParentTreeHandler().registerMcr(new PdfMcrNumber((PdfNumber)kid, new PdfStructElem(copiedParent)));
            return kid;
        }
        if (kid.isDictionary() && objectsToCopy.contains(kidAsDict = (PdfDictionary)kid)) {
            boolean hasParent = kidAsDict.containsKey(PdfName.P);
            PdfDictionary copiedKid = StructureTreeCopier.copyObject(kidAsDict, objectsToCopy, toDocument, page2page, copyFromDestDocument);
            if (hasParent) {
                copiedKid.put(PdfName.P, copiedParent);
            } else {
                PdfMcr mcr;
                if (copiedKid.containsKey(PdfName.Obj)) {
                    mcr = new PdfObjRef(copiedKid, new PdfStructElem(copiedParent));
                    PdfDictionary contentItemObject = copiedKid.getAsDictionary(PdfName.Obj);
                    if (PdfName.Link.equals(contentItemObject.getAsName(PdfName.Subtype)) && !contentItemObject.containsKey(PdfName.P)) {
                        return null;
                    }
                    contentItemObject.put(PdfName.StructParent, new PdfNumber(toDocument.getNextStructParentIndex()));
                } else {
                    mcr = new PdfMcrDictionary(copiedKid, new PdfStructElem(copiedParent));
                }
                toDocument.getStructTreeRoot().getParentTreeHandler().registerMcr(mcr);
            }
            return copiedKid;
        }
        return null;
    }

    private static void separateKids(PdfDictionary structElem, Set<PdfObject> firstPartElems, LastClonedAncestor lastCloned) {
        PdfObject k = structElem.get(PdfName.K);
        if (!k.isArray()) {
            if (k.isDictionary() && PdfStructElem.isStructElem((PdfDictionary)k)) {
                StructureTreeCopier.separateKids((PdfDictionary)k, firstPartElems, lastCloned);
            }
        } else {
            PdfDocument document = structElem.getIndirectReference().getDocument();
            PdfArray kids = (PdfArray)k;
            for (int i = 0; i < kids.size(); ++i) {
                PdfObject kid = kids.get(i);
                PdfDictionary dictKid = null;
                if (kid.isDictionary()) {
                    dictKid = (PdfDictionary)kid;
                }
                if (dictKid != null && PdfStructElem.isStructElem(dictKid)) {
                    if (firstPartElems.contains(kid)) {
                        StructureTreeCopier.separateKids((PdfDictionary)kid, firstPartElems, lastCloned);
                        continue;
                    }
                    if (dictKid.isFlushed()) {
                        throw new PdfException("Tag from the existing tag structure is flushed. Cannot add copied page tags.");
                    }
                    if (!dictKid.containsKey(PdfName.K)) continue;
                    StructureTreeCopier.cloneParents(structElem, lastCloned, document);
                    kids.remove(i--);
                    PdfStructElem.addKidObject(lastCloned.clone, -1, kid);
                    continue;
                }
                if (firstPartElems.contains(kid)) continue;
                StructureTreeCopier.cloneParents(structElem, lastCloned, document);
                PdfMcr mcr = dictKid != null ? (dictKid.get(PdfName.Type).equals(PdfName.MCR) ? new PdfMcrDictionary(dictKid, new PdfStructElem(lastCloned.clone)) : new PdfObjRef(dictKid, new PdfStructElem(lastCloned.clone))) : new PdfMcrNumber((PdfNumber)kid, new PdfStructElem(lastCloned.clone));
                kids.remove(i--);
                PdfStructElem.addKidObject(lastCloned.clone, -1, kid);
                document.getStructTreeRoot().getParentTreeHandler().registerMcr(mcr);
            }
        }
        if (lastCloned.ancestor == structElem) {
            lastCloned.ancestor = lastCloned.ancestor.getAsDictionary(PdfName.P);
            lastCloned.clone = lastCloned.clone.getAsDictionary(PdfName.P);
        }
    }

    private static void cloneParents(PdfDictionary structElem, LastClonedAncestor lastCloned, PdfDocument document) {
        if (lastCloned.ancestor != structElem) {
            PdfDictionary structElemClone;
            PdfDictionary currClone = structElemClone = structElem.clone(ignoreKeysForClone).makeIndirect(document);
            PdfDictionary currElem = structElem;
            while (currElem.get(PdfName.P) != lastCloned.ancestor) {
                PdfDictionary parent = currElem.getAsDictionary(PdfName.P);
                PdfDictionary parentClone = parent.clone(ignoreKeysForClone).makeIndirect(document);
                currClone.put(PdfName.P, parentClone);
                parentClone.put(PdfName.K, currClone);
                currClone = parentClone;
                currElem = parent;
            }
            PdfStructElem.addKidObject(lastCloned.clone, -1, currClone);
            lastCloned.clone = structElemClone;
            lastCloned.ancestor = structElem;
        }
    }

    private static PdfDictionary addAllParentsToSet(PdfMcr mcr, Set<PdfObject> set) {
        PdfDictionary p;
        PdfDictionary elem = (PdfDictionary)((PdfStructElem)mcr.getParent()).getPdfObject();
        set.add(elem);
        while (!elem.isFlushed() && (p = elem.getAsDictionary(PdfName.P)) != null && !PdfName.StructTreeRoot.equals(p.getAsName(PdfName.Type))) {
            elem = p;
            set.add(elem);
        }
        return elem;
    }

    static {
        ignoreKeysForCopy.add(PdfName.K);
        ignoreKeysForCopy.add(PdfName.P);
        ignoreKeysForCopy.add(PdfName.Pg);
        ignoreKeysForCopy.add(PdfName.Obj);
        ignoreKeysForClone.add(PdfName.K);
        ignoreKeysForClone.add(PdfName.P);
    }

    static class LastClonedAncestor {
        PdfDictionary ancestor;
        PdfDictionary clone;

        LastClonedAncestor() {
        }
    }
}

