/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.element.AbstractElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Image
extends AbstractElement<Image>
implements ILeafElement,
IAccessibleElement {
    protected PdfXObject xObject;
    protected PdfName role = PdfName.Figure;
    protected AccessibilityProperties tagProperties;

    public Image(PdfImageXObject xObject) {
        this.xObject = xObject;
    }

    public Image(PdfFormXObject xObject) {
        this.xObject = xObject;
    }

    public Image(PdfImageXObject xObject, float width) {
        this.xObject = xObject;
        this.setWidth(width);
    }

    public Image(PdfImageXObject xObject, float x, float y, float width) {
        this.xObject = xObject;
        this.setProperty(79, Float.valueOf(x));
        this.setProperty(80, Float.valueOf(y));
        this.setWidth(width);
        this.setProperty(52, 4);
    }

    public Image(PdfImageXObject xObject, float x, float y) {
        this.xObject = xObject;
        this.setProperty(79, Float.valueOf(x));
        this.setProperty(80, Float.valueOf(y));
        this.setProperty(52, 4);
    }

    public Image(PdfFormXObject xObject, float x, float y) {
        this.xObject = xObject;
        this.setProperty(79, Float.valueOf(x));
        this.setProperty(80, Float.valueOf(y));
        this.setProperty(52, 4);
    }

    public Image(ImageData img) {
        this(new PdfImageXObject(Image.checkImageType(img)));
        this.setProperty(19, true);
    }

    public Image(ImageData img, float x, float y) {
        this(new PdfImageXObject(Image.checkImageType(img)), x, y);
        this.setProperty(19, true);
    }

    public Image(ImageData img, float x, float y, float width) {
        this(new PdfImageXObject(Image.checkImageType(img)), x, y, width);
        this.setProperty(19, true);
    }

    public PdfXObject getXObject() {
        return this.xObject;
    }

    public Image setRotationAngle(double radAngle) {
        this.setProperty(55, radAngle);
        return this;
    }

    public Float getMarginLeft() {
        return (Float)this.getProperty(44);
    }

    public Image setMarginLeft(float value) {
        this.setProperty(44, Float.valueOf(value));
        return this;
    }

    public Float getMarginRight() {
        return (Float)this.getProperty(45);
    }

    public Image setMarginRight(float value) {
        this.setProperty(45, Float.valueOf(value));
        return this;
    }

    public Float getMarginTop() {
        return (Float)this.getProperty(46);
    }

    public Image setMarginTop(float value) {
        this.setProperty(46, Float.valueOf(value));
        return this;
    }

    public Float getMarginBottom() {
        return (Float)this.getProperty(43);
    }

    public Image setMarginBottom(float value) {
        this.setProperty(43, Float.valueOf(value));
        return this;
    }

    public Image setMargins(float marginTop, float marginRight, float marginBottom, float marginLeft) {
        return this.setMarginTop(marginTop).setMarginRight(marginRight).setMarginBottom(marginBottom).setMarginLeft(marginLeft);
    }

    public Image scale(float horizontalScaling, float verticalScaling) {
        this.setProperty(29, Float.valueOf(horizontalScaling));
        this.setProperty(76, Float.valueOf(verticalScaling));
        return this;
    }

    public Image scaleToFit(float fitWidth, float fitHeight) {
        float horizontalScaling = fitWidth / this.xObject.getWidth();
        float verticalScaling = fitHeight / this.xObject.getHeight();
        return this.scale(Math.min(horizontalScaling, verticalScaling), Math.min(horizontalScaling, verticalScaling));
    }

    public Image scaleAbsolute(float fitWidth, float fitHeight) {
        float horizontalScaling = fitWidth / this.xObject.getWidth();
        float verticalScaling = fitHeight / this.xObject.getHeight();
        return this.scale(horizontalScaling, verticalScaling);
    }

    public Image setAutoScale(boolean autoScale) {
        if (this.hasProperty(5) && this.hasProperty(4) && autoScale && (((Boolean)this.getProperty(5)).booleanValue() || ((Boolean)this.getProperty(4)).booleanValue())) {
            Logger logger = LoggerFactory.getLogger(Image.class);
            logger.warn("The image cannot be auto scaled and scaled by a certain parameter simultaneously");
        }
        this.setProperty(3, autoScale);
        return this;
    }

    public Image setAutoScaleHeight(boolean autoScale) {
        if (this.hasProperty(5) && autoScale && ((Boolean)this.getProperty(5)).booleanValue()) {
            this.setProperty(5, false);
            this.setProperty(4, false);
            this.setProperty(3, true);
        } else {
            this.setProperty(5, autoScale);
        }
        return this;
    }

    public Image setAutoScaleWidth(boolean autoScale) {
        if (this.hasProperty(4) && autoScale && ((Boolean)this.getProperty(4)).booleanValue()) {
            this.setProperty(5, false);
            this.setProperty(4, false);
            this.setProperty(3, true);
        } else {
            this.setProperty(5, autoScale);
        }
        return this;
    }

    public Image setFixedPosition(float x, float y) {
        this.setFixedPosition(x, y, this.getWidth());
        return this;
    }

    public Image setFixedPosition(int pageNumber, float x, float y) {
        this.setFixedPosition(pageNumber, x, y, this.getWidth());
        return this;
    }

    public float getImageWidth() {
        return this.xObject.getWidth();
    }

    public float getImageHeight() {
        return this.xObject.getHeight();
    }

    public Image setMaxHeight(float maxHeight) {
        this.setProperty(27, Float.valueOf(maxHeight));
        return this;
    }

    public Image setMinHeight(float minHeight) {
        this.setProperty(27, Float.valueOf(minHeight));
        return this;
    }

    public float getImageScaledWidth() {
        return null == this.getProperty(29) ? this.xObject.getWidth() : this.xObject.getWidth() * ((Float)this.getProperty(29)).floatValue();
    }

    public float getImageScaledHeight() {
        return null == this.getProperty(76) ? this.xObject.getHeight() : this.xObject.getHeight() * ((Float)this.getProperty(76)).floatValue();
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new ImageRenderer(this);
    }

    private static ImageData checkImageType(ImageData image) {
        if (image instanceof WmfImageData) {
            throw new PdfException("Cannot create layout image by WmfImage instance. First convert the image into FormXObject and then use the corresponding layout image constructor.");
        }
        return image;
    }
}

