/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.Type1Font;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.font.ComplexFontSelectorStrategy;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSelectorKey;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FontProvider {
    private FontSet fontSet;
    private Map<FontInfo, PdfFont> pdfFonts = new HashMap<FontInfo, PdfFont>();

    public FontProvider(FontSet fontSet) {
        this.fontSet = fontSet;
    }

    public FontProvider() {
        this.fontSet = new FontSet();
    }

    public boolean addFont(FontProgram fontProgram, String encoding) {
        return this.fontSet.addFont(fontProgram, encoding);
    }

    public boolean addFont(String fontProgram, String encoding) {
        return this.fontSet.addFont(fontProgram, encoding);
    }

    public boolean addFont(byte[] fontProgram, String encoding) {
        return this.fontSet.addFont(fontProgram, encoding);
    }

    public boolean addFont(String fontProgram) {
        return this.addFont(fontProgram, null);
    }

    public boolean addFont(FontProgram fontProgram) {
        return this.addFont(fontProgram, this.getDefaultEncoding(fontProgram));
    }

    public boolean addFont(byte[] fontProgram) {
        return this.addFont(fontProgram, null);
    }

    public int addDirectory(String dir) {
        return this.fontSet.addDirectory(dir);
    }

    public int addSystemFonts() {
        String[] withoutSubDirs;
        String[] withSubDirs;
        int count = 0;
        for (String directory : withSubDirs = new String[]{FileUtil.getFontsDir(), "/usr/share/X11/fonts", "/usr/X/lib/X11/fonts", "/usr/openwin/lib/X11/fonts", "/usr/share/fonts", "/usr/X11R6/lib/X11/fonts"}) {
            count += this.fontSet.addDirectory(directory, true);
        }
        for (String directory : withoutSubDirs = new String[]{"/Library/Fonts", "/System/Library/Fonts"}) {
            count += this.fontSet.addDirectory(directory, false);
        }
        return count;
    }

    public int addStandardPdfFonts() {
        this.addFont("Courier");
        this.addFont("Courier-Bold");
        this.addFont("Courier-BoldOblique");
        this.addFont("Courier-Oblique");
        this.addFont("Helvetica");
        this.addFont("Helvetica-Bold");
        this.addFont("Helvetica-BoldOblique");
        this.addFont("Helvetica-Oblique");
        this.addFont("Symbol");
        this.addFont("Times-Roman");
        this.addFont("Times-Bold");
        this.addFont("Times-BoldItalic");
        this.addFont("Times-Italic");
        this.addFont("ZapfDingbats");
        return 14;
    }

    public FontSet getFontSet() {
        return this.fontSet;
    }

    public String getDefaultEncoding(FontProgram fontProgram) {
        if (fontProgram instanceof Type1Font) {
            return "Cp1252";
        }
        return "Identity-H";
    }

    public boolean getDefaultCacheFlag() {
        return true;
    }

    public boolean getDefaultEmbeddingFlag() {
        return true;
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies, FontCharacteristics fc) {
        return new ComplexFontSelectorStrategy(text, this.getFontSelector(fontFamilies, fc), this);
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies) {
        return this.getStrategy(text, fontFamilies, null);
    }

    public final FontSelector getFontSelector(List<String> fontFamilies, FontCharacteristics fc) {
        FontSelectorKey key = new FontSelectorKey(fontFamilies, fc);
        if (this.fontSet.getFontSelectorCache().containsKey(key)) {
            return this.fontSet.getFontSelectorCache().get(key);
        }
        FontSelector fontSelector = this.createFontSelector(this.fontSet.getFonts(), fontFamilies, fc);
        this.fontSet.getFontSelectorCache().put(key, fontSelector);
        return fontSelector;
    }

    protected FontSelector createFontSelector(Set<FontInfo> fonts, List<String> fontFamilies, FontCharacteristics fc) {
        return new FontSelector(fonts, fontFamilies, fc);
    }

    protected PdfFont getPdfFont(FontInfo fontInfo) throws IOException {
        if (this.pdfFonts.containsKey(fontInfo)) {
            return this.pdfFonts.get(fontInfo);
        }
        FontProgram fontProgram = this.fontSet.getFontPrograms().containsKey(fontInfo) ? this.fontSet.getFontPrograms().get(fontInfo) : (fontInfo.getFontProgram() != null ? FontProgramFactory.createFont(fontInfo.getFontProgram(), this.getDefaultCacheFlag()) : FontProgramFactory.createFont(fontInfo.getFontName(), this.getDefaultCacheFlag()));
        String encoding = fontInfo.getEncoding();
        if (encoding == null || encoding.length() == 0) {
            encoding = this.getDefaultEncoding(fontProgram);
        }
        PdfFont pdfFont = PdfFontFactory.createFont(fontProgram, encoding, this.getDefaultEmbeddingFlag());
        this.pdfFonts.put(fontInfo, pdfFont);
        return pdfFont;
    }
}

