/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSelectorKey;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FontSet {
    private Set<FontInfo> fonts = new LinkedHashSet<FontInfo>();
    private Map<FontInfo, FontProgram> fontPrograms = new HashMap<FontInfo, FontProgram>();
    private Map<FontSelectorKey, FontSelector> fontSelectorCache = new HashMap<FontSelectorKey, FontSelector>();

    public int addDirectory(String dir, boolean scanSubdirectories) {
        int count = 0;
        String[] files = FileUtil.listFilesInDirectory(dir, scanSubdirectories);
        if (files == null) {
            return 0;
        }
        for (String file : files) {
            try {
                String suffix;
                String string = suffix = file.length() < 4 ? null : file.substring(file.length() - 4).toLowerCase();
                if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                    String pfb = file.substring(0, file.length() - 4) + ".pfb";
                    if (!FileUtil.fileExists(pfb)) continue;
                    this.addFont(file, null);
                    ++count;
                    continue;
                }
                if (!".ttf".equals(suffix) && !".otf".equals(suffix) && !".ttc".equals(suffix)) continue;
                this.addFont(file, null);
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    public int addDirectory(String dir) {
        return this.addDirectory(dir, false);
    }

    public boolean addFont(FontProgram fontProgram, String encoding) {
        if (fontProgram == null) {
            return false;
        }
        FontInfo fontInfo = FontInfo.create(fontProgram, encoding);
        this.addFontInfo(fontInfo);
        this.fontPrograms.put(fontInfo, fontProgram);
        return true;
    }

    public boolean addFont(String fontProgram, String encoding) {
        return this.addFont(fontProgram, null, encoding);
    }

    public boolean addFont(byte[] fontProgram, String encoding) {
        return this.addFont(null, fontProgram, encoding);
    }

    public boolean addFont(String fontProgram) {
        return this.addFont(fontProgram, null);
    }

    public boolean addFont(byte[] fontProgram) {
        return this.addFont(fontProgram, null);
    }

    public Set<FontInfo> getFonts() {
        return this.fonts;
    }

    boolean addFont(String fontName, byte[] fontProgram, String encoding) {
        if (fontName != null) {
            return this.addFontInfo(FontInfo.create(fontName, encoding));
        }
        if (fontProgram != null) {
            return this.addFontInfo(FontInfo.create(fontProgram, encoding));
        }
        return false;
    }

    Map<FontInfo, FontProgram> getFontPrograms() {
        return this.fontPrograms;
    }

    Map<FontSelectorKey, FontSelector> getFontSelectorCache() {
        return this.fontSelectorCache;
    }

    private boolean addFontInfo(FontInfo fontInfo) {
        if (fontInfo != null) {
            this.fonts.add(fontInfo);
            this.fontSelectorCache.clear();
            return true;
        }
        return false;
    }
}

