/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TableWidths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRenderer
extends AbstractRenderer {
    protected List<CellRenderer[]> rows = new ArrayList<CellRenderer[]>();
    protected Table.RowRange rowRange;
    protected TableRenderer headerRenderer;
    protected TableRenderer footerRenderer;
    protected boolean isOriginalNonSplitRenderer = true;
    private List<List<Border>> horizontalBorders;
    private List<List<Border>> verticalBorders;
    private float[] columnWidths = null;
    private List<Float> heights = new ArrayList<Float>();
    private float[] countedMinColumnWidth;
    private float[] countedMaxColumnWidth;
    private float[] countedColumnWidth = null;
    private float totalWidthForColumns;
    private float leftBorderMaxWidth;
    private float rightBorderMaxWidth;

    private TableRenderer() {
    }

    public TableRenderer(Table modelElement, Table.RowRange rowRange) {
        super(modelElement);
        this.setRowRange(rowRange);
    }

    public TableRenderer(Table modelElement) {
        this(modelElement, new Table.RowRange(0, modelElement.getNumberOfRows() - 1));
    }

    @Override
    public void addChild(IRenderer renderer) {
        if (renderer instanceof CellRenderer) {
            Cell cell = (Cell)renderer.getModelElement();
            this.rows.get((int)(cell.getRow() - this.rowRange.getStartRow() + cell.getRowspan() - 1))[cell.getCol()] = (CellRenderer)renderer;
        } else {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error("Only CellRenderer could be added");
        }
    }

    @Override
    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        return rect;
    }

    private Table getTable() {
        return (Table)this.getModelElement();
    }

    private void initializeHeaderAndFooter(boolean isFirstOnThePage) {
        boolean headerShouldBeApplied;
        boolean footerShouldBeApplied;
        Table table = (Table)this.getModelElement();
        Border[] tableBorder = this.getBorders();
        Table footerElement = table.getFooter();
        boolean bl = footerShouldBeApplied = (!table.isComplete() || 0 == table.getLastRowBottomBorder().size() || !table.isSkipLastFooter()) && !Boolean.TRUE.equals(this.getOwnProperty(96));
        if (footerElement != null && footerShouldBeApplied) {
            this.footerRenderer = this.initFooterOrHeaderRenderer(true, tableBorder);
        }
        Table headerElement = table.getHeader();
        boolean isFirstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer;
        boolean bl2 = headerShouldBeApplied = !this.rows.isEmpty() && isFirstOnThePage && (!table.isSkipFirstHeader() || !isFirstHeader) && !Boolean.TRUE.equals(this.getOwnProperty(97));
        if (headerElement != null && headerShouldBeApplied) {
            this.headerRenderer = this.initFooterOrHeaderRenderer(false, tableBorder);
        }
    }

    private void collapseAllBorders() {
        Border[] tableBorder = this.getBorders();
        int numberOfColumns = this.getTable().getNumberOfColumns();
        if (null != this.rows && this.isOriginalNonSplitRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer()) {
            this.collapseAllBordersAndEmptyRows(tableBorder, 0, this.rows.size() - 1, numberOfColumns);
        } else {
            this.updateFirstRowBorders(numberOfColumns);
        }
        if (this.isOriginalNonSplitRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer()) {
            this.rightBorderMaxWidth = this.getMaxRightWidth(tableBorder[1]);
            this.leftBorderMaxWidth = this.getMaxLeftWidth(tableBorder[3]);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.processRendererBorders(numberOfColumns);
            float rightFooterBorderWidth = this.footerRenderer.getMaxRightWidth(this.footerRenderer.getBorders()[1]);
            float leftFooterBorderWidth = this.footerRenderer.getMaxLeftWidth(this.footerRenderer.getBorders()[3]);
            if (this.isOriginalNonSplitRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer()) {
                this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftFooterBorderWidth);
                this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightFooterBorderWidth);
            }
        }
        if (this.headerRenderer != null) {
            this.headerRenderer.processRendererBorders(numberOfColumns);
            float rightHeaderBorderWidth = this.headerRenderer.getMaxRightWidth(this.headerRenderer.getBorders()[1]);
            float leftHeaderBorderWidth = this.headerRenderer.getMaxLeftWidth(this.headerRenderer.getBorders()[3]);
            if (this.isOriginalNonSplitRenderer && !this.isHeaderRenderer() && !this.isFooterRenderer()) {
                this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftHeaderBorderWidth);
                this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightHeaderBorderWidth);
            }
        }
    }

    private boolean isOriginalRenderer() {
        return this.isOriginalNonSplitRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer();
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Border[] borders;
        float bottomTableBorderWidth;
        this.overrideHeightProperties();
        Float blockMinHeight = this.retrieveMinHeight();
        Float blockMaxHeight = this.retrieveMaxHeight();
        boolean wasHeightClipped = false;
        LayoutArea area = layoutContext.getArea();
        Rectangle layoutBox = area.getBBox().clone();
        if (!((Table)this.modelElement).isComplete()) {
            this.setProperty(43, 0);
        }
        if (this.rowRange.getStartRow() != 0) {
            this.setProperty(46, 0);
        }
        this.heights.clear();
        this.childRenderers.clear();
        HashMap<Integer, Integer> rowMoves = new HashMap<Integer, Integer>();
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
            marginsCollapseHandler.startMarginsCollapse(layoutBox);
        }
        this.applyMargins(layoutBox, false);
        if (this.isPositioned()) {
            float x = this.getPropertyAsFloat(79).floatValue();
            float relativeX = this.isFixedLayout() ? 0.0f : layoutBox.getX();
            layoutBox.setX(relativeX + x);
        }
        Table tableModel = (Table)this.getModelElement();
        if (null != blockMaxHeight && blockMaxHeight.floatValue() < layoutBox.getHeight() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
            layoutBox.moveUp(layoutBox.getHeight() - blockMaxHeight.floatValue()).setHeight(blockMaxHeight.floatValue());
            wasHeightClipped = true;
        }
        int numberOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
        List<Border> lastFlushedRowBottomBorder = tableModel.getLastRowBottomBorder();
        Border widestLustFlushedBorder = null;
        for (Border border : lastFlushedRowBottomBorder) {
            if (null == border || null != widestLustFlushedBorder && !(widestLustFlushedBorder.getWidth() < border.getWidth())) continue;
            widestLustFlushedBorder = border;
        }
        if (this.isOriginalRenderer()) {
            this.initializeBorders(lastFlushedRowBottomBorder, area.isEmptyArea());
        }
        this.initializeHeaderAndFooter(0 == this.rowRange.getStartRow() || area.isEmptyArea());
        this.collapseAllBorders();
        if (this.isOriginalRenderer()) {
            this.calculateColumnWidths(layoutBox.getWidth(), false);
        }
        float tableWidth = this.getTableWidth();
        if (layoutBox.getWidth() > tableWidth) {
            layoutBox.setWidth(tableWidth + this.rightBorderMaxWidth / 2.0f + this.leftBorderMaxWidth / 2.0f);
        }
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), tableWidth, 0.0f));
        if (this.footerRenderer != null) {
            this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
            LayoutResult result = this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            if (result.getStatus() != 1) {
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float footerHeight = result.getOccupiedArea().getBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
            if (!tableModel.isEmpty()) {
                float maxFooterTopBorderWidth = 0.0f;
                List<Border> footerTopBorders = this.footerRenderer.horizontalBorders.get(0);
                for (Border border : footerTopBorders) {
                    if (null == border || !(border.getWidth() > maxFooterTopBorderWidth)) continue;
                    maxFooterTopBorderWidth = border.getWidth();
                }
                this.footerRenderer.occupiedArea.getBBox().decreaseHeight(maxFooterTopBorderWidth);
                layoutBox.moveDown(maxFooterTopBorderWidth).increaseHeight(maxFooterTopBorderWidth);
            }
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                this.footerRenderer.setProperty(26, true);
            }
        }
        float topTableBorderWidth = this.getMaxTopWidth(null);
        if (this.headerRenderer != null) {
            this.prepareFooterOrHeaderRendererForLayout(this.headerRenderer, layoutBox.getWidth());
            LayoutResult result = this.headerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            if (result.getStatus() != 1) {
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float headerHeight = result.getOccupiedArea().getBBox().getHeight();
            layoutBox.decreaseHeight(headerHeight);
            this.occupiedArea.getBBox().moveDown(headerHeight).increaseHeight(headerHeight);
            float maxHeaderBottomBorderWidth = 0.0f;
            List<Border> rowBorders = this.headerRenderer.horizontalBorders.get(this.headerRenderer.horizontalBorders.size() - 1);
            for (Border border : rowBorders) {
                if (null == border || !(maxHeaderBottomBorderWidth < border.getWidth())) continue;
                maxHeaderBottomBorderWidth = border.getWidth();
            }
            if (!tableModel.isEmpty()) {
                if (maxHeaderBottomBorderWidth < topTableBorderWidth) {
                    this.headerRenderer.heights.set(this.headerRenderer.heights.size() - 1, Float.valueOf(this.headerRenderer.heights.get(this.headerRenderer.heights.size() - 1).floatValue() + (topTableBorderWidth - maxHeaderBottomBorderWidth) / 2.0f));
                    this.headerRenderer.occupiedArea.getBBox().moveDown(topTableBorderWidth - maxHeaderBottomBorderWidth).increaseHeight(topTableBorderWidth - maxHeaderBottomBorderWidth);
                    this.occupiedArea.getBBox().moveDown(topTableBorderWidth - maxHeaderBottomBorderWidth).increaseHeight(topTableBorderWidth - maxHeaderBottomBorderWidth);
                    layoutBox.decreaseHeight(topTableBorderWidth - maxHeaderBottomBorderWidth);
                } else {
                    topTableBorderWidth = maxHeaderBottomBorderWidth;
                }
                layoutBox.increaseHeight(topTableBorderWidth);
                this.occupiedArea.getBBox().moveUp(topTableBorderWidth).decreaseHeight(topTableBorderWidth);
            }
        }
        float f = bottomTableBorderWidth = null == (borders = this.getBorders())[2] ? 0.0f : borders[2].getWidth();
        if (null != this.rows && 0 != this.rows.size()) {
            this.correctFirstRowTopBorders(borders[0], numberOfColumns);
        }
        topTableBorderWidth = this.getMaxTopWidth(borders[0]);
        layoutBox.applyMargins(0.0f, this.rightBorderMaxWidth / 2.0f, 0.0f, this.leftBorderMaxWidth / 2.0f, false);
        if (!tableModel.isEmpty() && 0 != this.rows.size()) {
            layoutBox.decreaseHeight(topTableBorderWidth / 2.0f);
            this.occupiedArea.getBBox().moveDown(topTableBorderWidth / 2.0f).increaseHeight(topTableBorderWidth / 2.0f);
        } else if (tableModel.isComplete() && 0 == lastFlushedRowBottomBorder.size()) {
            layoutBox.decreaseHeight(topTableBorderWidth);
            this.occupiedArea.getBBox().moveDown(topTableBorderWidth).increaseHeight(topTableBorderWidth);
        }
        LayoutResult[] splits = new LayoutResult[numberOfColumns];
        int[] targetOverflowRowIndex = new int[numberOfColumns];
        for (int row = 0; row < this.rows.size(); ++row) {
            int status;
            Object rowspans;
            TableRenderer[] splitResult;
            float rowspanOffset;
            CellRenderer cell;
            int col;
            if (row == 1 && Boolean.TRUE.equals(this.getProperty(26))) {
                if (Boolean.TRUE.equals(this.getOwnProperty(26))) {
                    this.deleteOwnProperty(26);
                } else {
                    this.setProperty(26, false);
                }
            }
            CellRenderer[] cellRendererArray = this.rows.get(row);
            float rowHeight = 0.0f;
            boolean split = false;
            boolean hasContent = true;
            boolean cellWithBigRowspanAdded = false;
            ArrayList<CellRenderer> currChildRenderers = new ArrayList<CellRenderer>();
            ArrayDeque<CellRendererInfo> cellProcessingQueue = new ArrayDeque<CellRendererInfo>();
            for (col = 0; col < cellRendererArray.length; ++col) {
                if (cellRendererArray[col] == null) continue;
                cellProcessingQueue.addLast(new CellRendererInfo(cellRendererArray[col], col, row));
            }
            IRenderer firstCauseOfNothing = null;
            bottomTableBorderWidth = 0.0f;
            Border widestRowBottomBorder = null;
            if (row + 1 < this.horizontalBorders.size()) {
                for (Border border : this.horizontalBorders.get(row + 1)) {
                    if (null == border || null != widestRowBottomBorder && !(border.getWidth() > widestRowBottomBorder.getWidth())) continue;
                    widestRowBottomBorder = border;
                }
            }
            boolean processAsLast = false;
            while (cellProcessingQueue.size() > 0) {
                int addCol;
                Border oldBottomBorder;
                Border collapsedBottomBorder;
                CellRendererInfo currentCellInfo = (CellRendererInfo)cellProcessingQueue.pop();
                col = currentCellInfo.column;
                cell = currentCellInfo.cellRenderer;
                int colspan = cell.getPropertyAsInteger(16);
                int rowspan = cell.getPropertyAsInteger(60);
                if (1 != rowspan) {
                    cellWithBigRowspanAdded = true;
                }
                targetOverflowRowIndex[col] = currentCellInfo.finishRowInd;
                boolean currentCellHasBigRowspan = row != currentCellInfo.finishRowInd;
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (int k = col; k < col + colspan; ++k) {
                    cellWidth += this.countedColumnWidth[k];
                }
                for (int l = 0; l < col; ++l) {
                    colOffset += this.countedColumnWidth[l];
                }
                rowspanOffset = 0.0f;
                for (int m = row - 1; m > currentCellInfo.finishRowInd - rowspan && m >= 0; --m) {
                    rowspanOffset += this.heights.get(m).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + (!currentCellHasBigRowspan || hasContent ? layoutBox.getHeight() : 0.0f);
                float cellLayoutBoxBottom = layoutBox.getY() + (!currentCellHasBigRowspan || hasContent ? 0.0f : layoutBox.getHeight());
                Rectangle cellLayoutBox = new Rectangle(layoutBox.getX() + colOffset, cellLayoutBoxBottom, cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutContext.getArea().getPageNumber(), cellLayoutBox);
                VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)cell.getProperty(75));
                cell.setProperty(75, null);
                UnitValue cellWidthProperty = (UnitValue)cell.getProperty(77);
                if (cellWidthProperty != null && cellWidthProperty.isPercentValue()) {
                    cell.setProperty(77, UnitValue.createPointValue(cellWidth));
                }
                if ((collapsedBottomBorder = this.getCollapsedBorder(oldBottomBorder = cell.getBorders()[2], this.footerRenderer != null ? this.footerRenderer.horizontalBorders.get(0).get(col) : borders[2])) != null) {
                    float diff = Math.max(collapsedBottomBorder.getWidth(), null != widestRowBottomBorder ? widestRowBottomBorder.getWidth() : 0.0f);
                    cellArea.getBBox().moveUp(diff / 2.0f).decreaseHeight(diff / 2.0f);
                    cell.setProperty(10, collapsedBottomBorder);
                }
                LayoutResult cellResult = cell.setParent(this).layout(new LayoutContext(cellArea));
                if (!processAsLast && 3 == cellResult.getStatus()) {
                    processAsLast = true;
                    widestRowBottomBorder = null;
                    for (int tempCol = 0; tempCol < cellRendererArray.length; ++tempCol) {
                        if (null == cellRendererArray[tempCol]) continue;
                        cellRendererArray[tempCol].deleteOwnProperty(10);
                        oldBottomBorder = cellRendererArray[tempCol].getBorders()[2];
                        if (null == oldBottomBorder || null != widestRowBottomBorder && !(widestRowBottomBorder.getWidth() > oldBottomBorder.getWidth())) continue;
                        widestRowBottomBorder = oldBottomBorder;
                    }
                    cellProcessingQueue.clear();
                    for (addCol = 0; addCol < cellRendererArray.length; ++addCol) {
                        if (cellRendererArray[addCol] == null) continue;
                        cellProcessingQueue.addLast(new CellRendererInfo(cellRendererArray[addCol], addCol, row));
                    }
                    continue;
                }
                if (collapsedBottomBorder != null && null != cellResult.getOccupiedArea()) {
                    cellResult.getOccupiedArea().getBBox().moveUp((collapsedBottomBorder.getWidth() - (oldBottomBorder == null ? 0.0f : oldBottomBorder.getWidth())) / 2.0f).decreaseHeight((collapsedBottomBorder.getWidth() - (oldBottomBorder == null ? 0.0f : oldBottomBorder.getWidth())) / 2.0f);
                    cell.setProperty(10, oldBottomBorder);
                }
                cell.setProperty(75, (Object)verticalAlignment);
                if (cellResult.getStatus() != 3) {
                    cell.getOccupiedArea().getBBox().setWidth(cellWidth);
                } else if (null == firstCauseOfNothing) {
                    firstCauseOfNothing = cellResult.getCauseOfNothing();
                }
                if (currentCellHasBigRowspan) {
                    if (cellResult.getStatus() != 1) {
                        splits[col] = cellResult;
                    }
                    if (cellResult.getStatus() == 2) {
                        cellRendererArray[col] = (CellRenderer)cellResult.getSplitRenderer();
                    } else {
                        this.rows.get((int)currentCellInfo.finishRowInd)[col] = null;
                        cellRendererArray[col] = cell;
                        rowMoves.put(col, currentCellInfo.finishRowInd);
                    }
                } else if (cellResult.getStatus() != 1) {
                    if (!split) {
                        if (null != this.footerRenderer && tableModel.isSkipLastFooter() && tableModel.isComplete()) {
                            LayoutArea potentialArea = new LayoutArea(area.getPageNumber(), layoutBox.clone());
                            Border widestRowTopBorder = null;
                            for (Border border : this.horizontalBorders.get(row)) {
                                if (null == border || null != widestRowTopBorder && !(border.getWidth() > widestRowTopBorder.getWidth())) continue;
                                widestRowTopBorder = border;
                            }
                            if (null != widestRowTopBorder) {
                                potentialArea.getBBox().moveDown(widestRowTopBorder.getWidth() / 2.0f).increaseHeight(widestRowTopBorder.getWidth() / 2.0f);
                            }
                            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
                            potentialArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
                            TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
                            overflowRenderer.rows = this.rows.subList(row, this.rows.size());
                            overflowRenderer.setProperty(97, true);
                            overflowRenderer.setProperty(96, true);
                            overflowRenderer.setProperty(46, 0);
                            overflowRenderer.setProperty(43, 0);
                            overflowRenderer.setProperty(44, 0);
                            overflowRenderer.setProperty(45, 0);
                            overflowRenderer.initializeBorders(new ArrayList<Border>(), true);
                            overflowRenderer.collapseAllBordersAndEmptyRows(overflowRenderer.getBorders(), 0, this.rowRange.getFinishRow() - this.rowRange.getStartRow() - row, numberOfColumns);
                            this.prepareFooterOrHeaderRendererForLayout(overflowRenderer, layoutBox.getWidth());
                            if (1 == overflowRenderer.layout(new LayoutContext(potentialArea)).getStatus()) {
                                this.footerRenderer = null;
                                layoutBox.increaseHeight(footerHeight).moveDown(footerHeight);
                                this.deleteOwnProperty(10);
                                borders = this.getBorders();
                                processAsLast = false;
                                cellProcessingQueue.clear();
                                for (addCol = 0; addCol < cellRendererArray.length; ++addCol) {
                                    if (cellRendererArray[addCol] == null) continue;
                                    cellProcessingQueue.addLast(new CellRendererInfo(cellRendererArray[addCol], addCol, row));
                                }
                                for (CellRendererInfo curCellInfo : cellProcessingQueue) {
                                    col = curCellInfo.column;
                                    cell = curCellInfo.cellRenderer;
                                    this.prepareBuildingBordersArrays(cell, borders, tableModel.getNumberOfColumns(), row, col);
                                    this.buildBordersArrays(cell, curCellInfo.finishRowInd, col);
                                }
                                continue;
                            }
                        }
                        block15: for (addCol = 0; addCol < cellRendererArray.length; ++addCol) {
                            if (cellRendererArray[addCol] != null) continue;
                            for (int addRow = row + 1; addRow < this.rows.size(); ++addRow) {
                                if (this.rows.get(addRow)[addCol] == null) continue;
                                CellRenderer addRenderer = this.rows.get(addRow)[addCol];
                                verticalAlignment = (VerticalAlignment)((Object)addRenderer.getProperty(75));
                                if (row + addRenderer.getPropertyAsInteger(60) - 1 < addRow) continue block15;
                                cellProcessingQueue.addLast(new CellRendererInfo(addRenderer, addCol, addRow));
                                continue block15;
                            }
                        }
                    }
                    split = true;
                    if (cellResult.getStatus() == 3) {
                        hasContent = false;
                    }
                    splits[col] = cellResult;
                }
                currChildRenderers.add(cell);
                if (cellResult.getStatus() == 3) continue;
                rowHeight = Math.max(rowHeight, cell.getOccupiedArea().getBBox().getHeight() - rowspanOffset);
            }
            if (!(null == this.footerRenderer || 0 == lastFlushedRowBottomBorder.size() && tableModel.isComplete() || hasContent || 0 != this.childRenderers.size())) {
                layoutBox.increaseHeight(this.occupiedArea.getBBox().getHeight());
                this.occupiedArea.getBBox().moveUp(this.occupiedArea.getBBox().getHeight()).setHeight(0.0f);
            }
            if (hasContent) {
                this.heights.add(Float.valueOf(rowHeight));
                this.occupiedArea.getBBox().moveDown(rowHeight);
                this.occupiedArea.getBBox().increaseHeight(rowHeight);
                layoutBox.decreaseHeight(rowHeight);
            }
            if (row == this.rows.size() - 1 && null != this.footerRenderer && tableModel.isComplete() && tableModel.isSkipLastFooter() && !split && !processAsLast) {
                this.footerRenderer = null;
                this.deleteOwnProperty(10);
                if (tableModel.isEmpty()) {
                    this.deleteOwnProperty(13);
                }
                borders = this.getBorders();
            }
            if (split || processAsLast || row == this.rows.size() - 1) {
                if (this.heights.size() != 0) {
                    rowHeight = 0.0f;
                    if (split && hasContent) {
                        this.horizontalBorders.add(row + 1, new ArrayList(this.horizontalBorders.get(row + 1)));
                    }
                    for (col = 0; col < cellRendererArray.length; ++col) {
                        if (hasContent || cellWithBigRowspanAdded && null == this.rows.get(row - 1)[col]) {
                            if (null == cellRendererArray[col]) continue;
                            cellProcessingQueue.addLast(new CellRendererInfo(cellRendererArray[col], col, row));
                            continue;
                        }
                        if (null == this.rows.get(row - 1)[col]) continue;
                        cellProcessingQueue.addLast(new CellRendererInfo(this.rows.get(row - 1)[col], col, row - 1));
                    }
                    while (0 != cellProcessingQueue.size()) {
                        float collapsedBorderWidth;
                        CellRendererInfo cellInfo = (CellRendererInfo)cellProcessingQueue.pop();
                        col = cellInfo.column;
                        cell = cellInfo.cellRenderer;
                        float collapsedWithNextRowBorderWidth = null == cell.getBorders()[2] ? 0.0f : cell.getBorders()[2].getWidth();
                        cell.deleteOwnProperty(10);
                        Border cellOwnBottomBorder = cell.getBorders()[2];
                        Border collapsedWithTableBorder = this.getCollapsedBorder(cellOwnBottomBorder, this.footerRenderer != null ? this.footerRenderer.horizontalBorders.get(0).get(col) : borders[2]);
                        if (null != collapsedWithTableBorder && bottomTableBorderWidth < collapsedWithTableBorder.getWidth()) {
                            bottomTableBorderWidth = collapsedWithTableBorder.getWidth();
                        }
                        float f2 = collapsedBorderWidth = null == collapsedWithTableBorder ? 0.0f : collapsedWithTableBorder.getWidth();
                        if (collapsedWithNextRowBorderWidth != collapsedBorderWidth) {
                            cell.setBorders(collapsedWithTableBorder, 2);
                            for (int i = col; i < col + cell.getPropertyAsInteger(16); ++i) {
                                this.horizontalBorders.get(row + (hasContent ? 1 : 0)).set(i, collapsedWithTableBorder);
                            }
                            cell.occupiedArea.getBBox().moveDown((collapsedBorderWidth - collapsedWithNextRowBorderWidth) / 2.0f).increaseHeight((collapsedBorderWidth - collapsedWithNextRowBorderWidth) / 2.0f);
                        }
                        int cellRowStartIndex = cell.getModelElement().getRow();
                        rowspanOffset = 0.0f;
                        for (int l = cellRowStartIndex; l < this.heights.size() - 1; ++l) {
                            rowspanOffset += this.heights.get(l).floatValue();
                        }
                        if (!(cell.occupiedArea.getBBox().getHeight() > rowHeight + rowspanOffset)) continue;
                        rowHeight = cell.occupiedArea.getBBox().getHeight() - rowspanOffset;
                    }
                    if (rowHeight != this.heights.get(this.heights.size() - 1).floatValue()) {
                        float heightDiff = rowHeight - this.heights.get(this.heights.size() - 1).floatValue();
                        this.heights.set(this.heights.size() - 1, Float.valueOf(rowHeight));
                        this.occupiedArea.getBBox().moveDown(heightDiff).increaseHeight(heightDiff);
                        layoutBox.decreaseHeight(heightDiff);
                    }
                } else if (null != borders[2]) {
                    for (col = 0; col < numberOfColumns; ++col) {
                        if (null != this.horizontalBorders.get(1).get(col) && !(this.horizontalBorders.get(1).get(col).getWidth() < borders[2].getWidth())) continue;
                        this.horizontalBorders.get(1).set(col, borders[2]);
                    }
                }
                this.correctCellsOccupiedAreas(splits, row, targetOverflowRowIndex, blockMinHeight, layoutBox, bottomTableBorderWidth, !split && row == this.rows.size() - 1);
            }
            if ((split || processAsLast || row == this.rows.size() - 1) && null != this.footerRenderer) {
                int lastRow = hasContent || cellWithBigRowspanAdded ? row + 1 : row;
                boolean[] useFooterBorders = new boolean[numberOfColumns];
                if (!tableModel.isEmpty()) {
                    useFooterBorders = this.collapseFooterBorders(0 != lastFlushedRowBottomBorder.size() && 0 == row ? lastFlushedRowBottomBorder : this.horizontalBorders.get(lastRow), numberOfColumns, this.rows.size());
                    layoutBox.increaseHeight(bottomTableBorderWidth / 2.0f);
                    this.occupiedArea.getBBox().moveUp(bottomTableBorderWidth / 2.0f).decreaseHeight(bottomTableBorderWidth / 2.0f);
                }
                this.footerRenderer.processRendererBorders(numberOfColumns);
                layoutBox.moveDown(this.footerRenderer.occupiedArea.getBBox().getHeight()).increaseHeight(this.footerRenderer.occupiedArea.getBBox().getHeight());
                layoutBox.applyMargins(0.0f, -this.rightBorderMaxWidth / 2.0f, 0.0f, -this.leftBorderMaxWidth / 2.0f, false);
                this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
                this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
                layoutBox.applyMargins(0.0f, -this.rightBorderMaxWidth / 2.0f, 0.0f, -this.leftBorderMaxWidth / 2.0f, true);
                float footerHeight = this.footerRenderer.getOccupiedAreaBBox().getHeight();
                this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
                layoutBox.setY(this.footerRenderer.occupiedArea.getBBox().getTop()).setHeight(this.occupiedArea.getBBox().getBottom() - layoutBox.getBottom());
                if (!tableModel.isEmpty()) {
                    this.fixFooterBorders(0 != lastFlushedRowBottomBorder.size() && 0 == row ? lastFlushedRowBottomBorder : this.horizontalBorders.get(lastRow), numberOfColumns, this.rows.size(), useFooterBorders);
                }
            }
            if (!split) {
                this.childRenderers.addAll(currChildRenderers);
                currChildRenderers.clear();
            }
            if (!split && !processAsLast) continue;
            if (marginsCollapsingEnabled) {
                marginsCollapseHandler.endMarginsCollapse(layoutBox);
            }
            TableRenderer[] tableRendererArray = splitResult = !split && processAsLast ? this.split(row + 1, false, cellWithBigRowspanAdded) : this.split(row, hasContent, cellWithBigRowspanAdded);
            if (null != this.headerRenderer || null != this.footerRenderer) {
                if (null != this.headerRenderer || tableModel.isEmpty()) {
                    splitResult[1].deleteOwnProperty(13);
                }
                if (null != this.footerRenderer || tableModel.isEmpty()) {
                    splitResult[1].deleteOwnProperty(10);
                }
            }
            if (split) {
                rowspans = new int[cellRendererArray.length];
                boolean[] columnsWithCellToBeEnlarged = new boolean[cellRendererArray.length];
                for (col = 0; col < cellRendererArray.length; ++col) {
                    boolean isBigRowspannedCell;
                    if (splits[col] != null) {
                        CellRenderer cellSplit = (CellRenderer)splits[col].getSplitRenderer();
                        if (null != cellSplit) {
                            rowspans[col] = cellSplit.getModelElement().getRowspan();
                        }
                        if (splits[col].getStatus() != 3 && (hasContent || cellWithBigRowspanAdded)) {
                            this.childRenderers.add(cellSplit);
                        }
                        LayoutArea cellOccupiedArea = cellRendererArray[col].getOccupiedArea();
                        if (hasContent || cellWithBigRowspanAdded || splits[col].getStatus() == 3) {
                            CellRenderer cellOverflow = (CellRenderer)splits[col].getOverflowRenderer();
                            cellOverflow.deleteOwnProperty(10);
                            cellOverflow.deleteOwnProperty(13);
                            if (null != cellSplit) {
                                for (int j = col; j < col + cellOverflow.getPropertyAsInteger(16); ++j) {
                                    splitResult[0].horizontalBorders.get(row + (hasContent ? 1 : 0)).set(j, this.getCollapsedBorder(cellRendererArray[col].getBorders()[2], borders[2]));
                                }
                            }
                            cellRendererArray[col] = null;
                            this.rows.get((int)targetOverflowRowIndex[col])[col] = (CellRenderer)cellOverflow.setParent(splitResult[1]);
                        } else {
                            this.rows.get((int)targetOverflowRowIndex[col])[col] = (CellRenderer)cellRendererArray[col].setParent(splitResult[1]);
                            this.rows.get(targetOverflowRowIndex[col])[col].deleteOwnProperty(13);
                        }
                        this.rows.get((int)targetOverflowRowIndex[col])[col].occupiedArea = cellOccupiedArea;
                        continue;
                    }
                    if (cellRendererArray[col] == null) continue;
                    if (hasContent) {
                        rowspans[col] = cellRendererArray[col].getModelElement().getRowspan();
                    }
                    boolean bl = isBigRowspannedCell = 1 != cellRendererArray[col].getModelElement().getRowspan();
                    if (hasContent || isBigRowspannedCell) {
                        columnsWithCellToBeEnlarged[col] = true;
                    } else if (Border.NO_BORDER != cellRendererArray[col].getProperty(13)) {
                        splitResult[1].rows.get(0)[col].deleteOwnProperty(13);
                    }
                    for (int j = col; j < col + cellRendererArray[col].getPropertyAsInteger(16); ++j) {
                        this.horizontalBorders.get(row + (hasContent ? 1 : 0)).set(j, this.getCollapsedBorder(cellRendererArray[col].getBorders()[2], borders[2]));
                    }
                }
                int minRowspan = Integer.MAX_VALUE;
                for (col = 0; col < ((int[])rowspans).length; ++col) {
                    if (false == rowspans[col]) continue;
                    minRowspan = Math.min(minRowspan, (int)rowspans[col]);
                }
                for (col = 0; col < numberOfColumns; ++col) {
                    if (!columnsWithCellToBeEnlarged[col]) continue;
                    LayoutArea cellOccupiedArea = cellRendererArray[col].getOccupiedArea();
                    if (1 == minRowspan) {
                        Cell overflowCell = cellRendererArray[col].getModelElement().clone(true);
                        cellRendererArray[col].isLastRendererForModelElement = false;
                        this.childRenderers.add(cellRendererArray[col]);
                        cellRendererArray[col] = null;
                        this.rows.get((int)targetOverflowRowIndex[col])[col] = (CellRenderer)overflowCell.getRenderer().setParent(this);
                        this.rows.get(targetOverflowRowIndex[col])[col].deleteProperty(27);
                        this.rows.get(targetOverflowRowIndex[col])[col].deleteProperty(85);
                        this.rows.get(targetOverflowRowIndex[col])[col].deleteProperty(84);
                    } else {
                        int i;
                        this.childRenderers.add(cellRendererArray[col]);
                        for (i = row; i < row + minRowspan && i + 1 < this.rows.size() && this.rows.get(i + 1)[col] != null; ++i) {
                            this.rows.get((int)i)[col] = this.rows.get(i + 1)[col];
                            this.rows.get((int)(i + 1))[col] = null;
                        }
                        if (i != row + minRowspan - 1 && null != this.rows.get(i)[col]) {
                            Cell overflowCell = this.rows.get(i)[col].getModelElement();
                            this.rows.get((int)i)[col].isLastRendererForModelElement = false;
                            this.rows.get((int)i)[col] = null;
                            this.rows.get((int)targetOverflowRowIndex[col])[col] = (CellRenderer)overflowCell.getRenderer().setParent(this);
                        }
                    }
                    this.rows.get((int)targetOverflowRowIndex[col])[col].occupiedArea = cellOccupiedArea;
                }
            }
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.occupiedArea.getBBox().moveDown(bottomTableBorderWidth / 2.0f).increaseHeight(bottomTableBorderWidth / 2.0f);
                    layoutBox.decreaseHeight(bottomTableBorderWidth / 2.0f);
                } else {
                    this.occupiedArea.getBBox().moveUp(topTableBorderWidth / 2.0f).decreaseHeight(topTableBorderWidth / 2.0f);
                    layoutBox.increaseHeight(topTableBorderWidth / 2.0f);
                    if (!tableModel.isComplete() || 0 != lastFlushedRowBottomBorder.size()) {
                        bottomTableBorderWidth = null == widestLustFlushedBorder ? 0.0f : widestLustFlushedBorder.getWidth();
                        this.occupiedArea.getBBox().moveDown(bottomTableBorderWidth).increaseHeight(bottomTableBorderWidth);
                        splitResult[0].horizontalBorders.clear();
                        splitResult[0].horizontalBorders.add(lastFlushedRowBottomBorder);
                        splitResult[0].setBorders(widestLustFlushedBorder, 2);
                        splitResult[0].setBorders(Border.NO_BORDER, 0);
                        if (0 != splitResult[0].verticalBorders.size()) {
                            splitResult[0].setBorders(splitResult[0].verticalBorders.get(0).get(0), 3);
                            splitResult[0].setBorders(splitResult[0].verticalBorders.get(this.verticalBorders.size() - 1).get(0), 1);
                        }
                    }
                }
            }
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86)) || Boolean.TRUE.equals(this.getPropertyAsBoolean(87))) {
                this.extendLastRow(cellRendererArray, layoutBox);
            }
            this.adjustFooterAndFixOccupiedArea(layoutBox);
            rowspans = rowMoves.entrySet().iterator();
            while (rowspans.hasNext()) {
                Map.Entry entry = (Map.Entry)rowspans.next();
                if (null != splitResult[1].rows.get((Integer)entry.getValue() - splitResult[0].rows.size())[(Integer)entry.getKey()]) continue;
                splitResult[1].rows.get((int)(((Integer)entry.getValue()).intValue() - splitResult[0].rows.size()))[((Integer)entry.getKey()).intValue()] = splitResult[1].rows.get(row - splitResult[0].rows.size())[(Integer)entry.getKey()];
                splitResult[1].rows.get((int)(row - splitResult[0].rows.size()))[((Integer)entry.getKey()).intValue()] = null;
            }
            if (this.isKeepTogether() && 0 == lastFlushedRowBottomBorder.size() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new LayoutResult(3, null, null, this, null == firstCauseOfNothing ? this : firstCauseOfNothing);
            }
            int n = status = this.occupiedArea.getBBox().getHeight() - (null == this.footerRenderer ? 0.0f : this.footerRenderer.getOccupiedArea().getBBox().getHeight()) == 0.0f && tableModel.isComplete() && 0 == lastFlushedRowBottomBorder.size() ? 3 : 2;
            if (status == 3 && Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
                if (wasHeightClipped) {
                    Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                    logger.warn("Element content was clipped because some height properties are set.");
                    if (status == 3) {
                        ArrayList<Border> topBorders = new ArrayList<Border>();
                        ArrayList<Border> bottomBorders = new ArrayList<Border>();
                        for (int i = 0; i < numberOfColumns; ++i) {
                            topBorders.add(borders[0]);
                            bottomBorders.add(borders[2]);
                        }
                        this.horizontalBorders.clear();
                        this.horizontalBorders.add(topBorders);
                        this.horizontalBorders.add(bottomBorders);
                        float bordersWidth = (null == borders[0] ? 0.0f : borders[0].getWidth()) + (null == borders[2] ? 0.0f : borders[2].getWidth());
                        this.occupiedArea.getBBox().moveDown(bordersWidth).increaseHeight(bordersWidth);
                    }
                    if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
                        float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()), layoutBox.getBottom());
                        if (0 == this.heights.size()) {
                            this.heights.add(Float.valueOf(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() / 2.0f));
                        } else {
                            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                        }
                        this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
                    }
                }
                return new LayoutResult(1, this.occupiedArea, splitResult[0], null);
            }
            if (this.hasProperty(27)) {
                splitResult[1].setProperty(27, Float.valueOf(this.retrieveHeight().floatValue() - this.occupiedArea.getBBox().getHeight()));
            }
            if (status != 3) {
                return new LayoutResult(status, this.occupiedArea, splitResult[0], splitResult[1], null);
            }
            return new LayoutResult(status, null, splitResult[0], splitResult[1], firstCauseOfNothing);
        }
        if (tableModel.isComplete() && !tableModel.isEmpty()) {
            int lastInRow;
            CellRenderer[] cellRendererArray = this.rows.get(this.rows.size() - 1);
            for (lastInRow = cellRendererArray.length - 1; lastInRow >= 0 && null == cellRendererArray[lastInRow]; --lastInRow) {
            }
            if (lastInRow < 0 || cellRendererArray.length != lastInRow + cellRendererArray[lastInRow].getPropertyAsInteger(16)) {
                Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                logger.warn("Last row is not completed. Table bottom border may collapse as you do not expect it");
            }
        }
        if (tableModel.isComplete() && 0 != lastFlushedRowBottomBorder.size() && null != this.footerRenderer) {
            boolean[] blArray = this.collapseFooterBorders(lastFlushedRowBottomBorder, numberOfColumns, this.rows.size());
            this.footerRenderer.processRendererBorders(numberOfColumns);
            layoutBox.moveDown(this.footerRenderer.occupiedArea.getBBox().getHeight()).increaseHeight(this.footerRenderer.occupiedArea.getBBox().getHeight());
            layoutBox.applyMargins(0.0f, -this.rightBorderMaxWidth / 2.0f, 0.0f, -this.leftBorderMaxWidth / 2.0f, false);
            this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
            this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox)));
            layoutBox.applyMargins(0.0f, -this.rightBorderMaxWidth / 2.0f, 0.0f, -this.leftBorderMaxWidth / 2.0f, true);
            float footerHeight = this.footerRenderer.getOccupiedAreaBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
            this.fixFooterBorders(lastFlushedRowBottomBorder, numberOfColumns, this.rows.size(), blArray);
        }
        if (0 == this.childRenderers.size() && null == this.headerRenderer && null == this.footerRenderer) {
            int i;
            ArrayList<Border> arrayList = new ArrayList<Border>();
            List<Object> bottomHorizontalBorders = new ArrayList<Border>();
            for (int i2 = 0; i2 < numberOfColumns; ++i2) {
                bottomHorizontalBorders.add(Border.NO_BORDER);
            }
            ArrayList<Border> leftVerticalBorders = new ArrayList<Border>();
            ArrayList<Border> rightVerticalBorders = new ArrayList<Border>();
            if (tableModel.isComplete() && 0 != lastFlushedRowBottomBorder.size()) {
                bottomHorizontalBorders = lastFlushedRowBottomBorder;
                this.setBorders(widestLustFlushedBorder, 2);
                this.setBorders(Border.NO_BORDER, 0);
            }
            for (i = 0; i < bottomHorizontalBorders.size(); ++i) {
                Border border = (Border)bottomHorizontalBorders.get(i);
                if (null == border || null != borders[2] && border.getWidth() < borders[2].getWidth()) {
                    bottomHorizontalBorders.set(i, borders[2]);
                }
                arrayList.add(borders[0]);
            }
            this.horizontalBorders.set(0, arrayList);
            this.horizontalBorders.add(bottomHorizontalBorders);
            leftVerticalBorders.add(borders[3]);
            rightVerticalBorders.add(borders[1]);
            this.verticalBorders = new ArrayList<List<Border>>();
            this.verticalBorders.add(leftVerticalBorders);
            for (i = 0; i < numberOfColumns - 1; ++i) {
                this.verticalBorders.add(new ArrayList());
            }
            this.verticalBorders.add(rightVerticalBorders);
            if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight() + bottomTableBorderWidth) {
                float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() - bottomTableBorderWidth), layoutBox.getBottom() + bottomTableBorderWidth);
                if (0 != this.heights.size()) {
                    this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + this.occupiedArea.getBBox().getBottom() - blockBottom));
                } else {
                    this.heights.add(Float.valueOf(this.occupiedArea.getBBox().getBottom() - blockBottom + topTableBorderWidth / 2.0f + bottomTableBorderWidth / 2.0f));
                }
                this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
            }
        }
        if (tableModel.isComplete()) {
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.occupiedArea.getBBox().moveDown(bottomTableBorderWidth / 2.0f).increaseHeight(bottomTableBorderWidth / 2.0f);
                    layoutBox.decreaseHeight(bottomTableBorderWidth / 2.0f);
                } else {
                    if (0 != lastFlushedRowBottomBorder.size() && null != widestLustFlushedBorder && widestLustFlushedBorder.getWidth() > bottomTableBorderWidth) {
                        bottomTableBorderWidth = widestLustFlushedBorder.getWidth();
                    }
                    this.occupiedArea.getBBox().moveDown(bottomTableBorderWidth).increaseHeight(bottomTableBorderWidth);
                    layoutBox.decreaseHeight(bottomTableBorderWidth);
                }
            }
        } else {
            if (0 != this.heights.size()) {
                this.horizontalBorders.get(this.horizontalBorders.size() - 1).clear();
                this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() - bottomTableBorderWidth / 2.0f));
            }
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.occupiedArea.getBBox().moveUp(bottomTableBorderWidth / 2.0f).decreaseHeight(bottomTableBorderWidth / 2.0f);
                    layoutBox.increaseHeight(bottomTableBorderWidth / 2.0f);
                }
            } else {
                layoutBox.increaseHeight(bottomTableBorderWidth);
            }
        }
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86)) && 0 != this.rows.size()) {
            this.extendLastRow(this.rows.get(this.rows.size() - 1), layoutBox);
        }
        if (this.isPositioned()) {
            float f3 = this.getPropertyAsFloat(80).floatValue();
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + f3 - this.occupiedArea.getBBox().getY());
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if ((tableModel.isSkipLastFooter() || !tableModel.isComplete()) && null != this.footerRenderer) {
            if (0 != lastFlushedRowBottomBorder.size()) {
                if (null != widestLustFlushedBorder && widestLustFlushedBorder.getWidth() > bottomTableBorderWidth) {
                    bottomTableBorderWidth = widestLustFlushedBorder.getWidth();
                }
                this.setBorders(widestLustFlushedBorder, 0);
            }
            this.footerRenderer = null;
            if (tableModel.isComplete()) {
                this.occupiedArea.getBBox().moveDown(bottomTableBorderWidth).increaseHeight(bottomTableBorderWidth);
            }
        }
        this.adjustFooterAndFixOccupiedArea(layoutBox);
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        boolean ignoreTag = false;
        PdfName role = null;
        if (isTagged) {
            role = ((IAccessibleElement)((Object)this.getModelElement())).getRole();
            boolean isHeaderOrFooter = PdfName.THead.equals(role) || PdfName.TFoot.equals(role);
            boolean ignoreHeaderFooterTag = document.getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
            boolean bl = ignoreTag = isHeaderOrFooter && ignoreHeaderFooterTag;
        }
        if (role != null && !role.equals(PdfName.Artifact) && !ignoreTag) {
            boolean toRemoveConnectionsWithTag;
            TagStructureContext tagStructureContext = document.getTagStructureContext();
            TagTreePointer tagPointer = tagStructureContext.getAutoTaggingPointer();
            IAccessibleElement accessibleElement = (IAccessibleElement)((Object)this.getModelElement());
            if (!tagStructureContext.isElementConnectedToTag(accessibleElement)) {
                AccessibleAttributesApplier.applyLayoutAttributes(role, this, document);
            }
            Table modelElement = (Table)this.getModelElement();
            tagPointer.addTag(accessibleElement, true);
            super.draw(drawContext);
            tagPointer.moveToParent();
            boolean bl = toRemoveConnectionsWithTag = this.isLastRendererForModelElement && modelElement.isComplete();
            if (toRemoveConnectionsWithTag) {
                tagPointer.removeElementConnectionToTag(accessibleElement);
            }
        } else {
            super.draw(drawContext);
        }
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        boolean shouldHaveFooterOrHeaderTag;
        Table modelElement = (Table)this.getModelElement();
        if (this.headerRenderer != null) {
            boolean notToTagHeader;
            boolean firstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer && !modelElement.isSkipFirstHeader();
            boolean bl = notToTagHeader = drawContext.isTaggingEnabled() && !firstHeader;
            if (notToTagHeader) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            this.headerRenderer.draw(drawContext);
            if (notToTagHeader) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
        if (this.footerRenderer != null) {
            boolean notToTagFooter;
            boolean lastFooter = this.isLastRendererForModelElement && modelElement.isComplete() && !modelElement.isSkipLastFooter();
            boolean bl = notToTagFooter = drawContext.isTaggingEnabled() && !lastFooter;
            if (notToTagFooter) {
                drawContext.setTaggingEnabled(false);
                drawContext.getCanvas().openTag(new CanvasArtifact());
            }
            this.footerRenderer.draw(drawContext);
            if (notToTagFooter) {
                drawContext.getCanvas().closeTag();
                drawContext.setTaggingEnabled(true);
            }
        }
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement && !this.childRenderers.isEmpty();
        TagTreePointer tagPointer = null;
        boolean bl = shouldHaveFooterOrHeaderTag = modelElement.getHeader() != null || modelElement.getFooter() != null;
        if (isTagged) {
            PdfName role = modelElement.getRole();
            if (role != null && !PdfName.Artifact.equals(role)) {
                tagPointer = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
                boolean ignoreHeaderFooterTag = drawContext.getDocument().getTagStructureContext().getTagStructureTargetVersion().compareTo(PdfVersion.PDF_1_5) < 0;
                boolean bl2 = shouldHaveFooterOrHeaderTag = shouldHaveFooterOrHeaderTag && !ignoreHeaderFooterTag && (!modelElement.isSkipFirstHeader() || !modelElement.isSkipLastFooter());
                if (shouldHaveFooterOrHeaderTag) {
                    if (tagPointer.getKidsRoles().contains(PdfName.TBody)) {
                        tagPointer.moveToKid(PdfName.TBody);
                    } else {
                        tagPointer.addTag(PdfName.TBody);
                    }
                }
            } else {
                isTagged = false;
            }
        }
        for (IRenderer child : this.childRenderers) {
            if (isTagged) {
                int rowsNum;
                int cellRow;
                int adjustByHeaderRowsNum = 0;
                if (modelElement.getHeader() != null && !modelElement.isSkipFirstHeader() && !shouldHaveFooterOrHeaderTag) {
                    adjustByHeaderRowsNum = modelElement.getHeader().getNumberOfRows();
                }
                if ((cellRow = ((Cell)child.getModelElement()).getRow() + adjustByHeaderRowsNum) < (rowsNum = tagPointer.getKidsRoles().size())) {
                    tagPointer.moveToKid(cellRow);
                } else {
                    tagPointer.addTag(PdfName.TR);
                }
            }
            child.draw(drawContext);
            if (!isTagged) continue;
            tagPointer.moveToParent();
        }
        if (isTagged && shouldHaveFooterOrHeaderTag) {
            tagPointer.moveToParent();
        }
        this.drawBorders(drawContext, null == this.headerRenderer, null == this.footerRenderer);
    }

    @Override
    public IRenderer getNextRenderer() {
        TableRenderer nextTable = new TableRenderer();
        nextTable.modelElement = this.modelElement;
        return nextTable;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        super.move(dxRight, dyUp);
        if (this.headerRenderer != null) {
            this.headerRenderer.move(dxRight, dyUp);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.move(dxRight, dyUp);
        }
    }

    @Deprecated
    protected float[] calculateScaledColumnWidths(Table tableModel, float tableWidth) {
        return this.countedColumnWidth;
    }

    protected TableRenderer[] split(int row) {
        return this.split(row, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent) {
        return this.split(row, false, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent, boolean cellWithBigRowspanAdded) {
        int i;
        int i2;
        TableRenderer splitRenderer = this.createSplitRenderer(new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + row));
        splitRenderer.rows = this.rows.subList(0, row);
        int rowN = row;
        if (hasContent) {
            ++rowN;
        }
        splitRenderer.horizontalBorders = new ArrayList<List<Border>>();
        for (i2 = 0; i2 <= rowN; ++i2) {
            splitRenderer.horizontalBorders.add(this.horizontalBorders.get(i2));
        }
        splitRenderer.verticalBorders = new ArrayList<List<Border>>();
        for (i2 = 0; i2 < this.verticalBorders.size(); ++i2) {
            splitRenderer.verticalBorders.add(new ArrayList());
            for (int j = 0; j < (0 == rowN ? 1 : rowN); ++j) {
                if (this.verticalBorders.get(i2).size() == 0) continue;
                splitRenderer.verticalBorders.get(i2).add(this.verticalBorders.get(i2).get(j));
            }
        }
        splitRenderer.heights = this.heights;
        splitRenderer.columnWidths = this.columnWidths;
        splitRenderer.countedColumnWidth = this.countedColumnWidth;
        splitRenderer.totalWidthForColumns = this.totalWidthForColumns;
        TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
        if (0 == row && !hasContent && !cellWithBigRowspanAdded) {
            overflowRenderer.isOriginalNonSplitRenderer = true;
        }
        overflowRenderer.rows = this.rows.subList(row, this.rows.size());
        splitRenderer.occupiedArea = this.occupiedArea;
        overflowRenderer.horizontalBorders = new ArrayList<List<Border>>();
        for (i = rowN; i < this.horizontalBorders.size(); ++i) {
            overflowRenderer.horizontalBorders.add(new ArrayList(this.horizontalBorders.get(i)));
        }
        overflowRenderer.verticalBorders = new ArrayList<List<Border>>();
        for (i = 0; i < this.verticalBorders.size(); ++i) {
            overflowRenderer.verticalBorders.add(new ArrayList());
            for (int j = row; j < this.verticalBorders.get(i).size(); ++j) {
                if (this.verticalBorders.get(i).size() == 0) continue;
                overflowRenderer.verticalBorders.get(i).add(this.verticalBorders.get(i).get(j));
            }
        }
        return new TableRenderer[]{splitRenderer, overflowRenderer};
    }

    protected TableRenderer createSplitRenderer(Table.RowRange rowRange) {
        TableRenderer splitRenderer = (TableRenderer)this.getNextRenderer();
        splitRenderer.rowRange = rowRange;
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.childRenderers = this.childRenderers;
        splitRenderer.addAllProperties(this.getOwnProperties());
        splitRenderer.headerRenderer = this.headerRenderer;
        splitRenderer.footerRenderer = this.footerRenderer;
        splitRenderer.isLastRendererForModelElement = false;
        return splitRenderer;
    }

    protected TableRenderer createOverflowRenderer(Table.RowRange rowRange) {
        TableRenderer overflowRenderer = (TableRenderer)this.getNextRenderer();
        overflowRenderer.setRowRange(rowRange);
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.isOriginalNonSplitRenderer = false;
        overflowRenderer.countedColumnWidth = this.countedColumnWidth;
        overflowRenderer.leftBorderMaxWidth = this.leftBorderMaxWidth;
        overflowRenderer.rightBorderMaxWidth = this.rightBorderMaxWidth;
        return overflowRenderer;
    }

    @Override
    protected Float retrieveWidth(float parentBoxWidth) {
        Float tableWidth = super.retrieveWidth(parentBoxWidth);
        Table tableModel = (Table)this.getModelElement();
        if (tableWidth == null || tableWidth.floatValue() == 0.0f) {
            float totalColumnWidthInPercent = 0.0f;
            for (int col = 0; col < tableModel.getNumberOfColumns(); ++col) {
                UnitValue columnWidth = tableModel.getColumnWidth(col);
                if (!columnWidth.isPercentValue()) continue;
                totalColumnWidthInPercent += columnWidth.getValue();
            }
            tableWidth = Float.valueOf(parentBoxWidth);
            if (totalColumnWidthInPercent > 0.0f) {
                tableWidth = Float.valueOf(parentBoxWidth * totalColumnWidthInPercent / 100.0f);
            }
        }
        return tableWidth;
    }

    @Override
    MinMaxWidth getMinMaxWidth(float availableWidth) {
        return this.countTableMinMaxWidth(availableWidth, true, false).toTableMinMaxWidth(availableWidth);
    }

    private ColumnMinMaxWidth countTableMinMaxWidth(float availableWidth, boolean initializeBorders, boolean isTableBeingLayouted) {
        Rectangle layoutBox = new Rectangle(availableWidth, 1000000.0f);
        float tableWidth = this.retrieveWidth(layoutBox.getWidth()).floatValue();
        this.applyMargins(layoutBox, false);
        if (initializeBorders) {
            this.initializeBorders(((Table)this.getModelElement()).getLastRowBottomBorder(), true);
            this.initializeHeaderAndFooter(true);
            if (!isTableBeingLayouted) {
                this.saveCellsProperties();
            }
            this.collapseAllBorders();
        }
        ColumnMinMaxWidth footerColWidth = null;
        if (this.footerRenderer != null) {
            footerColWidth = this.footerRenderer.countRegionMinMaxWidth(availableWidth - this.leftBorderMaxWidth / 2.0f - this.rightBorderMaxWidth / 2.0f, null, null);
        }
        ColumnMinMaxWidth headerColWidth = null;
        if (this.headerRenderer != null) {
            headerColWidth = this.headerRenderer.countRegionMinMaxWidth(availableWidth - this.leftBorderMaxWidth / 2.0f - this.rightBorderMaxWidth / 2.0f, null, null);
        }
        layoutBox.applyMargins(0.0f, this.rightBorderMaxWidth / 2.0f, 0.0f, this.leftBorderMaxWidth / 2.0f, false);
        ColumnMinMaxWidth tableColWidth = this.countRegionMinMaxWidth(tableWidth -= this.rightBorderMaxWidth / 2.0f + this.leftBorderMaxWidth / 2.0f, headerColWidth, footerColWidth);
        this.countedMaxColumnWidth = tableColWidth.maxWidth;
        this.countedMinColumnWidth = tableColWidth.minWidth;
        if (initializeBorders) {
            this.footerRenderer = null;
            this.headerRenderer = null;
            this.rightBorderMaxWidth = 0.0f;
            this.leftBorderMaxWidth = 0.0f;
            this.horizontalBorders = null;
            this.verticalBorders = null;
            if (!isTableBeingLayouted) {
                this.restoreCellsProperties();
            }
            this.deleteOwnProperty(10);
            this.deleteOwnProperty(13);
        }
        return tableColWidth.setLayoutBoxWidth(layoutBox.getWidth());
    }

    private ColumnMinMaxWidth countRegionMinMaxWidth(float availableWidth, ColumnMinMaxWidth headerWidth, ColumnMinMaxWidth footerWidth) {
        int col;
        Table tableModel = (Table)this.getModelElement();
        int nrow = this.rows.size();
        int ncol = tableModel.getNumberOfColumns();
        MinMaxWidth[][] cellsMinMaxWidth = new MinMaxWidth[nrow][];
        int[][] cellsColspan = new int[nrow][];
        for (int i = 0; i < cellsMinMaxWidth.length; ++i) {
            cellsMinMaxWidth[i] = new MinMaxWidth[ncol];
            cellsColspan[i] = new int[ncol];
        }
        ColumnMinMaxWidth result = new ColumnMinMaxWidth(ncol);
        for (int row = 0; row < nrow; ++row) {
            for (int col2 = 0; col2 < ncol; ++col2) {
                CellRenderer cell = this.rows.get(row)[col2];
                if (cell == null) continue;
                cell.setParent(this);
                int colspan = cell.getPropertyAsInteger(16);
                int rowspan = cell.getPropertyAsInteger(60);
                int finishCol = col2 + colspan - 1;
                cellsMinMaxWidth[row][finishCol] = cell.getMinMaxWidth(MinMaxWidthUtils.getMax());
                cellsColspan[row][finishCol] = colspan;
                for (int i = 1; i < rowspan; ++i) {
                    cellsMinMaxWidth[row - i][finishCol] = cellsMinMaxWidth[row][finishCol];
                    cellsColspan[row - i][finishCol] = colspan;
                }
            }
        }
        float[] maxColumnsWidth = new float[ncol + 1];
        float[] minColumnsWidth = new float[ncol + 1];
        minColumnsWidth[0] = 0.0f;
        maxColumnsWidth[0] = 0.0f;
        for (col = 0; col < ncol; ++col) {
            for (int row = 0; row < nrow; ++row) {
                if (cellsMinMaxWidth[row][col] != null) {
                    int curColspan = cellsColspan[row][col];
                    maxColumnsWidth[col + 1] = Math.max(maxColumnsWidth[col + 1], cellsMinMaxWidth[row][col].getMaxWidth() + maxColumnsWidth[col - curColspan + 1]);
                    minColumnsWidth[col + 1] = Math.max(minColumnsWidth[col + 1], cellsMinMaxWidth[row][col].getMinWidth() + minColumnsWidth[col - curColspan + 1]);
                    continue;
                }
                maxColumnsWidth[col + 1] = Math.max(maxColumnsWidth[col + 1], maxColumnsWidth[col]);
                minColumnsWidth[col + 1] = Math.max(minColumnsWidth[col + 1], minColumnsWidth[col]);
            }
        }
        for (col = 0; col < ncol; ++col) {
            result.minWidth[col] = minColumnsWidth[col + 1] - minColumnsWidth[col];
            result.maxWidth[col] = maxColumnsWidth[col + 1] - maxColumnsWidth[col];
        }
        if (headerWidth != null) {
            result.mergeWith(headerWidth);
        }
        if (footerWidth != null) {
            result.mergeWith(footerWidth);
        }
        return result;
    }

    float[] getMinColumnWidth() {
        return this.countedMinColumnWidth;
    }

    float[] getMaxColumnWidth() {
        return this.countedMaxColumnWidth;
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
    }

    protected void drawBorders(DrawContext drawContext) {
        this.drawBorders(drawContext, true, true);
    }

    protected void drawBorders(DrawContext drawContext, boolean drawTop, boolean drawBottom) {
        boolean isTagged;
        CellRenderer cell;
        float height = this.occupiedArea.getBBox().getHeight();
        if (null != this.footerRenderer) {
            height -= this.footerRenderer.occupiedArea.getBBox().getHeight();
        }
        if (null != this.headerRenderer) {
            height -= this.headerRenderer.occupiedArea.getBBox().getHeight();
        }
        if (height < 1.0E-4f) {
            return;
        }
        float startX = this.getOccupiedArea().getBBox().getX();
        float startY = this.getOccupiedArea().getBBox().getY() + this.getOccupiedArea().getBBox().getHeight();
        for (IRenderer child : this.childRenderers) {
            cell = (CellRenderer)child;
            if (cell.getModelElement().getRow() != this.rowRange.getStartRow()) continue;
            startY = cell.getOccupiedArea().getBBox().getY() + cell.getOccupiedArea().getBBox().getHeight();
            break;
        }
        for (IRenderer child : this.childRenderers) {
            cell = (CellRenderer)child;
            if (cell.getModelElement().getCol() != 0) continue;
            startX = cell.getOccupiedArea().getBBox().getX();
            break;
        }
        if (this.childRenderers.size() == 0) {
            Border[] borders = this.getBorders();
            if (null != borders[3]) {
                startX += borders[3].getWidth() / 2.0f;
            }
            if (null != borders[0]) {
                startY -= borders[0].getWidth() / 2.0f;
                if (null != borders[2] && 0 == this.heights.size()) {
                    this.heights.add(0, Float.valueOf(borders[0].getWidth() / 2.0f + borders[2].getWidth() / 2.0f));
                }
            } else if (null != borders[2]) {
                startY -= borders[2].getWidth() / 2.0f;
            }
        }
        boolean bl = isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        if (isTagged) {
            drawContext.getCanvas().openTag(new CanvasArtifact());
        }
        if (drawTop) {
            this.drawHorizontalBorder(0, startX, startY, drawContext.getCanvas());
        }
        float y1 = startY;
        if (this.heights.size() > 0) {
            y1 -= this.heights.get(0).floatValue();
        }
        for (int i = 1; i < this.horizontalBorders.size() - 1; ++i) {
            this.drawHorizontalBorder(i, startX, y1, drawContext.getCanvas());
            if (i >= this.heights.size()) continue;
            y1 -= this.heights.get(i).floatValue();
        }
        float x1 = startX;
        if (this.countedColumnWidth.length > 0) {
            x1 += this.countedColumnWidth[0];
        }
        for (int i = 1; i < this.verticalBorders.size() - 1; ++i) {
            this.drawVerticalBorder(i, startY, x1, drawContext.getCanvas());
            if (i >= this.countedColumnWidth.length) continue;
            x1 += this.countedColumnWidth[i];
        }
        if (drawTop) {
            this.drawHorizontalBorder(0, startX, startY, drawContext.getCanvas());
        }
        if (drawBottom) {
            this.drawHorizontalBorder(this.horizontalBorders.size() - 1, startX, y1, drawContext.getCanvas());
        }
        this.drawVerticalBorder(0, startY, startX, drawContext.getCanvas());
        this.drawVerticalBorder(this.verticalBorders.size() - 1, startY, x1, drawContext.getCanvas());
        if (isTagged) {
            drawContext.getCanvas().closeTag();
        }
    }

    private void drawHorizontalBorder(int i, float startX, float y1, PdfCanvas canvas) {
        Border lastBorder;
        int j;
        Border firstBorder;
        List<Border> borders = this.horizontalBorders.get(i);
        float x1 = startX;
        float x2 = x1 + this.countedColumnWidth[0];
        if (i == 0) {
            if (this.verticalBorders != null && this.verticalBorders.size() > 0 && this.verticalBorders.get(0).size() > 0 && this.verticalBorders.get(this.verticalBorders.size() - 1).size() > 0 && (firstBorder = this.verticalBorders.get(0).get(0)) != null) {
                x1 -= firstBorder.getWidth() / 2.0f;
            }
        } else if (i == this.horizontalBorders.size() - 1 && this.verticalBorders != null && this.verticalBorders.size() > 0 && this.verticalBorders.get(0).size() > 0 && this.verticalBorders.get(this.verticalBorders.size() - 1) != null && this.verticalBorders.get(this.verticalBorders.size() - 1).size() > 0 && this.verticalBorders.get(0) != null && (firstBorder = this.verticalBorders.get(0).get(this.verticalBorders.get(0).size() - 1)) != null) {
            x1 -= firstBorder.getWidth() / 2.0f;
        }
        for (j = 1; j < borders.size(); ++j) {
            Border prevBorder = borders.get(j - 1);
            Border curBorder = borders.get(j);
            if (prevBorder != null) {
                if (!prevBorder.equals(curBorder)) {
                    prevBorder.drawCellBorder(canvas, x1, y1, x2, y1);
                    x1 = x2;
                }
            } else {
                x2 = x1 += this.countedColumnWidth[j - 1];
            }
            if (curBorder == null) continue;
            x2 += this.countedColumnWidth[j];
        }
        Border border = lastBorder = borders.size() > j - 1 ? borders.get(j - 1) : null;
        if (lastBorder != null) {
            if (this.verticalBorders != null && this.verticalBorders.size() > j && this.verticalBorders.get(j) != null && this.verticalBorders.get(j).size() > 0) {
                if (i == 0) {
                    if (this.verticalBorders.get(j).get(i) != null) {
                        x2 += this.verticalBorders.get(j).get(i).getWidth() / 2.0f;
                    }
                } else if (i == this.horizontalBorders.size() - 1 && this.verticalBorders.get(j).size() >= i - 1 && this.verticalBorders.get(j).get(i - 1) != null) {
                    x2 += this.verticalBorders.get(j).get(i - 1).getWidth() / 2.0f;
                }
            }
            lastBorder.drawCellBorder(canvas, x1, y1, x2, y1);
        }
    }

    private void drawVerticalBorder(int i, float startY, float x1, PdfCanvas canvas) {
        int j;
        float y1;
        List<Border> borders = this.verticalBorders.get(i);
        float y2 = y1 = startY;
        if (!this.heights.isEmpty()) {
            y2 = y1 - this.heights.get(0).floatValue();
        }
        for (j = 1; j < borders.size(); ++j) {
            Border prevBorder = borders.get(j - 1);
            Border curBorder = borders.get(j);
            if (prevBorder != null) {
                if (!prevBorder.equals(curBorder)) {
                    prevBorder.drawCellBorder(canvas, x1, y1, x1, y2);
                    y1 = y2;
                }
            } else {
                y2 = y1 -= this.heights.get(j - 1).floatValue();
            }
            if (curBorder == null) continue;
            y2 -= this.heights.get(j).floatValue();
        }
        if (borders.size() == 0) {
            return;
        }
        Border lastBorder = borders.get(j - 1);
        if (lastBorder != null) {
            lastBorder.drawCellBorder(canvas, x1, y1, x1, y2);
        }
    }

    private void adjustFooterAndFixOccupiedArea(Rectangle layoutBox) {
        if (this.footerRenderer != null) {
            this.footerRenderer.move(0.0f, layoutBox.getHeight());
            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
            this.occupiedArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
        }
    }

    private void updateFirstRowBorders(int colN) {
        int col = 0;
        int row = 0;
        List<Border> topBorders = this.horizontalBorders.get(0);
        topBorders.clear();
        while (col < colN) {
            if (null != this.rows.get(row)[col]) {
                Border collapsedBottomBorder = null;
                int colspan = this.rows.get(row)[col].getPropertyAsInteger(16);
                for (int i = col; i < col + colspan; ++i) {
                    topBorders.add(this.rows.get(row)[col].getBorders()[0]);
                    collapsedBottomBorder = this.getCollapsedBorder(collapsedBottomBorder, this.horizontalBorders.get(row + 1).get(i));
                }
                this.rows.get(row)[col].setBorders(collapsedBottomBorder, 2);
                col += colspan;
                row = 0;
                continue;
            }
            if (0 == row) {
                this.horizontalBorders.get(1).set(col, Border.NO_BORDER);
            }
            if (++row != this.rows.size()) continue;
            break;
        }
    }

    private void correctFirstRowTopBorders(Border tableBorder, int colN) {
        int col;
        ArrayList<Border> bordersToBeCollapsedWith;
        int row = 0;
        List<Border> topBorders = this.horizontalBorders.get(0);
        List<Border> list = bordersToBeCollapsedWith = null != this.headerRenderer ? this.headerRenderer.horizontalBorders.get(this.headerRenderer.horizontalBorders.size() - 1) : new ArrayList<Border>();
        if (null == this.headerRenderer) {
            for (col = 0; col < colN; ++col) {
                bordersToBeCollapsedWith.add(tableBorder);
            }
        }
        col = 0;
        while (col < colN) {
            if (null != this.rows.get(row)[col] && row + 1 <= this.rows.get(row)[col].getPropertyAsInteger(60)) {
                Border oldTopBorder = this.rows.get(row)[col].getBorders()[0];
                Border resultCellTopBorder = null;
                Border collapsedBorder = null;
                int colspan = this.rows.get(row)[col].getPropertyAsInteger(16);
                for (int i = col; i < col + colspan; ++i) {
                    collapsedBorder = this.getCollapsedBorder(oldTopBorder, (Border)bordersToBeCollapsedWith.get(i));
                    if (null == topBorders.get(i) || null != collapsedBorder && topBorders.get(i).getWidth() < collapsedBorder.getWidth()) {
                        topBorders.set(i, collapsedBorder);
                    }
                    if (null != resultCellTopBorder && (null == collapsedBorder || !(resultCellTopBorder.getWidth() < collapsedBorder.getWidth()))) continue;
                    resultCellTopBorder = collapsedBorder;
                }
                this.rows.get(row)[col].setBorders(resultCellTopBorder, 0);
                col += colspan;
                row = 0;
                continue;
            }
            if (++row != this.rows.size()) continue;
        }
        if (null != this.headerRenderer) {
            this.headerRenderer.horizontalBorders.set(this.headerRenderer.horizontalBorders.size() - 1, topBorders);
        }
    }

    private void collapseAllBordersAndEmptyRows(Border[] tableBorders, int startRow, int finishRow, int colN) {
        int[] rowsToDelete = new int[colN];
        for (int row = startRow; row <= finishRow; ++row) {
            CellRenderer[] currentRow = this.rows.get(row);
            boolean hasCells = false;
            for (int col = 0; col < colN; ++col) {
                if (null != currentRow[col]) {
                    int colspan = currentRow[col].getPropertyAsInteger(16);
                    this.prepareBuildingBordersArrays(currentRow[col], tableBorders, colN, row, col);
                    this.buildBordersArrays(currentRow[col], row, col);
                    hasCells = true;
                    if (rowsToDelete[col] > 0) {
                        int rowspan = currentRow[col].getPropertyAsInteger(60) - rowsToDelete[col];
                        if (rowspan < 1) {
                            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                            logger.warn("Unexpected behaviour during table row collapsing. Calculated rowspan was less then 1.");
                            rowspan = 1;
                        }
                        currentRow[col].setProperty(60, rowspan);
                    }
                    for (int i = 0; i < colspan; ++i) {
                        rowsToDelete[col + i] = 0;
                    }
                    col += colspan - 1;
                    continue;
                }
                if (this.horizontalBorders.get(row).size() > col) continue;
                this.horizontalBorders.get(row).add(null);
            }
            if (hasCells) continue;
            this.rows.remove(currentRow);
            --row;
            --finishRow;
            int i = 0;
            while (i < colN) {
                int n = i++;
                rowsToDelete[n] = rowsToDelete[n] + 1;
            }
            if (row != finishRow) continue;
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.warn("Last row is not completed. Table bottom border may collapse as you do not expect it");
        }
    }

    private void initializeBorders(List<Border> lastFlushedRowBottomBorder, boolean isFirstOnPage) {
        if (null == this.horizontalBorders) {
            this.horizontalBorders = new ArrayList<List<Border>>();
            this.horizontalBorders.add(new ArrayList<Border>(lastFlushedRowBottomBorder));
            this.verticalBorders = new ArrayList<List<Border>>();
        }
        if (0 != lastFlushedRowBottomBorder.size() && isFirstOnPage) {
            this.horizontalBorders.get(0).clear();
        }
    }

    private float getMaxTopWidth(Border tableTopBorder) {
        float width = null == tableTopBorder ? 0.0f : tableTopBorder.getWidth();
        List<Border> topBorders = this.horizontalBorders.get(0);
        if (0 != topBorders.size()) {
            for (Border border : topBorders) {
                if (null == border || !(border.getWidth() > width)) continue;
                width = border.getWidth();
            }
        }
        return width;
    }

    private float getMaxRightWidth(Border tableRightBorder) {
        List<Border> rightBorders;
        float width;
        float f = width = null == tableRightBorder ? 0.0f : tableRightBorder.getWidth();
        if (0 != this.verticalBorders.size() && 0 != (rightBorders = this.verticalBorders.get(this.verticalBorders.size() - 1)).size()) {
            for (Border border : rightBorders) {
                if (null == border || !(border.getWidth() > width)) continue;
                width = border.getWidth();
            }
        }
        return width;
    }

    private float getMaxLeftWidth(Border tableLeftBorder) {
        List<Border> leftBorders;
        float width;
        float f = width = null == tableLeftBorder ? 0.0f : tableLeftBorder.getWidth();
        if (0 != this.verticalBorders.size() && 0 != (leftBorders = this.verticalBorders.get(0)).size()) {
            for (Border border : leftBorders) {
                if (null == border || !(border.getWidth() > width)) continue;
                width = border.getWidth();
            }
        }
        return width;
    }

    private boolean[] collapseFooterBorders(List<Border> tableBottomBorders, int colNum, int rowNum) {
        boolean[] useFooterBorders = new boolean[colNum];
        int row = 0;
        int col = 0;
        while (col < colNum) {
            if (null != this.footerRenderer.rows.get(row)[col]) {
                Border oldBorder;
                Border maxBorder = oldBorder = this.footerRenderer.rows.get(row)[col].getBorders()[0];
                for (int k = col; k < col + this.footerRenderer.rows.get(row)[col].getModelElement().getColspan(); ++k) {
                    Border collapsedBorder = tableBottomBorders.get(k);
                    if (null != collapsedBorder && (null == oldBorder || collapsedBorder.getWidth() >= oldBorder.getWidth())) {
                        if (null != maxBorder && !(maxBorder.getWidth() < collapsedBorder.getWidth())) continue;
                        maxBorder = collapsedBorder;
                        continue;
                    }
                    useFooterBorders[k] = true;
                }
                this.footerRenderer.rows.get(row)[col].setBorders(maxBorder, 0);
                col += this.footerRenderer.rows.get(row)[col].getModelElement().getColspan();
                row = 0;
                continue;
            }
            if (++row != rowNum) continue;
            break;
        }
        return useFooterBorders;
    }

    private void fixFooterBorders(List<Border> tableBottomBorders, int colNum, int rowNum, boolean[] useFooterBorders) {
        int j = 0;
        int i = 0;
        while (i < colNum) {
            if (null != this.footerRenderer.rows.get(j)[i]) {
                for (int k = i; k < i + this.footerRenderer.rows.get(j)[i].getModelElement().getColspan(); ++k) {
                    if (useFooterBorders[k]) continue;
                    this.footerRenderer.horizontalBorders.get(j).set(k, tableBottomBorders.get(k));
                }
                i += this.footerRenderer.rows.get(j)[i].getModelElement().getColspan();
                j = 0;
                continue;
            }
            if (++j != rowNum) continue;
            break;
        }
    }

    private void correctCellsOccupiedAreas(LayoutResult[] splits, int row, int[] targetOverflowRowIndex, Float blockMinHeight, Rectangle layoutBox, float bottomTableBorderWidth, boolean isLastRenderer) {
        float additionalCellHeight = 0.0f;
        if (isLastRenderer && null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight() + bottomTableBorderWidth / 2.0f) {
            additionalCellHeight = Math.min(layoutBox.getHeight() - bottomTableBorderWidth / 2.0f, blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() - bottomTableBorderWidth / 2.0f) / (float)this.heights.size();
            for (int i = 0; i < this.heights.size(); ++i) {
                this.heights.set(i, Float.valueOf(this.heights.get(i).floatValue() + additionalCellHeight));
            }
        }
        float cumulativeShift = 0.0f;
        for (int k = 0; k < this.heights.size(); ++k) {
            CellRenderer[] currentRow = this.rows.get(k);
            for (int col = 0; col < currentRow.length; ++col) {
                CellRenderer cell;
                CellRenderer cellRenderer = cell = k < row || null == splits[col] ? currentRow[col] : (CellRenderer)splits[col].getSplitRenderer();
                if (cell == null) continue;
                float height = 0.0f;
                int rowspan = cell.getPropertyAsInteger(60);
                for (int l = k; l > (k == row + 1 ? targetOverflowRowIndex[col] : k) - rowspan && l >= 0; --l) {
                    height += this.heights.get(l).floatValue();
                }
                float shift = height - cell.getOccupiedArea().getBBox().getHeight();
                Rectangle bBox = cell.getOccupiedArea().getBBox();
                bBox.moveDown(shift);
                bBox.setHeight(height);
                cell.move(0.0f, -(cumulativeShift - (float)(rowspan - 1) * additionalCellHeight));
                cell.applyVerticalAlignment();
            }
            cumulativeShift += additionalCellHeight;
        }
        this.occupiedArea.getBBox().moveDown(cumulativeShift).increaseHeight(cumulativeShift);
        layoutBox.decreaseHeight(cumulativeShift);
    }

    private void prepareBuildingBordersArrays(CellRenderer cell, Border[] tableBorders, int colNum, int row, int col) {
        Border[] cellBorders = cell.getBorders();
        int colspan = cell.getPropertyAsInteger(16);
        if (0 == col) {
            cell.setProperty(11, this.getCollapsedBorder(cellBorders[3], tableBorders[3]));
        }
        if (colNum == col + colspan) {
            cell.setProperty(12, this.getCollapsedBorder(cellBorders[1], tableBorders[1]));
        }
    }

    private void buildBordersArrays(CellRenderer cell, int row, int col) {
        CellRenderer nextCell;
        int nextCellRow;
        int j;
        if (row > this.horizontalBorders.size()) {
            --row;
        }
        int currCellColspan = cell.getPropertyAsInteger(16);
        if (col != 0 && null == this.rows.get(row)[col - 1]) {
            j = col;
            do {
                --j;
                for (nextCellRow = row; this.rows.size() != nextCellRow && null == this.rows.get(nextCellRow)[j]; ++nextCellRow) {
                }
            } while (j > 0 && this.rows.size() != nextCellRow && (j + this.rows.get(nextCellRow)[j].getPropertyAsInteger(16) != col || nextCellRow - this.rows.get(nextCellRow)[j].getPropertyAsInteger(60) + 1 != row));
            if (j >= 0 && nextCellRow != this.rows.size()) {
                nextCell = this.rows.get(nextCellRow)[j];
                this.buildBordersArrays(nextCell, nextCellRow, true);
            }
        }
        for (j = 0; j < currCellColspan; j += nextCell.getPropertyAsInteger(16).intValue()) {
            for (nextCellRow = row + 1; nextCellRow < this.rows.size() && null == this.rows.get(nextCellRow)[col + j]; ++nextCellRow) {
            }
            if (nextCellRow == this.rows.size()) break;
            nextCell = this.rows.get(nextCellRow)[col + j];
            if (row != nextCellRow - nextCell.getPropertyAsInteger(60)) continue;
            this.buildBordersArrays(nextCell, nextCellRow, true);
        }
        if (col + currCellColspan < this.rows.get(row).length) {
            for (nextCellRow = row; nextCellRow < this.rows.size() && null == this.rows.get(nextCellRow)[col + currCellColspan]; ++nextCellRow) {
            }
            if (nextCellRow != this.rows.size()) {
                nextCell = this.rows.get(nextCellRow)[col + currCellColspan];
                this.buildBordersArrays(nextCell, nextCellRow, true);
            }
        }
        this.buildBordersArrays(cell, row, false);
    }

    private void buildBordersArrays(CellRenderer cell, int row, boolean isNeighbourCell) {
        int i;
        int colspan = cell.getPropertyAsInteger(16);
        int rowspan = cell.getPropertyAsInteger(60);
        int colN = cell.getModelElement().getCol();
        Border[] cellBorders = cell.getBorders();
        if (row + 1 - rowspan < 0) {
            rowspan = row + 1;
        }
        for (i = 0; i < colspan; ++i) {
            if (this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1 - rowspan, colN + i, cellBorders[0], false) || isNeighbourCell) continue;
            cell.setBorders(this.horizontalBorders.get(row + 1 - rowspan).get(colN + i), 0);
        }
        for (i = 0; i < colspan; ++i) {
            if (this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1, colN + i, cellBorders[2], true) || isNeighbourCell) continue;
            cell.setBorders(this.horizontalBorders.get(row + 1).get(colN + i), 2);
        }
        if (rowspan > 1) {
            int numOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
            for (int k = row - rowspan + 1; k <= row; ++k) {
                List<Border> borders = this.horizontalBorders.get(k);
                if (borders.size() >= numOfColumns) continue;
                for (int j = borders.size(); j < numOfColumns; ++j) {
                    borders.add(null);
                }
            }
        }
        for (int j = row - rowspan + 1; j <= row; ++j) {
            if (this.checkAndReplaceBorderInArray(this.verticalBorders, colN, j, cellBorders[3], false) || isNeighbourCell) continue;
            cell.setBorders(this.verticalBorders.get(colN).get(j), 3);
        }
        for (i = row - rowspan + 1; i <= row; ++i) {
            if (this.checkAndReplaceBorderInArray(this.verticalBorders, colN + colspan, i, cellBorders[1], true) || isNeighbourCell) continue;
            cell.setBorders(this.verticalBorders.get(colN + colspan).get(i), 1);
        }
        if (colspan > 1) {
            for (int k = colN; k <= colspan + colN; ++k) {
                List<Border> borders = this.verticalBorders.get(k);
                if (borders.size() >= row + rowspan) continue;
                for (int l = borders.size(); l < row + rowspan; ++l) {
                    borders.add(null);
                }
            }
        }
    }

    private Border getCollapsedBorder(Border cellBorder, Border tableBorder) {
        if (null != tableBorder && (null == cellBorder || cellBorder.getWidth() < tableBorder.getWidth())) {
            return tableBorder;
        }
        if (null != cellBorder) {
            return cellBorder;
        }
        return Border.NO_BORDER;
    }

    private boolean checkAndReplaceBorderInArray(List<List<Border>> borderArray, int i, int j, Border borderToAdd, boolean hasPriority) {
        Border neighbour;
        List<Border> borders;
        if (borderArray.size() <= i) {
            for (int count = borderArray.size(); count <= i; ++count) {
                borderArray.add(new ArrayList());
            }
        }
        if ((borders = borderArray.get(i)).isEmpty()) {
            for (int count = 0; count < j; ++count) {
                borders.add(null);
            }
            borders.add(borderToAdd);
            return true;
        }
        if (borders.size() == j) {
            borders.add(borderToAdd);
            return true;
        }
        if (borders.size() < j) {
            for (int count = borders.size(); count <= j; ++count) {
                borders.add(count, null);
            }
        }
        if ((neighbour = borders.get(j)) == null) {
            borders.set(j, borderToAdd);
            return true;
        }
        if (neighbour != borderToAdd && borderToAdd != null && neighbour.getWidth() <= borderToAdd.getWidth()) {
            if (!hasPriority && neighbour.getWidth() == borderToAdd.getWidth()) {
                return false;
            }
            borders.set(j, borderToAdd);
            return true;
        }
        return false;
    }

    protected void extendLastRow(CellRenderer[] lastRow, Rectangle freeBox) {
        if (null != lastRow && 0 != this.heights.size()) {
            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + freeBox.getHeight()));
            this.occupiedArea.getBBox().moveDown(freeBox.getHeight()).increaseHeight(freeBox.getHeight());
            for (CellRenderer cell : lastRow) {
                if (null == cell) continue;
                cell.occupiedArea.getBBox().moveDown(freeBox.getHeight()).increaseHeight(freeBox.getHeight());
            }
            freeBox.moveUp(freeBox.getHeight()).setHeight(0.0f);
        }
    }

    private void setRowRange(Table.RowRange rowRange) {
        this.rowRange = rowRange;
        for (int row = rowRange.getStartRow(); row <= rowRange.getFinishRow(); ++row) {
            this.rows.add(new CellRenderer[((Table)this.modelElement).getNumberOfColumns()]);
        }
    }

    private TableRenderer initFooterOrHeaderRenderer(boolean footer, Border[] tableBorders) {
        Table table = (Table)this.getModelElement();
        Table footerOrHeader = footer ? table.getFooter() : table.getHeader();
        int innerBorder = footer ? 0 : 2;
        int outerBorder = footer ? 2 : 0;
        TableRenderer renderer = (TableRenderer)footerOrHeader.createRendererSubTree().setParent(this);
        Border[] borders = renderer.getBorders();
        if (table.isEmpty()) {
            renderer.setBorders(this.getCollapsedBorder(borders[innerBorder], tableBorders[innerBorder]), innerBorder);
            this.setBorders(Border.NO_BORDER, innerBorder);
        }
        renderer.setBorders(this.getCollapsedBorder(borders[1], tableBorders[1]), 1);
        renderer.setBorders(this.getCollapsedBorder(borders[3], tableBorders[3]), 3);
        renderer.setBorders(this.getCollapsedBorder(borders[outerBorder], tableBorders[outerBorder]), outerBorder);
        this.setBorders(Border.NO_BORDER, outerBorder);
        return renderer;
    }

    private TableRenderer prepareFooterOrHeaderRendererForLayout(TableRenderer renderer, float layoutBoxWidth) {
        renderer.countedColumnWidth = this.countedColumnWidth;
        renderer.leftBorderMaxWidth = this.leftBorderMaxWidth;
        renderer.rightBorderMaxWidth = this.rightBorderMaxWidth;
        if (this.hasProperty(77)) {
            renderer.setProperty(77, UnitValue.createPointValue(layoutBoxWidth));
        }
        return this;
    }

    private TableRenderer processRendererBorders(int numberOfColumns) {
        this.initializeBorders(new ArrayList<Border>(), true);
        this.collapseAllBordersAndEmptyRows(this.getBorders(), this.rowRange.getStartRow(), this.rowRange.getFinishRow(), numberOfColumns);
        return this;
    }

    private boolean isHeaderRenderer() {
        return this.parent instanceof TableRenderer && ((TableRenderer)this.parent).headerRenderer == this;
    }

    private boolean isFooterRenderer() {
        return this.parent instanceof TableRenderer && ((TableRenderer)this.parent).footerRenderer == this;
    }

    private float calculateColumnWidths(float availableWidth, boolean calculateTableMaxWidth) {
        if (this.countedColumnWidth == null || this.totalWidthForColumns != availableWidth) {
            TableWidths tableWidths = new TableWidths(this, availableWidth, calculateTableMaxWidth, this.rightBorderMaxWidth, this.leftBorderMaxWidth);
            if (tableWidths.hasFixedLayout()) {
                this.countedColumnWidth = tableWidths.fixedLayout();
                return tableWidths.getMinWidth();
            }
            ColumnMinMaxWidth minMax = this.countTableMinMaxWidth(availableWidth, false, true);
            this.countedColumnWidth = tableWidths.autoLayout(minMax.getMinWidths(), minMax.getMaxWidths());
            return tableWidths.getMinWidth();
        }
        return -1.0f;
    }

    private float getTableWidth() {
        float sum = 0.0f;
        for (float column : this.countedColumnWidth) {
            sum += column;
        }
        return sum + this.rightBorderMaxWidth / 2.0f + this.leftBorderMaxWidth / 2.0f;
    }

    protected TableRenderer saveCellsProperties() {
        int colN = ((Table)this.getModelElement()).getNumberOfColumns();
        for (int row = 0; row < this.rows.size(); ++row) {
            CellRenderer[] currentRow = this.rows.get(row);
            for (int col = 0; col < colN; ++col) {
                if (null == currentRow[col]) continue;
                currentRow[col].saveProperties();
            }
        }
        return this;
    }

    protected TableRenderer restoreCellsProperties() {
        int colN = ((Table)this.getModelElement()).getNumberOfColumns();
        for (int row = 0; row < this.rows.size(); ++row) {
            CellRenderer[] currentRow = this.rows.get(row);
            for (int col = 0; col < colN; ++col) {
                if (null == currentRow[col]) continue;
                currentRow[col].restoreProperties();
            }
        }
        return this;
    }

    private static class ColumnMinMaxWidth {
        float[] minWidth;
        float[] maxWidth;
        private float layoutBoxWidth;

        float[] getMinWidths() {
            return this.minWidth;
        }

        float[] getMaxWidths() {
            return this.maxWidth;
        }

        ColumnMinMaxWidth(int ncol) {
            this.minWidth = new float[ncol];
            this.maxWidth = new float[ncol];
        }

        void mergeWith(ColumnMinMaxWidth other) {
            int n = Math.min(this.minWidth.length, other.minWidth.length);
            for (int i = 0; i < n; ++i) {
                this.minWidth[i] = Math.max(this.minWidth[i], other.minWidth[i]);
                this.maxWidth[i] = Math.max(this.maxWidth[i], other.maxWidth[i]);
            }
        }

        MinMaxWidth toTableMinMaxWidth(float availableWidth) {
            float additionalWidth = availableWidth - this.layoutBoxWidth;
            float minColTotalWidth = 0.0f;
            float maxColTotalWidth = 0.0f;
            for (int i = 0; i < this.minWidth.length; ++i) {
                minColTotalWidth += this.minWidth[i];
                maxColTotalWidth += this.maxWidth[i];
            }
            return new MinMaxWidth(additionalWidth, availableWidth, minColTotalWidth, maxColTotalWidth);
        }

        ColumnMinMaxWidth setLayoutBoxWidth(float width) {
            this.layoutBoxWidth = width;
            return this;
        }
    }

    private static class CellRendererInfo {
        public CellRenderer cellRenderer;
        public int column;
        public int finishRowInd;

        public CellRendererInfo(CellRenderer cellRenderer, int column, int finishRow) {
            this.cellRenderer = cellRenderer;
            this.column = column;
            this.finishRowInd = finishRow;
        }
    }
}

