/*
 * Decompiled with CFR 0.152.
 */
package com.stpass.fill_pdf_utf8;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.stpass.fill_pdf_utf8.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;

public class FillPdfForm {
    private Config config;
    private Map<String, String> paraMap;

    public FillPdfForm() {
    }

    public FillPdfForm(Config config, Map<String, String> paraMap) {
        this.config = config;
        this.paraMap = paraMap;
    }

    public void xfdfFillPdf() throws IOException {
        this.execute(this.config.getPdfInputStream(), this.config.getPdfOutputStream(), this.config.getFontPath(), this.paraMap);
    }

    public void execute(String template, String output, String fontPath, Map<String, String> paraMap) throws Exception {
        PdfDocument pdfDoc = new PdfDocument(new PdfReader(template), new PdfWriter(output));
        PdfFont pdfFont = PdfFontFactory.createFont(fontPath, "Identity-H", false);
        this.generatorFillForm(pdfDoc, pdfFont, paraMap);
    }

    public void execute(InputStream template, OutputStream output, String fontPath, Map<String, String> paraMap) throws IOException {
        PdfDocument pdfDoc = new PdfDocument(new PdfReader(template), new PdfWriter(output));
        PdfFont pdfFont = PdfFontFactory.createFont(fontPath, "Identity-H", false);
        this.generatorFillForm(pdfDoc, pdfFont, paraMap);
    }

    public void generatorFillForm(PdfDocument pdfDoc, PdfFont pdfFont, Map<String, String> paraMap) {
        PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
        Set<String> fields = paraMap.keySet();
        Map<String, PdfFormField> map = form.getFormFields();
        for (String key : map.keySet()) {
            PdfFormField field = form.getField(key);
            PdfName type = field.getFormType();
            if (PdfName.Btn.equals(type)) {
                if (fields.contains(key)) {
                    if ("On".equals(paraMap.get(key))) {
                        field.setCheckType(1);
                        field.regenerateField();
                        continue;
                    }
                    if (!"Off".equals(paraMap.get(key))) continue;
                    field.setCheckType(3);
                    field.regenerateField();
                    continue;
                }
                if (key.startsWith("On")) {
                    if (key.endsWith(".1") || field.getDefaultValue() != null) continue;
                    field.setCheckType(1);
                    field.regenerateField();
                    continue;
                }
                if (!key.startsWith("Off") || key.endsWith(".1")) continue;
                field.setCheckType(3);
                field.regenerateField();
                continue;
            }
            if (!fields.contains(key)) continue;
            field.setValue(paraMap.get(key), pdfFont, this.config.getFontSize().floatValue());
        }
        form.flattenFields();
        pdfDoc.close();
    }
}

