/*
 * Decompiled with CFR 0.152.
 */
package com.stpass.fill_pdf_utf8;

import com.itext5.xfdfReader.XfdfReader;
import com.stpass.fill_pdf_utf8.Config;
import com.stpass.fill_pdf_utf8.FillPdfForm;
import java.io.FileInputStream;
import java.util.HashMap;

public class Main {
    public static void main(String[] args) {
        try {
            Config config = Main.parseArgs(args);
            XfdfReader xfdf = new XfdfReader(config.getFormInputStream());
            HashMap<String, String> xMap = xfdf.getFields();
            FillPdfForm fillPdfForm = new FillPdfForm(config, xMap);
            fillPdfForm.xfdfFillPdf();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("See README for more information.");
            System.exit(1);
        }
    }

    private static Config parseArgs(String[] args) throws Exception {
        if (args.length == 0) {
            throw new RuntimeException("Missing arguments.");
        }
        Config config = new Config();
        config.setPdfInputStream(new FileInputStream(args[0]));
        config.setPdfOutputStream(System.out);
        config.setFormInputStream(null);
        config.setStampFilename("");
        config.setBackgroundFilename("");
        config.setFlatten(false);
        for (int i = 1; i < args.length; ++i) {
            if ("stamp".equals(args[i])) {
                config.setStampFilename(args[++i]);
                continue;
            }
            if ("background".equals(args[i])) {
                config.setBackgroundFilename(args[++i]);
                continue;
            }
            if ("fontPath".equals(args[i])) {
                config.setFontPath(args[++i]);
                continue;
            }
            if ("fontSize".equals(args[i])) {
                config.setFontSize(Float.valueOf(args[++i]));
                continue;
            }
            if ("fill_form".equals(args[i])) {
                config.setFormInputStream(System.in);
                if ("-".equals(args[++i])) continue;
                throw new RuntimeException("Missing \"-\" after fill_form operation.");
            }
            if ("output".equals(args[i])) {
                if ("-".equals(args[++i])) continue;
                throw new RuntimeException("Missing \"-\" after output operation.");
            }
            if ("flatten".equals(args[i])) {
                config.setFlatten(true);
                continue;
            }
            throw new RuntimeException("Unknown operation: " + args[i]);
        }
        return config;
    }
}

