/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationListener;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class TldConfig
implements LifecycleListener {
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static volatile Set<String> noTldJars = null;
    private static final Log log = LogFactory.getLog(TldConfig.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private static Digester[] tldDigesters = new Digester[2];
    private Context context = null;
    private Digester tldDigester = null;
    private Set<String> taglibUris = new HashSet<String>();
    private Set<String> webxmlTaglibUris = new HashSet<String>();
    private ArrayList<String> listeners = new ArrayList();

    private static Digester createTldDigester(boolean validation, boolean blockExternal) {
        Digester digester = null;
        if (!validation) {
            if (tldDigesters[0] == null) {
                TldConfig.tldDigesters[0] = DigesterFactory.newDigester(validation, true, new TldRuleSet(), blockExternal);
                tldDigesters[0].getParser();
            }
            digester = tldDigesters[0];
        } else {
            if (tldDigesters[1] == null) {
                TldConfig.tldDigesters[1] = DigesterFactory.newDigester(validation, true, new TldRuleSet(), blockExternal);
                tldDigesters[1].getParser();
            }
            digester = tldDigesters[1];
        }
        return digester;
    }

    public static synchronized void setNoTldJars(String jarNames) {
        if (jarNames == null) {
            noTldJars = null;
        } else {
            if (noTldJars == null) {
                noTldJars = new HashSet<String>();
            } else {
                noTldJars.clear();
            }
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public void addTaglibUri(String uri) {
        this.taglibUris.add(uri);
    }

    public boolean isKnownTaglibUri(String uri) {
        return this.taglibUris.contains(uri);
    }

    public boolean isKnownWebxmlTaglibUri(String uri) {
        return this.webxmlTaglibUris.contains(uri);
    }

    @Deprecated
    public Context getContext() {
        return this.context;
    }

    @Deprecated
    public void setContext(Context context) {
        this.context = context;
    }

    public void addApplicationListener(String s) {
        if (log.isDebugEnabled()) {
            log.debug("Add tld listener " + s);
        }
        this.listeners.add(s);
    }

    public String[] getTldListeners() {
        String[] result = new String[this.listeners.size()];
        this.listeners.toArray(result);
        return result;
    }

    public void execute() {
        long t1 = System.currentTimeMillis();
        this.tldScanWebXml();
        this.tldScanResourcePaths(WEB_INF);
        JarScanner jarScanner = this.context.getJarScanner();
        jarScanner.scan(this.context.getServletContext(), this.context.getLoader().getClassLoader(), new TldJarScannerCallback(), noTldJars);
        String[] list = this.getTldListeners();
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("tldConfig.addListeners", list.length));
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            this.context.addApplicationListener(new ApplicationListener(list[i], true));
        }
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setTldScanTime(t2 - t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanWebXml() {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("tldConfig.webxmlStart"));
        }
        Collection<TaglibDescriptor> descriptors = this.context.getJspConfigDescriptor().getTaglibs();
        for (TaglibDescriptor descriptor : descriptors) {
            String resourcePath = descriptor.getTaglibLocation();
            if (!resourcePath.startsWith("/")) {
                resourcePath = WEB_INF + resourcePath;
            }
            if (this.taglibUris.contains(descriptor.getTaglibURI())) {
                log.warn(sm.getString("tldConfig.webxmlSkip", resourcePath, descriptor.getTaglibURI()));
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace(sm.getString("tldConfig.webxmlAdd", resourcePath, descriptor.getTaglibURI()));
            }
            InputStream stream = null;
            try {
                stream = this.context.getServletContext().getResourceAsStream(resourcePath);
                if (stream != null) {
                    XmlErrorHandler handler = this.tldScanStream(stream);
                    handler.logFindings(log, resourcePath);
                    this.taglibUris.add(descriptor.getTaglibURI());
                    this.webxmlTaglibUris.add(descriptor.getTaglibURI());
                    continue;
                }
                log.warn(sm.getString("tldConfig.webxmlFailPathDoesNotExist", resourcePath, descriptor.getTaglibURI()));
            }
            catch (IOException ioe) {
                log.warn(sm.getString("tldConfig.webxmlFail", resourcePath, descriptor.getTaglibURI()), ioe);
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanResourcePaths(String startPath) {
        ServletContext ctxt;
        Set<String> dirList;
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("tldConfig.webinfScan", startPath));
        }
        if ((dirList = (ctxt = this.context.getServletContext()).getResourcePaths(startPath)) != null) {
            for (String path : dirList) {
                if (!path.endsWith(TLD_EXT) && (path.startsWith(WEB_INF_LIB) || path.startsWith("/WEB-INF/classes/"))) continue;
                if (path.endsWith(TLD_EXT)) {
                    if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) continue;
                    InputStream stream = ctxt.getResourceAsStream(path);
                    try {
                        XmlErrorHandler handler = this.tldScanStream(stream);
                        handler.logFindings(log, path);
                        continue;
                    }
                    catch (IOException ioe) {
                        log.warn(sm.getString("tldConfig.webinfFail", path), ioe);
                        continue;
                    }
                    finally {
                        if (stream == null) continue;
                        try {
                            stream.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                        continue;
                    }
                }
                this.tldScanResourcePaths(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanDir(File start) {
        File[] fileList;
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("tldConfig.dirScan", start.getAbsolutePath()));
        }
        if ((fileList = start.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    this.tldScanDir(fileList[i]);
                    continue;
                }
                if (!fileList[i].getAbsolutePath().endsWith(TLD_EXT)) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(fileList[i]);
                    XmlErrorHandler handler = this.tldScanStream(stream);
                    handler.logFindings(log, fileList[i].getAbsolutePath());
                    continue;
                }
                catch (IOException ioe) {
                    log.warn(sm.getString("tldConfig.dirFail", fileList[i].getAbsolutePath()), ioe);
                    continue;
                }
                finally {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tldScanJar(JarURLConnection jarConn) {
        Jar jar = null;
        try {
            jar = JarFactory.newInstance(jarConn.getURL());
            jar.nextEntry();
            String entryName = jar.getEntryName();
            while (entryName != null) {
                if (entryName.startsWith("META-INF/") && entryName.endsWith(TLD_EXT)) {
                    InputStream is = null;
                    try {
                        is = jar.getEntryInputStream();
                        XmlErrorHandler handler = this.tldScanStream(is);
                        handler.logFindings(log, jarConn.getURL() + entryName);
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
                jar.nextEntry();
                entryName = jar.getEntryName();
            }
        }
        catch (IOException ioe) {
            log.warn(sm.getString("tldConfig.jarFail", jarConn.getURL()), ioe);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlErrorHandler tldScanStream(InputStream resourceStream) throws IOException {
        InputSource source = new InputSource(resourceStream);
        XmlErrorHandler result = new XmlErrorHandler();
        Digester digester = this.tldDigester;
        synchronized (digester) {
            try {
                this.tldDigester.setErrorHandler(result);
                this.tldDigester.push(this);
                this.tldDigester.parse(source);
            }
            catch (SAXException s) {
                throw new IOException(s);
            }
            finally {
                this.tldDigester.reset();
            }
            return result;
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)event.getLifecycle();
        }
        catch (ClassCastException e) {
            log.error(sm.getString("tldConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("after_init")) {
            this.init();
        } else if (event.getType().equals("configure_start")) {
            try {
                this.execute();
            }
            catch (Exception e) {
                log.error(sm.getString("tldConfig.execute", this.context.getName()), e);
            }
        } else if (event.getType().equals("stop")) {
            this.taglibUris.clear();
            this.webxmlTaglibUris.clear();
            this.listeners.clear();
        }
    }

    private void init() {
        if (this.tldDigester == null) {
            this.tldDigester = TldConfig.createTldDigester(this.context.getTldValidation(), this.context.getXmlBlockExternal());
        }
    }

    static {
        StringBuilder jarList = new StringBuilder(System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip", ""));
        String tldJars = System.getProperty("org.apache.catalina.startup.TldConfig.jarsToSkip", "");
        if (tldJars.length() > 0) {
            if (jarList.length() > 0) {
                jarList.append(',');
            }
            jarList.append(tldJars);
        }
        if (jarList.length() > 0) {
            TldConfig.setNoTldJars(jarList.toString());
        }
    }

    private class TldJarScannerCallback
    implements JarScannerCallback {
        private TldJarScannerCallback() {
        }

        @Override
        public void scan(JarURLConnection urlConn) throws IOException {
            TldConfig.this.tldScanJar(urlConn);
        }

        @Override
        public void scan(File file) {
            File metaInf = new File(file, "META-INF");
            if (metaInf.isDirectory()) {
                TldConfig.this.tldScanDir(metaInf);
            }
        }
    }
}

