/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.Adapter;
import org.apache.coyote.Processor;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.servlet31.WebConnection;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote");
    private static final AtomicInteger nameCounter = new AtomicInteger(0);
    protected ObjectName rgOname = null;
    protected ObjectName tpOname = null;
    private int nameIndex = 0;
    protected AbstractEndpoint endpoint = null;
    protected Adapter adapter;
    protected int processorCache = 200;
    protected String clientCertProvider = null;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public boolean setProperty(String name, String value) {
        return this.endpoint.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.endpoint.getProperty(name);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public boolean isAprRequired() {
        return false;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getMaxConnections() {
        return this.endpoint.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) {
        this.endpoint.setMaxConnections(maxConnections);
    }

    public int getMinSpareThreads() {
        return this.endpoint.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.endpoint.setMinSpareThreads(minSpareThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.endpoint.setKeepAliveTimeout(keepAliveTimeout);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public int getLocalPort() {
        return this.endpoint.getLocalPort();
    }

    public int getConnectionTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setConnectionTimeout(int timeout) {
        this.endpoint.setSoTimeout(timeout);
    }

    public int getSoTimeout() {
        return this.getConnectionTimeout();
    }

    public void setSoTimeout(int timeout) {
        this.setConnectionTimeout(timeout);
    }

    public int getMaxHeaderCount() {
        return this.endpoint.getMaxHeaderCount();
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.endpoint.setMaxHeaderCount(maxHeaderCount);
    }

    public long getConnectionCount() {
        return this.endpoint.getConnectionCount();
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = nameCounter.incrementAndGet();
        }
        return this.nameIndex;
    }

    public String getName() {
        int port;
        StringBuilder name = new StringBuilder(this.getNamePrefix());
        name.append('-');
        if (this.getAddress() != null) {
            name.append(this.getAddress().getHostAddress());
            name.append('-');
        }
        if ((port = this.getPort()) == 0) {
            name.append("auto-");
            name.append(this.getNameIndex());
            port = this.getLocalPort();
            if (port != -1) {
                name.append('-');
                name.append(port);
            }
        } else {
            name.append(port);
        }
        return ObjectName.quote(name.toString());
    }

    protected abstract Log getLog();

    protected abstract String getNamePrefix();

    protected abstract String getProtocolName();

    protected abstract AbstractEndpoint.Handler getHandler();

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private ObjectName createObjectName() throws MalformedObjectNameException {
        this.domain = this.adapter.getDomain();
        if (this.domain == null) {
            return null;
        }
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(":type=ProtocolHandler,port=");
        int port = this.getPort();
        if (port > 0) {
            name.append(this.getPort());
        } else {
            name.append("auto-");
            name.append(this.getNameIndex());
        }
        InetAddress address = this.getAddress();
        if (address != null) {
            name.append(",address=");
            name.append(ObjectName.quote(address.getHostAddress()));
        }
        return new ObjectName(name.toString());
    }

    @Override
    public void init() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.init", this.getName()));
        }
        if (this.oname == null) {
            this.oname = this.createObjectName();
            if (this.oname != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
        }
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                this.getLog().error(sm.getString("abstractProtocolHandler.mbeanRegistrationFailed", this.tpOname, this.getName()), e);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent(this.getHandler().getGlobal(), this.rgOname, null);
        }
        String endpointName = this.getName();
        this.endpoint.setName(endpointName.substring(1, endpointName.length() - 1));
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.initError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.start", this.getName()));
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.startError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void pause() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.pause", this.getName()));
        }
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.pauseError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void resume() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.resume", this.getName()));
        }
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.resumeError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.stop", this.getName()));
        }
        try {
            this.endpoint.stop();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.stopError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void destroy() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.destroy", this.getName()));
        }
        try {
            this.endpoint.destroy();
        }
        catch (Exception e) {
            this.getLog().error(sm.getString("abstractProtocolHandler.destroyError", this.getName()), e);
        }
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    protected static class RecycledProcessors<P extends Processor<S>, S>
    extends ConcurrentLinkedQueue<Processor<S>> {
        private static final long serialVersionUID = 1L;
        private transient AbstractConnectionHandler<S, P> handler;
        protected AtomicInteger size = new AtomicInteger(0);

        public RecycledProcessors(AbstractConnectionHandler<S, P> handler) {
            this.handler = handler;
        }

        @Override
        public boolean offer(Processor<S> processor) {
            int cacheSize = this.handler.getProtocol().getProcessorCache();
            boolean offer = cacheSize == -1 ? true : this.size.get() < cacheSize;
            boolean result = false;
            if (offer && (result = super.offer(processor))) {
                this.size.incrementAndGet();
            }
            if (!result) {
                this.handler.unregister(processor);
            }
            return result;
        }

        @Override
        public Processor<S> poll() {
            Processor result = (Processor)super.poll();
            if (result != null) {
                this.size.decrementAndGet();
            }
            return result;
        }

        @Override
        public void clear() {
            Object next = this.poll();
            while (next != null) {
                this.handler.unregister((Processor<S>)next);
                next = this.poll();
            }
            super.clear();
            this.size.set(0);
        }
    }

    protected static abstract class AbstractConnectionHandler<S, P extends Processor<S>>
    implements AbstractEndpoint.Handler {
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected ConcurrentHashMap<S, Processor<S>> connections = new ConcurrentHashMap();
        protected RecycledProcessors<P, S> recycledProcessors = new RecycledProcessors(this);

        protected AbstractConnectionHandler() {
        }

        protected abstract Log getLog();

        protected abstract AbstractProtocol getProtocol();

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> wrapper, SocketStatus status) {
            if (wrapper == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            S socket = wrapper.getSocket();
            if (socket == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            Processor<S> processor = this.connections.get(socket);
            if (status == SocketStatus.DISCONNECT && processor == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            wrapper.setAsync(false);
            try {
                if (processor == null) {
                    processor = this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                this.initSsl(wrapper, processor);
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
                do {
                    if (status != SocketStatus.DISCONNECT || processor.isComet()) {
                        state = processor.isAsync() || state == AbstractEndpoint.Handler.SocketState.ASYNC_END ? processor.asyncDispatch(status) : (processor.isComet() ? processor.event(status) : (processor.getUpgradeInbound() != null ? processor.upgradeDispatch() : (processor.isUpgrade() ? processor.upgradeDispatch(status) : processor.process(wrapper))));
                    }
                    if (state != AbstractEndpoint.Handler.SocketState.CLOSED && processor.isAsync()) {
                        state = processor.asyncPostProcess();
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                        HttpUpgradeHandler httpUpgradeHandler = processor.getHttpUpgradeHandler();
                        this.release(wrapper, processor, false, false);
                        processor = this.createUpgradeProcessor(wrapper, httpUpgradeHandler);
                        wrapper.setUpgraded(true);
                        this.connections.put(socket, processor);
                        httpUpgradeHandler.init((WebConnection)((Object)processor));
                    } else if (state == AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT) {
                        UpgradeInbound inbound = processor.getUpgradeInbound();
                        this.release(wrapper, processor, false, false);
                        processor = this.createUpgradeProcessor(wrapper, inbound);
                        inbound.onUpgradeComplete();
                    }
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug("Socket: [" + wrapper + "], Status in: [" + (Object)((Object)status) + "], State out: [" + (Object)((Object)state) + "]");
                } while (state == AbstractEndpoint.Handler.SocketState.ASYNC_END || state == AbstractEndpoint.Handler.SocketState.UPGRADING || state == AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    this.longPoll(wrapper, processor);
                } else if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                    this.connections.remove(socket);
                    this.release(wrapper, processor, false, true);
                } else if (state == AbstractEndpoint.Handler.SocketState.SENDFILE) {
                    this.connections.remove(socket);
                    this.release(wrapper, processor, false, false);
                } else if (state == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                    this.connections.put(socket, processor);
                    if (status != SocketStatus.OPEN_WRITE) {
                        this.longPoll(wrapper, processor);
                    }
                } else {
                    this.connections.remove(socket);
                    if (processor.isUpgrade()) {
                        processor.getHttpUpgradeHandler().destroy();
                    } else if (!(processor instanceof UpgradeProcessor)) {
                        this.release(wrapper, processor, true, false);
                    }
                }
                return state;
            }
            catch (SocketException e) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.socketexception.debug"), e);
            }
            catch (IOException e) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.ioexception.debug"), e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                this.getLog().error(sm.getString("abstractConnectionHandler.error"), e);
            }
            this.connections.remove(socket);
            if (!(processor instanceof UpgradeProcessor) && !processor.isUpgrade()) {
                this.release(wrapper, processor, true, false);
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected abstract P createProcessor();

        protected abstract void initSsl(SocketWrapper<S> var1, Processor<S> var2);

        protected abstract void longPoll(SocketWrapper<S> var1, Processor<S> var2);

        protected abstract void release(SocketWrapper<S> var1, Processor<S> var2, boolean var3, boolean var4);

        @Deprecated
        protected abstract Processor<S> createUpgradeProcessor(SocketWrapper<S> var1, UpgradeInbound var2) throws IOException;

        protected abstract Processor<S> createUpgradeProcessor(SocketWrapper<S> var1, HttpUpgradeHandler var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AbstractProcessor<S> processor) {
            if (this.getProtocol().getDomain() != null) {
                AbstractConnectionHandler abstractConnectionHandler = this;
                synchronized (abstractConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.getProtocol().getDomain() + ":type=RequestProcessor,worker=" + this.getProtocol().getName() + ",name=" + this.getProtocol().getProtocolName() + "Request" + count);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug("Register " + rpName);
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        this.getLog().warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Processor<S> processor) {
            if (this.getProtocol().getDomain() != null) {
                AbstractConnectionHandler abstractConnectionHandler = this;
                synchronized (abstractConnectionHandler) {
                    try {
                        Request r = processor.getRequest();
                        if (r == null) {
                            return;
                        }
                        RequestInfo rp = r.getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug("Unregister " + rpName);
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        this.getLog().warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

