/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public class WebXml {
    private static final String FILE_PROTOCOL = "file:";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private final Log log = LogFactory.getLog(WebXml.class);
    private InputStream stream;
    private InputSource source;
    private String systemId;

    public WebXml(ServletContext ctxt) throws IOException {
        String altDDName;
        String webXml = (String)ctxt.getAttribute("org.apache.tomcat.util.scan.MergedWebXml");
        if (webXml != null) {
            this.source = new InputSource(new StringReader(webXml));
            this.systemId = "org.apache.tomcat.util.scan.MergedWebXml";
        }
        if (this.source == null && (altDDName = (String)ctxt.getAttribute(Constants.ALT_DD_ATTR)) != null) {
            try {
                URL uri = new URL(FILE_PROTOCOL + altDDName.replace('\\', '/'));
                this.stream = uri.openStream();
                this.source = new InputSource(this.stream);
                this.systemId = uri.toExternalForm();
            }
            catch (MalformedURLException e) {
                this.log.warn(Localizer.getMessage("jsp.error.internal.filenotfound", altDDName));
            }
        }
        if (this.source == null) {
            URL uri = ctxt.getResource(WEB_XML);
            if (uri == null) {
                this.log.warn(Localizer.getMessage("jsp.error.internal.filenotfound", WEB_XML));
            } else {
                this.stream = uri.openStream();
                this.source = new InputSource(this.stream);
                this.systemId = uri.toExternalForm();
            }
        }
        if (this.source == null) {
            this.systemId = null;
        } else {
            this.source.setSystemId(this.systemId);
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public InputSource getInputSource() {
        return this.source;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                this.log.error(Localizer.getMessage("jsp.error.stream.close.failed"));
            }
        }
    }
}

