/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tomcat.util.bcel.classfile.Constant;
import org.apache.tomcat.util.bcel.classfile.Utility;

public final class ConstantUtf8
extends Constant {
    private static final long serialVersionUID = 8119001312020421976L;
    private final String bytes;
    private static final int MAX_CACHE_ENTRIES = 20000;
    private static final int INITIAL_CACHE_CAPACITY = 26666;
    private static HashMap<String, ConstantUtf8> cache;

    private static synchronized ConstantUtf8 getCachedInstance(String s) {
        ConstantUtf8 result;
        if (s.length() > 200) {
            return new ConstantUtf8(s);
        }
        if (cache == null) {
            cache = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, ConstantUtf8> eldest) {
                    return this.size() > 20000;
                }
            };
        }
        if ((result = cache.get(s)) != null) {
            return result;
        }
        result = new ConstantUtf8(s);
        cache.put(s, result);
        return result;
    }

    private static ConstantUtf8 getInstance(String s) {
        return ConstantUtf8.getCachedInstance(s);
    }

    static ConstantUtf8 getInstance(DataInputStream file) throws IOException {
        return ConstantUtf8.getInstance(file.readUTF());
    }

    ConstantUtf8(DataInput file) throws IOException {
        super((byte)1);
        this.bytes = file.readUTF();
    }

    private ConstantUtf8(String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
    }

    public final String getBytes() {
        return this.bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }
}

