/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea;

import android.content.Context;
import android.content.SharedPreferences;
import com.cogknit.fovea.Fovea;
import com.cogknit.fovea.FoveaCallback;
import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.providers.FoveaAppInvitee;
import com.cogknit.fovea.providers.FoveaAppInvitesManager;
import com.cogknit.fovea.providers.FoveaSynchronizationManager;
import com.cogknit.fovea.providers.FoveaUserProfileManager;
import com.cogknit.fovea.receivers.BootEventReceiver;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.remote.FoveaResponse;
import java.util.List;

class FoveaManager {
    private static String AppKey;
    private static String ClientKey;
    private Context context;
    private String TAG = "FoveaRequestResponseManager";

    public FoveaManager(String appKey, String clientKey, Context inContext) {
        this.context = inContext;
        AppKey = appKey;
        ClientKey = clientKey;
    }

    void initialize(Context inContext, FoveaCallback callback) {
        this.context = inContext;
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        settings.edit().putString("appKey", AppKey).commit();
        settings.edit().putString("clientKey", ClientKey).commit();
        Boolean isSDKAuthorized = settings.getBoolean("isSDKAuthorized", false);
        if (!isSDKAuthorized.booleanValue()) {
            settings.edit().putString("Fovea_userID", APIConstants.DefaultFoveaID).commit();
        }
        if (APIConstants.getAPIClientURL(inContext) == null) {
            FoveaSynchronizationManager synchronizationManager = new FoveaSynchronizationManager();
            synchronizationManager.performClientConfigSynchronization(this.context);
        }
        this.authorizeSDK(this.context, AppKey, ClientKey, callback);
    }

    private void authorizeSDK(Context contxt, String appKey, String clientKey, final FoveaCallback callback) {
        FoveaRequestResponseManager manager = new FoveaRequestResponseManager(this.context);
        manager.sendAuthorizationRequest(appKey, clientKey, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                SharedPreferences settings = FoveaManager.this.context.getSharedPreferences("FoveaPrefsFile", 0);
                settings.edit().putBoolean("isSDKAuthorized", true).commit();
                Boolean hasPendingUPSync = settings.getBoolean("hasPendingUPSync", false);
                if (hasPendingUPSync.booleanValue()) {
                    FoveaUserProfileManager userProfileManager = new FoveaUserProfileManager();
                    userProfileManager.performUserProfileSynchronization(FoveaManager.this.context);
                }
                callback.onCompletion();
                FoveaManager.this.startContextMining(FoveaManager.this.context);
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                callback.onFailure(error);
            }
        });
    }

    void setUserProfileDetails(FoveaUserProfile userProfile) {
        FoveaUserProfileManager userProfileManager = new FoveaUserProfileManager();
        userProfileManager.setUserProfile(userProfile, this.context);
    }

    void setFbAccessToken(String token) {
        SharedPreferences.Editor editor = this.context.getSharedPreferences("FbPrefsFile", 0).edit();
        editor.putString("access_token", token).apply();
    }

    List<FoveaAppInvitee> getAppInvitees() throws Fovea.UninitializedException {
        FoveaAppInvitesManager appInvitesManager = new FoveaAppInvitesManager();
        return appInvitesManager.getAppInvitees(this.context);
    }

    void feedbackOnAppInvites(List<FoveaAppInvitee> approvedInvites, List<FoveaAppInvitee> declinedInvites, String inviteMessage) throws Fovea.UninitializedException, Fovea.AppInviteException {
        SharedPreferences settings = this.context.getSharedPreferences("FoveaPrefsFile", 0);
        Boolean hasAuthenticated = settings.getBoolean("isSDKAuthorized", false);
        if (!hasAuthenticated.booleanValue()) {
            throw new Fovea.UninitializedException();
        }
        FoveaAppInvitesManager appInvitesManager = new FoveaAppInvitesManager();
        appInvitesManager.feedbackOnAppInvites(approvedInvites, declinedInvites, inviteMessage, this.context);
    }

    private void startContextMining(Context context) {
        BootEventReceiver.initialize(context);
    }
}

