/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.dataModel;

import android.content.ContentValues;
import org.json.JSONException;
import org.json.JSONObject;

public class Person {
    private String name;
    private String phoneNumber;
    private long duration;
    private long frequency;
    private String timestamp;
    private String contactURI;
    private transient String foveaUserID;
    private Double weight;

    public Person(String name, String phoneNumber, long duration, long frequency, Double weight, String contactURI, String timeframe, String foveaUserID) {
        this.name = name;
        this.phoneNumber = phoneNumber;
        this.duration = duration;
        this.frequency = frequency;
        this.timestamp = timeframe;
        this.contactURI = contactURI;
        this.foveaUserID = foveaUserID;
        this.weight = weight;
    }

    public Person(String name, String phoneNumber, long duration, long frequency, Double weight, String timeframe, String foveaUserID) {
        this.name = name;
        this.phoneNumber = phoneNumber;
        this.duration = duration;
        this.frequency = frequency;
        this.timestamp = timeframe;
        this.foveaUserID = foveaUserID;
        this.weight = weight;
    }

    public ContentValues getContentValues() {
        ContentValues values = new ContentValues();
        values.put("name", this.name);
        values.put("number", this.phoneNumber);
        values.put("duration", Long.valueOf(this.duration));
        values.put("frequency", Long.valueOf(this.frequency));
        values.put("weight", this.weight);
        values.put("timeframe", this.timestamp);
        values.put("contact_uri", this.contactURI);
        values.put("foveaUserID", this.foveaUserID);
        return values;
    }

    public void addDuration(long d) {
        this.duration += d;
    }

    public void addFrequency(int f) {
        this.frequency += (long)f;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isNameKnown() {
        return this.name != null && this.name != "" && !this.name.contains("Unknown");
    }

    public JSONObject getJSONObject() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("name", (Object)this.name);
            obj.put("phoneNumber", (Object)this.phoneNumber);
            obj.put("duration", this.duration);
            obj.put("frequency", this.frequency);
            obj.put("timeframe", (Object)this.timestamp.substring(1));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public double getWeight() {
        return this.weight;
    }
}

