/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.providers;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import com.cogknit.fovea.Fovea;
import com.cogknit.fovea.providers.AppInvite;
import com.cogknit.fovea.providers.FoveaAppInvitee;
import com.cogknit.fovea.providers.FoveaDataFetchHelper;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.ArrayList;
import java.util.List;

public class FoveaAppInvitesManager {
    private static final int INVITEE_COUNT = 5;
    private boolean wait = false;
    private final String SENT = "SMS_SENT";
    private BroadcastReceiver receiver = null;
    private static final String TAG = "FoveaAppInvites";

    public List<FoveaAppInvitee> getAppInvitees(Context context) throws Fovea.UninitializedException {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        Boolean hasAuthenticated = settings.getBoolean("isSDKAuthorized", false);
        if (!hasAuthenticated.booleanValue()) {
            throw new Fovea.UninitializedException();
        }
        String userID = settings.getString("Fovea_userID", "");
        FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);
        List<FoveaAppInvitee> invitees = helper.getAppInvites(userID, 5);
        return invitees;
    }

    public void feedbackOnAppInvites(List<FoveaAppInvitee> approvedInvitees, List<FoveaAppInvitee> declinedInvitees, String inviteMessage, Context context) throws Fovea.AppInviteException {
        ArrayList parts = SmsManager.getDefault().divideMessage(inviteMessage);
        if (parts.size() > 1) {
            throw new Fovea.AppInviteException("Input message is too long, it should not be exceeding 140 character limit");
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm.getPhoneType() == 0) {
            throw new Fovea.AppInviteException("Telephony services are not enabled on this device");
        }
        this.sendAppInviteMessages(approvedInvitees, inviteMessage, context);
        this.saveDeniedInvites(declinedInvitees, context);
    }

    private void sendSMS(final FoveaAppInvitee invitee, SmsManager sms, String message, final Context context, final SMSCallback callback) {
        FoveaLog.v(TAG, "SMS sending " + invitee.getInviteeName());
        String SENT = "SMS_SENT";
        String DELIVERED = "SMS_DELIVERED";
        PendingIntent sentPI = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(SENT), (int)0);
        PendingIntent deliveredPI = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(DELIVERED), (int)0);
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                switch (this.getResultCode()) {
                    case -1: {
                        FoveaLog.v(FoveaAppInvitesManager.TAG, "SMS sent");
                        FoveaAppInvitesManager.this.wait = false;
                        callback.sentSuccessfully(invitee);
                        break;
                    }
                    case 1: {
                        FoveaLog.v(FoveaAppInvitesManager.TAG, "Generic failure");
                        callback.messageFailure(new Exception("Generic failure"));
                        break;
                    }
                    case 4: {
                        FoveaLog.v(FoveaAppInvitesManager.TAG, "No service");
                        callback.messageFailure(new Exception("No service"));
                        break;
                    }
                    case 3: {
                        FoveaLog.v(FoveaAppInvitesManager.TAG, "Null PDU");
                        callback.messageFailure(new Exception("Null PDU"));
                        break;
                    }
                    case 2: {
                        FoveaLog.v(FoveaAppInvitesManager.TAG, "Radio off");
                        callback.messageFailure(new Exception("Radio off"));
                    }
                }
                context.unregisterReceiver((BroadcastReceiver)this);
            }
        }, new IntentFilter(SENT));
        sms.sendTextMessage(invitee.getInviteePhoneNumber(), null, message, sentPI, null);
    }

    private void saveDeniedInvites(List<FoveaAppInvitee> deniedInvitees, Context context) {
        if (deniedInvitees == null || deniedInvitees.isEmpty()) {
            return;
        }
        FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);
        for (FoveaAppInvitee invitee : deniedInvitees) {
            FoveaLog.v(TAG, "SMS denied to number" + invitee.getInviteeName());
            helper.updateInviteesStatusWithDetails(invitee.getInviteeName(), invitee.getInviteePhoneNumber(), AppInvite.InviteStatus.InviteDeniedByuser);
        }
    }

    private void sendAppInviteMessages(List<FoveaAppInvitee> invitees, String message, Context context) {
        if (invitees == null || invitees.isEmpty()) {
            return;
        }
        final FoveaDataFetchHelper helper = new FoveaDataFetchHelper(context);
        this.registerReceivers(context, new SMSCallback(){

            @Override
            public void sentSuccessfully(FoveaAppInvitee invited) {
                AppInvite appInviteObj = (AppInvite)invited;
                appInviteObj.setStatus(AppInvite.InviteStatus.Invited);
                FoveaLog.v(FoveaAppInvitesManager.TAG, "SMS sent to number" + invited.getInviteeName());
                helper.updateInviteesStatus(appInviteObj);
            }

            @Override
            public void sentSuccessfullyToContactWithDetails(String phoneNumber, String name) {
                helper.updateInviteesStatusWithDetails(name, phoneNumber, AppInvite.InviteStatus.Invited);
            }

            @Override
            public void messageFailure(Exception exception) {
                FoveaLog.v(FoveaAppInvitesManager.TAG, "SMS could not be sent for reason:" + exception.getLocalizedMessage());
            }
        });
        SMSAsyncTask runner = new SMSAsyncTask(context, message);
        runner.execute(new List[]{invitees});
    }

    void registerReceivers(Context context, final SMSCallback callback) {
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context c, Intent in) {
                    switch (this.getResultCode()) {
                        case -1: {
                            Bundle bundle = in.getExtras();
                            FoveaLog.v(FoveaAppInvitesManager.TAG, "SMS sent to name: " + bundle.getString("InviteeName") + " Number:" + bundle.getString("InviteePh"));
                            callback.sentSuccessfullyToContactWithDetails(bundle.getString("InviteePh"), bundle.getString("InviteeName"));
                            FoveaAppInvitesManager.this.wait = false;
                            break;
                        }
                        case 1: {
                            FoveaLog.v(FoveaAppInvitesManager.TAG, "Generic failure");
                            callback.messageFailure(new Exception("Generic failure"));
                            break;
                        }
                        case 4: {
                            FoveaLog.v(FoveaAppInvitesManager.TAG, "No service");
                            callback.messageFailure(new Exception("No service"));
                            break;
                        }
                        case 3: {
                            FoveaLog.v(FoveaAppInvitesManager.TAG, "Null PDU");
                            callback.messageFailure(new Exception("Null PDU"));
                            break;
                        }
                        case 2: {
                            FoveaLog.v(FoveaAppInvitesManager.TAG, "Radio off");
                            callback.messageFailure(new Exception("Radio off"));
                        }
                    }
                }
            };
        }
        context.registerReceiver(this.receiver, new IntentFilter("SMS_SENT"));
    }

    void unregisterReceivers(Context inContext) {
        FoveaLog.v(TAG, "unregisterReceivers");
        inContext.unregisterReceiver(this.receiver);
    }

    class SMSAsyncTask
    extends AsyncTask<List<FoveaAppInvitee>, Integer, Void> {
        private Context context;
        private String message;

        public SMSAsyncTask(Context inContext, String inMessage) {
            this.context = inContext;
            this.message = inMessage;
        }

        protected void onPreExecute() {
        }

        protected Void doInBackground(List<FoveaAppInvitee> ... params) {
            FoveaLog.v(FoveaAppInvitesManager.TAG, "Sending invitations...");
            SmsManager smsManager = SmsManager.getDefault();
            List<FoveaAppInvitee> approvedInvitees = params[0];
            int i = 0;
            for (FoveaAppInvitee invitee : approvedInvitees) {
                FoveaAppInvitesManager.this.wait = true;
                String name = invitee.getInviteeName();
                String number = invitee.getInviteePhoneNumber();
                FoveaLog.v(FoveaAppInvitesManager.TAG, "SMS sending to name:" + name + " number: " + number);
                Intent sentIn = new Intent("SMS_SENT");
                sentIn.putExtra("InviteeName", name);
                sentIn.putExtra("InviteePh", number);
                PendingIntent sentPIn = PendingIntent.getBroadcast((Context)this.context, (int)i, (Intent)sentIn, (int)0x10000000);
                smsManager.sendTextMessage(number, null, this.message, sentPIn, null);
                ++i;
                try {
                    FoveaLog.v(FoveaAppInvitesManager.TAG, "SMS waiting");
                    while (FoveaAppInvitesManager.this.wait) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                }
            }
            FoveaLog.v(FoveaAppInvitesManager.TAG, "Async task returning");
            return null;
        }

        protected void onProgressUpdate(Integer ... values) {
        }

        protected void onPostExecute(Void v) {
            FoveaLog.v(FoveaAppInvitesManager.TAG, "Async task onPostExecute");
            FoveaAppInvitesManager.this.unregisterReceivers(this.context);
        }
    }

    static interface SMSCallback {
        public void sentSuccessfully(FoveaAppInvitee var1);

        public void sentSuccessfullyToContactWithDetails(String var1, String var2);

        public void messageFailure(Exception var1);
    }
}

