/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.providers;

import android.content.Context;
import android.content.SharedPreferences;
import com.cogknit.fovea.providers.AppInvite;
import com.cogknit.fovea.providers.DeviceUserDetails;
import com.cogknit.fovea.providers.FoveaDataFetchHelper;
import com.cogknit.fovea.receivers.BootEventReceiver;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.remote.FoveaResponse;
import com.cogknit.fovea.utils.FoveaLog;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class FoveaSynchronizationManager {
    private String TAG = "FoveaSynchronizationManager";
    static boolean first = true;

    public void performClientConfigSynchronization(Context context) {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        String appkey = settings.getString("appKey", "");
        FoveaLog.v(this.TAG, "Syncing client configuration..." + appkey);
        APIConstants.initializeWithDefaultAPIBaserURL(context);
    }

    public void performDeviceDetailsSynchronization(final Context context) {
        FoveaLog.v(this.TAG, "Syncing the device user details");
        FoveaRequestResponseManager reqManager = new FoveaRequestResponseManager(context);
        DeviceUserDetails deviceUserDetails = new DeviceUserDetails(context);
        ArrayList<DeviceUserDetails> detailsList = new ArrayList<DeviceUserDetails>();
        detailsList.add(deviceUserDetails);
        reqManager.sendDeviceUserDetailsRequest(detailsList, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
                settings.edit().putBoolean("hasSyncedDeviceUserDetails", true).commit();
                BootEventReceiver.disarmAlarm(context, "com.cogknit.goglocallibrary.actions.deviceUser.sync");
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
            }
        });
    }

    public void performDataSynchronization(final Context context) {
        FoveaLog.v(this.TAG, "Syncing...");
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        settings.edit().putBoolean("hasPendingContextDataSync", true).commit();
        final FoveaRequestResponseManager reqManager = new FoveaRequestResponseManager(context);
        final FoveaDataFetchHelper dataHelper = new FoveaDataFetchHelper(context);
        final String userID = settings.getString("Fovea_userID", "");
        this.syncAppContextData(reqManager, dataHelper, userID, new FoveaCompletionListener(){

            @Override
            public void onCompletion() {
                FoveaSynchronizationManager.this.syncPeopleContextData(reqManager, dataHelper, userID, new FoveaCompletionListener(){

                    @Override
                    public void onCompletion() {
                        FoveaSynchronizationManager.this.syncAppInvitesData(reqManager, dataHelper, userID, new FoveaCompletionListener(){

                            @Override
                            public void onCompletion() {
                                FoveaSynchronizationManager.this.syncSMSContextData(reqManager, dataHelper, userID, new FoveaCompletionListener(){

                                    @Override
                                    public void onCompletion() {
                                        FoveaSynchronizationManager.this.syncHistoryContextData(reqManager, dataHelper, userID, new FoveaCompletionListener(){

                                            @Override
                                            public void onCompletion() {
                                                FoveaSynchronizationManager.this.syncLocationContextData(reqManager, dataHelper, userID, new FoveaCompletionListener(){

                                                    @Override
                                                    public void onCompletion() {
                                                        FoveaLog.v(FoveaSynchronizationManager.this.TAG, "Done for now");
                                                        SharedPreferences setting = context.getSharedPreferences("FoveaPrefsFile", 0);
                                                        setting.edit().putBoolean("hasPendingContextDataSync", false).commit();
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    void syncAppContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List apps = dataHelper.getAppsData(forUserID);
        if (apps.isEmpty()) {
            FoveaLog.v(this.TAG, "No app records to send out");
            listener.onCompletion();
            return;
        }
        String url = "apps";
        reqManager.submitContextData(url, apps, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                dataHelper.purgeAppsData(forUserID);
                listener.onCompletion();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                listener.onCompletion();
            }
        });
    }

    void syncPeopleContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List people = dataHelper.getPeopleData(forUserID);
        if (people.isEmpty()) {
            FoveaLog.v(this.TAG, "No people records to send out");
            listener.onCompletion();
            return;
        }
        String url = "people";
        reqManager.submitContextData(url, people, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                dataHelper.purgePeopleData(forUserID);
                listener.onCompletion();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                listener.onCompletion();
            }
        });
    }

    void syncSMSContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List people = dataHelper.getSmsData(forUserID);
        if (people.isEmpty()) {
            FoveaLog.v(this.TAG, "No SMS records to send out");
            listener.onCompletion();
            return;
        }
        String url = "textMessages";
        reqManager.submitContextData(url, people, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                dataHelper.purgeSmsData(forUserID);
                listener.onCompletion();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                listener.onCompletion();
            }
        });
    }

    void syncHistoryContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List people = dataHelper.getHistoryData(forUserID);
        if (people.isEmpty()) {
            FoveaLog.v(this.TAG, "No History records to send out");
            listener.onCompletion();
            return;
        }
        String url = "browserHistory";
        reqManager.submitContextData(url, people, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                dataHelper.purgeHistoryData(forUserID);
                listener.onCompletion();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                listener.onCompletion();
            }
        });
    }

    void syncLocationContextData(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List userLocations = dataHelper.getLocationsData(forUserID);
        if (userLocations.isEmpty()) {
            FoveaLog.v(this.TAG, "No Location records to send out");
            listener.onCompletion();
            return;
        }
        String url = "locations";
        reqManager.submitContextData(url, userLocations, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                dataHelper.purgeLocationsData(forUserID);
                listener.onCompletion();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                listener.onCompletion();
            }
        });
    }

    void syncAppInvitesData(final FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, final String forUserID, final FoveaCompletionListener listener) {
        List<AppInvite> invites = dataHelper.getAppInvitesPendingSubmission(forUserID);
        if (!invites.isEmpty()) {
            String url = "appInviteStatus";
            reqManager.submitInvitesContextData(url, invites, new FoveaResponse.FoveaResponseListener(){

                @Override
                public void onSuccessResponse() {
                    FoveaSynchronizationManager.this.syncInfluenceGraph(reqManager, dataHelper, forUserID, new FoveaCompletionListener(){

                        @Override
                        public void onCompletion() {
                            listener.onCompletion();
                        }
                    });
                }
            }, new FoveaResponse.FoveaErrorListener(){

                @Override
                public void onFoveaErrorResponse(Exception error) {
                    FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                    listener.onCompletion();
                }
            });
        } else {
            FoveaLog.v(this.TAG, "No Appinvitation records to send out");
            this.syncInfluenceGraph(reqManager, dataHelper, forUserID, new FoveaCompletionListener(){

                @Override
                public void onCompletion() {
                    listener.onCompletion();
                }
            });
        }
    }

    void syncInfluenceGraph(FoveaRequestResponseManager reqManager, final FoveaDataFetchHelper dataHelper, String forUserID, final FoveaCompletionListener listener) {
        dataHelper.purgeAppInvitesData(forUserID);
        reqManager.getInfluenceGraphRequest(new FoveaResponse.FoveaDataResponseListener(){

            public void onSuccessResponse(Object response) {
                String responseString = (String)response;
                Type listType = new TypeToken<List<AppInvite>>(){}.getType();
                List results = (List)new Gson().fromJson(responseString, listType);
                dataHelper.saveInfluenceGraph(results);
                listener.onCompletion();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
                FoveaLog.v(FoveaSynchronizationManager.this.TAG, "ErrorResponse: " + error.getLocalizedMessage());
                listener.onCompletion();
            }
        });
    }

    public static interface FoveaCompletionListener {
        public void onCompletion();
    }
}

