/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.providers;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.FoveaUserProfile;
import com.cogknit.fovea.dataModel.UserProfile;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.remote.FoveaResponse;

public class FoveaUserProfileManager {
    public void setUserProfile(FoveaUserProfile userProfile, Context context) {
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        Boolean hasAuthenticated = settings.getBoolean("isSDKAuthorized", false);
        Uri mUri = FoveaContract.UserProfile.CONTENT_USERPROFILE_URI;
        UserProfile newUserProfile = new UserProfile(userProfile, APIConstants.DefaultFoveaID);
        Cursor cursor = FoveaDatabaseManager.query(context, mUri, null, null, null, null);
        if (cursor.getCount() > 0) {
            FoveaDatabaseManager.delete(context, mUri, null, null);
        }
        cursor.close();
        FoveaDatabaseManager.insert(context, mUri, newUserProfile.getContentValues());
        settings.edit().putBoolean("hasPendingUPSync", true).commit();
        if (hasAuthenticated.booleanValue()) {
            this.performUserProfileSynchronization(context);
        }
    }

    public void performUserProfileSynchronization(Context context) {
        Uri mUri = FoveaContract.UserProfile.CONTENT_USERPROFILE_URI;
        Cursor c = FoveaDatabaseManager.query(context, mUri, null, null, null, null);
        int recordCount = c.getCount();
        FoveaUserProfile fup = null;
        String fovUserID = null;
        if (c.moveToNext()) {
            String name = c.getString(c.getColumnIndex("name"));
            String email = c.getString(c.getColumnIndex("emailID"));
            String uniqueID = c.getString(c.getColumnIndex("uniqueUserID"));
            String phoneNumber = c.getString(c.getColumnIndex("phoneNumber"));
            String dob = c.getString(c.getColumnIndex("dateOfBirth"));
            int gender = c.getInt(c.getColumnIndex("gender"));
            fovUserID = c.getString(c.getColumnIndex("foveaUserID"));
            fup = new FoveaUserProfile(uniqueID);
            fup.setUserName(name);
            fup.setEmailID(email);
            fup.setPhoneNumber(phoneNumber);
            fup.setDateOfBirth(dob);
            FoveaConstants.Gender genderEnum = FoveaConstants.Gender.values()[gender];
            fup.setGender(genderEnum);
        }
        c.close();
        if (fup != null && fovUserID != null) {
            this.uploadUserProfileData(fup, fovUserID, context);
        }
    }

    void uploadUserProfileData(FoveaUserProfile fup, String fovUserID, final Context context) {
        UserProfile userProfile = new UserProfile(fup, fovUserID);
        FoveaRequestResponseManager manager = new FoveaRequestResponseManager(context);
        manager.submitUserProfile(userProfile, new FoveaResponse.FoveaResponseListener(){

            @Override
            public void onSuccessResponse() {
                SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
                settings.edit().putBoolean("hasPendingUPSync", false).commit();
            }
        }, new FoveaResponse.FoveaErrorListener(){

            @Override
            public void onFoveaErrorResponse(Exception error) {
            }
        });
    }
}

