/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.receivers;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.cogknit.fovea.services.FacebookVolleySyncService;
import com.cogknit.fovea.services.FoveaSyncService;
import com.cogknit.fovea.services.LegacyAppUsageService;
import com.cogknit.fovea.services.LocalDataFetchService;
import com.cogknit.fovea.services.LocationController;
import com.cogknit.fovea.services.ScanAppUsageService;
import com.cogknit.fovea.utils.FoveaLog;

public class AlarmReceiver
extends WakefulBroadcastReceiver {
    public static final String TAG = "AlarmReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        FoveaLog.v(TAG, "Alarm: " + action);
        switch (action) {
            case "com.cogknit.goglocallibrary.actions.fetch.people": 
            case "com.cogknit.goglocallibrary.actions.fetch.history;": 
            case "com.cogknit.goglocallibrary.actions.fetch.sms": 
            case "com.cogknit.goglocallibrary.actions.fetch.calllogs": {
                intent.setClass(context, LocalDataFetchService.class);
                AlarmReceiver.startWakefulService((Context)context, (Intent)intent);
                break;
            }
            case "com.cogknit.goglocallibrary.actions.fetch.app": {
                Intent sIntent = Build.VERSION.SDK_INT < 21 ? new Intent(context, LegacyAppUsageService.class) : new Intent(context, ScanAppUsageService.class);
                AlarmReceiver.startWakefulService((Context)context, (Intent)sIntent);
                break;
            }
            case "com.cogknit.goglocallibrary.actions.remote.push": {
                intent.setClass(context, FoveaSyncService.class);
                AlarmReceiver.startWakefulService((Context)context, (Intent)intent);
                break;
            }
            case "com.cogknit.goglocallibrary.actions.location.track": {
                context.startService(new Intent(context, LocationController.class));
                break;
            }
            case "com.cogknit.fovea.fb.friends": 
            case "com.cogknit.fovea.fb.me": 
            case "com.cogknit.fovea.fb.likes": {
                intent.setClass(context, FacebookVolleySyncService.class);
                AlarmReceiver.startWakefulService((Context)context, (Intent)intent);
                break;
            }
            case "com.cogknit.goglocallibrary.actions.deviceUser.sync": {
                intent.setClass(context, FoveaSyncService.class);
                AlarmReceiver.startWakefulService((Context)context, (Intent)intent);
            }
        }
    }
}

