/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.receivers;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.cogknit.fovea.Fovea;
import com.cogknit.fovea.FoveaCallback;
import com.cogknit.fovea.FoveaConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.services.FoveaSyncService;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.ArrayList;

public class RefreshTokenReceiver
extends WakefulBroadcastReceiver {
    public static final String TAG = RefreshTokenReceiver.class.getSimpleName();

    public void onReceive(final Context context, final Intent intent) {
        String action = intent.getAction();
        FoveaLog.v(TAG, "RefreshTokenReceiver onReceive: " + action);
        SharedPreferences settings = context.getSharedPreferences("FoveaPrefsFile", 0);
        String appkey = settings.getString("appKey", "");
        String clientKey = settings.getString("clientKey", "");
        if (intent.getAction() == FoveaRequestResponseManager.REFRESHTOKEN_ACTION_TAG) {
            Fovea.initialize(context, appkey, clientKey, this.getActiveServices(context), new FoveaCallback(){

                @Override
                public void onCompletion() {
                    if (intent.getBooleanExtra(FoveaRequestResponseManager.CONEXTPUSH_ACTION_TYPE, false)) {
                        Intent intent1 = new Intent(context, FoveaSyncService.class);
                        intent1.setAction("com.cogknit.goglocallibrary.actions.remote.push");
                        context.startService(intent1);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                }
            });
        }
    }

    private FoveaConstants.Services[] getActiveServices(Context c) {
        ArrayList<FoveaConstants.Services> list = new ArrayList<FoveaConstants.Services>();
        for (FoveaConstants.Services service : FoveaConstants.Services.values()) {
            if (!service.getStatus(c)) continue;
            list.add(service);
        }
        FoveaConstants.Services[] contexts = new FoveaConstants.Services[list.size()];
        contexts = list.toArray(contexts);
        return contexts;
    }
}

