/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.services;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.remote.APIConstants;
import com.cogknit.fovea.remote.FoveaRequestResponseManager;
import com.cogknit.fovea.utils.FoveaLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookVolleySyncService
extends IntentService {
    private static final String TAG = "FBVolleySyncService";
    private static FoveaRequestResponseManager remote;
    private Intent intent;

    public FacebookVolleySyncService() {
        super("FacebookSyncService");
    }

    protected void onHandleIntent(Intent intent) {
        if (remote == null) {
            remote = new FoveaRequestResponseManager(this.getApplicationContext());
        }
        this.intent = intent;
        FoveaLog.d(TAG, "FBVolleySyncService invoked");
        if (this.isUserLoggedin()) {
            this.synchronize(intent.getAction());
        } else {
            FoveaLog.d(TAG, "Unable to Sync Facebook Data: No user logged in!");
        }
    }

    private void synchronize(String dataPoint) {
        switch (dataPoint) {
            case "com.cogknit.fovea.fb.me": {
                this.getMe();
                break;
            }
            case "com.cogknit.fovea.fb.friends": {
                this.getFriends();
                break;
            }
            case "com.cogknit.fovea.fb.likes": {
                this.getLikes();
                break;
            }
            default: {
                FoveaLog.e(TAG, "synchronize(): Invalid datapoint value.");
            }
        }
    }

    private void getMe() {
        String URL2 = GraphApiHelper.ME.getUrlWithParams(this.getCurrentAccessToken());
        remote.executeJsonRequest(URL2, null, new SimpleRequestCallback(new InitiateSyncCallback(APIConstants.getAPIClientURL((Context)this) + "fbprofile")), new ErrorCallback());
    }

    private void getLikes() {
        String URL2 = GraphApiHelper.LIKES.getUrlWithParams(this.getCurrentAccessToken());
        remote.executeJsonRequest(URL2, null, new PagedRequestCallback(new InitiateSyncCallback(APIConstants.getAPIClientURL((Context)this) + "fblikes")), new ErrorCallback());
    }

    private void getFriends() {
        String URL2 = GraphApiHelper.FRIENDS.getUrlWithParams(this.getCurrentAccessToken());
        remote.executeJsonRequest(URL2, null, new PagedRequestCallback(new InitiateSyncCallback(APIConstants.getAPIClientURL((Context)this) + "fbpeople")), new ErrorCallback());
    }

    private boolean isUserLoggedin() {
        String token = this.getCurrentAccessToken();
        return !token.isEmpty();
    }

    private String getCurrentAccessToken() {
        SharedPreferences prefs = this.getSharedPreferences("FbPrefsFile", 0);
        return prefs.getString("access_token", "");
    }

    public static enum GraphApiHelper {
        ME,
        LIKES,
        FRIENDS;

        public static final String BASE_URL = "https://graph.facebook.com";
        public static final String URL_ME = "https://graph.facebook.com/me";
        public static final String URL_LIKES = "https://graph.facebook.com/me/likes";
        public static final String URL_FRIENDS = "https://graph.facebook.com/me/friends";
        public static String TOKEN_FORMAT;

        public String getUrlWithParams(String token) {
            String url = "";
            switch (this) {
                case ME: {
                    url = URL_ME;
                    break;
                }
                case LIKES: {
                    url = URL_LIKES;
                    break;
                }
                case FRIENDS: {
                    url = URL_FRIENDS;
                }
            }
            return url + "?" + this.getAccessTokenParam(token) + "&" + this.getFieldsParam();
        }

        private String getAccessTokenParam(String token) {
            return String.format(TOKEN_FORMAT, token);
        }

        private String getFieldsParam() {
            String param = "";
            switch (this) {
                case ME: {
                    param = "fields=id,name,link,gender,location,religion,age_range,email,sports,work,devices,birthday,bio,about";
                    break;
                }
                case LIKES: 
                case FRIENDS: {
                    param = "fields=id";
                }
            }
            return param;
        }

        static {
            TOKEN_FORMAT = "access_token=%s";
        }
    }

    private static interface ConsolidatedCallback {
        public void onCompleted(String var1);

        public void onError(Exception var1);
    }

    private class ErrorCallback
    implements Response.ErrorListener {
        private ErrorCallback() {
        }

        public void onErrorResponse(VolleyError error) {
            VolleyLog.e((String)"Error: ", (Object[])new Object[]{error.getMessage()});
        }
    }

    private class PagedRequestCallback
    implements Response.Listener<JSONObject> {
        private ConsolidatedCallback callback;
        private int count;
        private JSONArray jsonPayload;

        public PagedRequestCallback(ConsolidatedCallback callback) {
            this.callback = callback;
            this.jsonPayload = new JSONArray();
            this.count = 0;
        }

        public void onResponse(JSONObject response) {
            FoveaLog.d(FacebookVolleySyncService.TAG, "Page " + ++this.count + ": " + response.toString());
            try {
                this.jsonPayload = this.mergeArrays(this.jsonPayload, response.getJSONArray("data"));
                if (this.hasNext(response)) {
                    remote.executeJsonRequest(this.getNextUrl(response), null, this, new ErrorCallback());
                } else {
                    this.callback.onCompleted(this.jsonPayload.toString());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.callback.onError((Exception)((Object)e));
            }
        }

        private boolean hasNext(JSONObject response) throws JSONException {
            return response.has("paging") && response.getJSONObject("paging").has("next");
        }

        private String getNextUrl(JSONObject response) throws JSONException {
            return response.getJSONObject("paging").getString("next");
        }

        private JSONArray mergeArrays(JSONArray a, JSONArray b) {
            JSONArray merged = new JSONArray();
            try {
                int i;
                for (i = 0; i < a.length(); ++i) {
                    merged.put(a.get(i));
                }
                for (i = 0; i < b.length(); ++i) {
                    merged.put(b.get(i));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return merged;
        }
    }

    private class SimpleRequestCallback
    implements Response.Listener<JSONObject> {
        ConsolidatedCallback callback;

        public SimpleRequestCallback(ConsolidatedCallback callback) {
            this.callback = callback;
        }

        public void onResponse(JSONObject response) {
            this.callback.onCompleted(response.toString());
        }
    }

    private class InitiateSyncCallback
    implements ConsolidatedCallback {
        private String url;

        public InitiateSyncCallback(String url) {
            this.url = url;
        }

        @Override
        public void onCompleted(String payload) {
            this.makeVolleyRequest(this.url, payload);
            AlarmReceiver.completeWakefulIntent((Intent)FacebookVolleySyncService.this.intent);
        }

        @Override
        public void onError(Exception e) {
            e.printStackTrace();
        }

        private void makeVolleyRequest(String urlString, String payload) {
            FoveaLog.d(FacebookVolleySyncService.TAG, "Sending to FOVEA: " + payload);
            remote.sendFbData(urlString, payload);
        }
    }
}

