/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.services;

import android.app.ActivityManager;
import android.app.IntentService;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import com.cogknit.fovea.dataModel.App;
import com.cogknit.fovea.providers.FoveaContract;
import com.cogknit.fovea.providers.FoveaDatabaseManager;
import com.cogknit.fovea.receivers.AlarmReceiver;
import com.cogknit.fovea.utils.FoveaLog;
import java.util.List;

public class LegacyAppUsageService
extends IntentService {
    public static final String TAG = "LegacyAppUsageService";
    public static final long INTERVAL = 5000L;

    public LegacyAppUsageService() {
        super("LegacyAppService");
    }

    private void pollApps() {
        String taskAppName = null;
        String taskPackageName = null;
        PackageInfo appPackageInfo = null;
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        PackageManager pm = this.getPackageManager();
        List runningTasks = am.getRunningTasks(1);
        Uri mUri = FoveaContract.Apps.CONTENT_APP_URI;
        try {
            ActivityManager.RunningTaskInfo task = (ActivityManager.RunningTaskInfo)runningTasks.get(0);
            taskPackageName = task.topActivity.getPackageName();
            appPackageInfo = pm.getPackageInfo(taskPackageName, 0);
            taskAppName = appPackageInfo.applicationInfo.loadLabel(pm).toString();
            String selection = "packageName = \"" + taskPackageName + "\"";
            Cursor c = FoveaDatabaseManager.query(this.getApplicationContext(), mUri, null, selection, null, null);
            if (c.moveToNext()) {
                String name = c.getString(c.getColumnIndex("name"));
                String pkgNm = c.getString(c.getColumnIndex("packageName"));
                int appId = c.getInt(c.getColumnIndex("_id"));
                long foreground = c.getLong(c.getColumnIndex("foregroundTime"));
                App app = new App(name, pkgNm, foreground, "");
                app.addForegroundTime(5L);
                FoveaDatabaseManager.update(this.getApplicationContext(), Uri.withAppendedPath((Uri)mUri, (String)("" + appId)), app.getContentValues(), null, null);
            } else {
                App app = new App(taskAppName, taskPackageName, 5L, "");
                FoveaDatabaseManager.insert(this.getApplicationContext(), mUri, app.getContentValues());
            }
            c.close();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void onHandleIntent(Intent intent) {
        FoveaLog.i(TAG, "Capturing..");
        this.pollApps();
        AlarmReceiver.completeWakefulIntent((Intent)intent);
    }
}

