/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.utils;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.util.Patterns;
import com.cogknit.fovea.FoveaConstants;
import java.util.regex.Pattern;

public class DeviceUtility {
    private static String PERMISSION_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private static String PERMISSION_CALL_LOG = "android.permission.READ_CALL_LOG";
    private static String PERMISSION_SEND_SMS = "android.permission.SEND_SMS";
    private static String PERMISSION_APPS_USAGE = "android.permission.PACKAGE_USAGE_STATS";
    private static String PERMISSION__LEGACY_APPS_USAGE = "android.permission.GET_TASKS";
    private static String PERMISSION_LOCATION = "android.permission.ACCESS_COARSE_LOCATION";
    private static String ACTIVITY_RECOGNITION = "com.google.android.gms.permission.ACTIVITY_RECOGNITION";
    private static String PERMISSION_BROWSER_HISTORY = "com.android.browser.permission.READ_HISTORY_BOOKMARKS";

    public static String getDevicePhoneNumber(Context context) {
        TelephonyManager tMgr;
        String mPhoneNumber = "Unknown";
        String permission = PERMISSION_PHONE_STATE;
        if (DeviceUtility.isPermissionGranted(context, permission) && ((mPhoneNumber = (tMgr = (TelephonyManager)context.getSystemService("phone")).getLine1Number()) == null || mPhoneNumber.equals(""))) {
            mPhoneNumber = "Unknown";
        }
        return mPhoneNumber;
    }

    public static String getDeviceEmail(Context context) {
        Account[] accounts;
        Pattern emailPattern = Patterns.EMAIL_ADDRESS;
        for (Account account : accounts = AccountManager.get((Context)context).getAccounts()) {
            if (!emailPattern.matcher(account.name).matches()) continue;
            String possibleEmail = account.name;
            return possibleEmail;
        }
        return null;
    }

    private static boolean isPermissionGranted(Context context, String permission) {
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    @TargetApi(value=21)
    private static boolean isAppUsageStatsPermissionGranted(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return DeviceUtility.isPermissionGranted(context, PERMISSION__LEGACY_APPS_USAGE);
        }
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        boolean granted = appOps.checkOpNoThrow("android:get_usage_stats", Process.myUid(), context.getPackageName()) == 0;
        return granted;
    }

    public static boolean checkIfPermissionsGrantedAndEnableContexts(Context context, FoveaConstants.Services service) {
        boolean permissible = false;
        SharedPreferences pref = context.getSharedPreferences("FoveaPrefsFile", 0);
        switch (service) {
            case APP_VIRALITY: {
                if (!DeviceUtility.isPermissionGranted(context, PERMISSION_CALL_LOG) || !DeviceUtility.isPermissionGranted(context, PERMISSION_SEND_SMS)) break;
                permissible = true;
                pref.edit().putBoolean("com.cogknit.fovea.context.people", true).commit();
                break;
            }
            case APP_USAGE_DASHBOARD: {
                if (!DeviceUtility.isAppUsageStatsPermissionGranted(context)) break;
                permissible = true;
                pref.edit().putBoolean("com.cogknit.fovea.context.apps", true).commit();
                break;
            }
            case APP_USERLOCATION_DASHBOARD: {
                if (!DeviceUtility.isPermissionGranted(context, PERMISSION_LOCATION) || !DeviceUtility.isPermissionGranted(context, ACTIVITY_RECOGNITION)) break;
                permissible = true;
                pref.edit().putBoolean("com.cogknit.fovea.context.locations", true).commit();
                break;
            }
            case DISCOVERY: {
                if (!DeviceUtility.isPermissionGranted(context, PERMISSION_APPS_USAGE) && !DeviceUtility.isPermissionGranted(context, PERMISSION_CALL_LOG) && !DeviceUtility.isPermissionGranted(context, PERMISSION_BROWSER_HISTORY)) break;
                permissible = true;
                if (DeviceUtility.isPermissionGranted(context, PERMISSION_BROWSER_HISTORY)) {
                    pref.edit().putBoolean("com.cogknit.fovea.context.history", true).commit();
                }
                if (DeviceUtility.isPermissionGranted(context, PERMISSION_CALL_LOG)) {
                    pref.edit().putBoolean("com.cogknit.fovea.context.people", true).commit();
                }
                if (!DeviceUtility.isAppUsageStatsPermissionGranted(context)) break;
                pref.edit().putBoolean("com.cogknit.fovea.context.apps", true).commit();
                break;
            }
            case FB: {
                return true;
            }
        }
        return permissible;
    }
}

