/*
 * Decompiled with CFR 0.152.
 */
package com.cogknit.fovea.utils;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.cogknit.fovea.services.FusedIntentService;
import com.cogknit.fovea.utils.FoveaLog;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.ActivityRecognition;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class FusedLocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final int FIX_PLAY_SERVICES = 1;
    private boolean connected;
    private boolean connecting;
    private GoogleApiClient mGoogleApiClient;
    private Context context;
    private PendingIntent pIntent;
    private boolean activeLocationRequest;
    private boolean activeActivityRequest;
    private long locationInterval;
    private long activityInterval;
    private static final String TAG = "LocationController";

    public FusedLocationManager(Context context) {
        this.context = context;
        this.mGoogleApiClient = new GoogleApiClient.Builder(context, (GoogleApiClient.ConnectionCallbacks)this, (GoogleApiClient.OnConnectionFailedListener)this).addApi(ActivityRecognition.API).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        Intent intent = new Intent(context, FusedIntentService.class);
        this.pIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x10000000);
        this.connected = false;
        this.activeLocationRequest = false;
        this.activeActivityRequest = false;
    }

    private void connect() {
        if (this.servicesAvailable() && !this.connecting) {
            this.connecting = true;
            this.mGoogleApiClient.connect();
        }
    }

    public boolean servicesAvailable() {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.context);
        if (resultCode == 0) {
            return true;
        }
        FoveaLog.v(TAG, "Google play services are not available, please do the needful!");
        return false;
    }

    private void disconnect() {
        this.connecting = false;
        if (this.connected) {
            this.mGoogleApiClient.disconnect();
        }
        this.connected = false;
    }

    public void shutDown() {
        ActivityRecognition.ActivityRecognitionApi.removeActivityUpdates(this.mGoogleApiClient, this.pIntent);
        LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.pIntent);
        this.disconnect();
    }

    public void onConnectionFailed(ConnectionResult arg0) {
        this.connected = false;
    }

    public void onConnected(Bundle arg0) {
        this.connecting = false;
        this.connected = true;
        if (this.activeLocationRequest) {
            this.requestLocationUpdate(this.locationInterval);
        }
        if (this.activeActivityRequest) {
            this.requestActivityUpdate(this.activityInterval);
        }
    }

    public void onConnectionSuspended(int arg0) {
        this.connected = false;
    }

    private LocationRequest getLocationRequest(long interval) {
        LocationRequest request = LocationRequest.create();
        request.setInterval(interval);
        request.setPriority(102);
        return request;
    }

    public void requestActivityUpdate(long interval) {
        this.activityInterval = interval;
        if (this.connected) {
            if (interval == -1L) {
                ActivityRecognition.ActivityRecognitionApi.removeActivityUpdates(this.mGoogleApiClient, this.pIntent);
            } else {
                ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates(this.mGoogleApiClient, this.activityInterval, this.pIntent);
            }
            this.activeActivityRequest = false;
            this.disconnect();
        } else {
            this.activeActivityRequest = true;
            this.connect();
        }
    }

    public void requestLocationUpdate(long interval) {
        this.locationInterval = interval;
        if (this.connected) {
            if (interval == -1L) {
                LocationServices.FusedLocationApi.removeLocationUpdates(this.mGoogleApiClient, this.pIntent);
            } else {
                LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, this.getLocationRequest(interval), this.pIntent);
            }
            this.activeLocationRequest = false;
            this.disconnect();
        } else {
            this.activeLocationRequest = true;
            this.connect();
        }
    }
}

