/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.Engine;
import fmpp.tdd.DataLoader;
import fmpp.util.StringUtil;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateTransformModel;
import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.devlib.schmidt.imageinfo.ImageInfo;

public class HtmlUtilsDataLoader
implements DataLoader {
    private boolean xHtml = false;
    private String eTagClose;
    private Engine engine;
    private static final int MAX_CACHE_SIZE = 100;
    private Map imageInfoCache = new HashMap();
    private CachedImageInfo first;
    private CachedImageInfo last;
    private ImageInfo imageInfo = new ImageInfo();

    public Object load(Engine e, List args) throws Exception {
        if (args.size() != 0) {
            throw new IllegalArgumentException("data loader does not have arguments");
        }
        this.engine = e;
        this.eTagClose = this.xHtml ? " />" : ">";
        HashMap<String, ImgTransform> map = new HashMap<String, ImgTransform>();
        map.put("img", new ImgTransform());
        return map;
    }

    public void setXHtml(boolean xHtml) {
        this.xHtml = xHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedImageInfo getImageInfo(File f) throws IOException, TemplateModelException {
        RandomAccessFile raf;
        String cacheKey = f.getCanonicalPath();
        CachedImageInfo inf = (CachedImageInfo)this.imageInfoCache.get(cacheKey);
        if (inf != null) {
            long lmd = new File(cacheKey).lastModified();
            if (inf.lmd == lmd && lmd != 0L && inf.lmd != 0L) {
                if (inf != this.last) {
                    if (inf.prev != null) {
                        inf.prev.next = inf.next;
                    } else {
                        this.first = inf.next;
                    }
                    if (inf.next != null) {
                        inf.next.prev = inf.prev;
                    } else {
                        this.last = inf.prev;
                    }
                    inf.prev = this.last;
                    inf.next = null;
                    this.last = inf;
                    inf.prev.next = this.last;
                }
                return inf;
            }
            this.imageInfoCache.remove(cacheKey);
            if (inf.prev != null) {
                inf.prev.next = inf.next;
            } else {
                this.first = inf.next;
            }
            if (inf.next != null) {
                inf.next.prev = inf.prev;
            } else {
                this.last = inf.prev;
            }
        }
        try {
            raf = new RandomAccessFile(f, "r");
        }
        catch (FileNotFoundException e) {
            throw new TemplateModelException("Image file not found: " + f.getAbsolutePath(), (Exception)e);
        }
        try {
            this.imageInfo.setCollectComments(false);
            this.imageInfo.setInput((DataInput)raf);
            if (!this.imageInfo.check()) {
                throw new TemplateModelException("Failed to analyse image file: " + cacheKey);
            }
        }
        finally {
            raf.close();
        }
        inf = new CachedImageInfo();
        inf.lmd = f.lastModified();
        inf.width = this.imageInfo.getWidth();
        inf.height = this.imageInfo.getHeight();
        inf.path = cacheKey;
        if (this.last != null) {
            this.last.next = inf;
        }
        inf.prev = this.last;
        inf.next = null;
        this.last = inf;
        if (inf.prev == null) {
            this.first = inf;
        }
        this.imageInfoCache.put(cacheKey, inf);
        if (this.imageInfoCache.size() > 100) {
            this.imageInfoCache.remove(this.first.path);
            this.first.next.prev = null;
            this.first = this.first.next;
        }
        return inf;
    }

    private class ImgTransform
    implements TemplateTransformModel {
        private ImgTransform() {
        }

        public Writer getWriter(Writer out, Map args) throws TemplateModelException, IOException {
            boolean detectHeight = true;
            boolean detectWidth = true;
            String src = null;
            out.write("<img");
            Iterator it = args.entrySet().iterator();
            while (it.hasNext()) {
                String pvalue;
                Map.Entry e = it.next();
                String pname = (String)e.getKey();
                Object obj = e.getValue();
                if (obj instanceof TemplateScalarModel) {
                    pvalue = ((TemplateScalarModel)obj).getAsString();
                } else if (obj instanceof TemplateNumberModel) {
                    pvalue = ((TemplateNumberModel)obj).getAsNumber().toString();
                } else if (obj instanceof TemplateBooleanModel) {
                    pvalue = null;
                    if (((TemplateBooleanModel)obj).getAsBoolean()) {
                        out.write(" " + pname);
                    }
                } else {
                    throw new TemplateModelException("Argument to img must be string, number or boolean");
                }
                if (pvalue == null) continue;
                pname = pname.toLowerCase();
                out.write(" " + pname + "=\"" + StringUtil.htmlEnc(pvalue) + "\"");
                if (pname.equals("src")) {
                    src = pvalue;
                    continue;
                }
                if (pname.equals("width")) {
                    detectWidth = false;
                    continue;
                }
                if (!pname.equals("height")) continue;
                detectHeight = false;
            }
            if (detectWidth || detectHeight) {
                if (src == null) {
                    throw new TemplateModelException("The src attribute of img is missing");
                }
                CachedImageInfo inf = HtmlUtilsDataLoader.this.getImageInfo(HtmlUtilsDataLoader.this.engine.getTemplateEnvironment().resolveSourcePath(src));
                if (detectWidth) {
                    out.write(" width=\"" + inf.width + "\"");
                }
                if (detectHeight) {
                    out.write(" height=\"" + inf.height + "\"");
                }
            }
            out.write(HtmlUtilsDataLoader.this.eTagClose);
            return null;
        }
    }

    private class CachedImageInfo {
        private CachedImageInfo prev;
        private CachedImageInfo next;
        private String path;
        private long lmd;
        private int width;
        private int height;

        private CachedImageInfo() {
        }
    }
}

