/*
 * Decompiled with CFR 0.152.
 */
package fmpp.models;

import fmpp.models.JSONArrayNode;
import fmpp.models.JSONBooleanNode;
import fmpp.models.JSONNullNode;
import fmpp.models.JSONNumberNode;
import fmpp.models.JSONObjectNode;
import fmpp.models.JSONStringNode;
import fmpp.util.StringUtil;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class JSONNode
implements TemplateNodeModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private final JSONNode parentNode;
    private final String nodeName;

    protected static String nodeTypeToDefaultNodeName(String nodeType) {
        return "unnamed" + StringUtil.capitalizeFirst(nodeType);
    }

    protected JSONNode(JSONNode parentNode, String nodeName) {
        this.parentNode = parentNode;
        this.nodeName = nodeName != null ? nodeName : this.getDefaultNodeName();
    }

    protected abstract String getDefaultNodeName();

    public final TemplateNodeModel getParentNode() throws TemplateModelException {
        return this.parentNode;
    }

    public final String getNodeName() throws TemplateModelException {
        return this.nodeName;
    }

    public final String getNodeNamespace() throws TemplateModelException {
        return null;
    }

    public static JSONNode wrap(Object jsonPOJO) throws TemplateModelException {
        return JSONNode.wrap(jsonPOJO, null, null, false);
    }

    protected static JSONNode wrap(Object obj, JSONNode parentNode, String nodeName, boolean wrapNullAsJSONNullNode) throws TemplateModelException {
        if (obj == null) {
            return wrapNullAsJSONNullNode ? new JSONNullNode(parentNode, nodeName) : null;
        }
        if (obj instanceof String) {
            return new JSONStringNode(parentNode, nodeName, (String)obj);
        }
        if (obj instanceof Number) {
            return new JSONNumberNode(parentNode, nodeName, (Number)obj);
        }
        if (obj instanceof Boolean) {
            return new JSONBooleanNode(parentNode, nodeName, (Boolean)obj);
        }
        if (obj instanceof List) {
            return new JSONArrayNode(parentNode, nodeName, (List)obj);
        }
        if (obj instanceof Map) {
            return new JSONObjectNode(parentNode, nodeName, (Map)obj);
        }
        throw new TemplateModelException("Can't warp an object of this class as JSON node: " + obj.getClass().getName());
    }
}

